/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import com.demonwav.mcdev.annotations.Translatable;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.utils.Constants;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;

public class Tips {
    private static final String modVersion = SkyblockerMod.VERSION.split("\\+")[0];
    private static int currentTipIndex = 0;
    private static final List<Supplier<class_2561>> TIPS = new ArrayList<Supplier>(List.of(Tips.getTipFactory("skyblocker.tips.customItemNames", class_2558.class_2559.field_11745, "/skyblocker custom renameItem"), Tips.getTipFactory("skyblocker.tips.customArmorDyeColors", class_2558.class_2559.field_11745, "/skyblocker custom"), Tips.getTipFactory("skyblocker.tips.customArmorTrims", class_2558.class_2559.field_11745, "/skyblocker custom"), Tips.getTipFactory("skyblocker.tips.customAnimatedDyes", class_2558.class_2559.field_11745, "/skyblocker custom"), Tips.getTipFactory("skyblocker.tips.fancyTabExtraInfo"), Tips.getTipFactory("skyblocker.tips.helpCommand", class_2558.class_2559.field_11745, "/skyblocker help"), Tips.getTipFactory("skyblocker.tips.discordRichPresence", class_2558.class_2559.field_11745, "/skyblocker config"), Tips.getTipFactory("skyblocker.tips.customDungeonSecretWaypoints", class_2558.class_2559.field_11745, "/skyblocker dungeons secrets addWaypoint"), Tips.getTipFactory("skyblocker.tips.shortcuts", class_2558.class_2559.field_11745, "/skyblocker shortcuts"), Tips.getTipFactory("skyblocker.tips.gallery", class_2558.class_2559.field_11749, "https://hysky.de/skyblocker/gallery"), Tips.getTipFactory("skyblocker.tips.itemRarityBackground", class_2558.class_2559.field_11745, "/skyblocker config"), Tips.getTipFactory("skyblocker.tips.modMenuUpdate"), Tips.getTipFactory("skyblocker.tips.issues", class_2558.class_2559.field_11749, "https://github.com/SkyblockerMod/Skyblocker/issues"), Tips.getTipFactory("skyblocker.tips.beta", class_2558.class_2559.field_11749, "https://github.com/SkyblockerMod/Skyblocker/actions"), Tips.getTipFactory("skyblocker.tips.contribute", class_2558.class_2559.field_11749, "https://github.com/SkyblockerMod/Skyblocker/wiki/contribute"), Tips.getTipFactory("skyblocker.tips.discord", class_2558.class_2559.field_11749, "https://discord.gg/aNNJHQykck"), Tips.getTipFactory("skyblocker.tips.flameOverlay", class_2558.class_2559.field_11745, "/skyblocker config"), Tips.getTipFactory("skyblocker.tips.wikiLookup", class_2558.class_2559.field_11745, "/skyblocker config"), Tips.getTipFactory("skyblocker.tips.protectItem", class_2558.class_2559.field_11745, "/skyblocker protectItem"), Tips.getTipFactory("skyblocker.tips.fairySoulsEnigmaSoulsRelics", class_2558.class_2559.field_11745, "/skyblocker fairySouls"), Tips.getTipFactory("skyblocker.tips.quickNav", class_2558.class_2559.field_11745, "/skyblocker config"), Tips.getTipFactory("skyblocker.tips.waypoints", class_2558.class_2559.field_11745, "/skyblocker waypoint"), Tips.getTipFactory("skyblocker.tips.orderedWaypoints", class_2558.class_2559.field_11745, "/skyblocker waypoints"), Tips.getTipFactory("skyblocker.tips.visitorHelper"), Tips.getTipFactory("skyblocker.tips.slotText"), Tips.getTipFactory("skyblocker.tips.profileViewer", class_2558.class_2559.field_11745, "/pv"), Tips.getTipFactory("skyblocker.tips.configSearch", class_2558.class_2559.field_11745, "/skyblocker config"), Tips.getTipFactory("skyblocker.tips.configureNewFeatures", class_2558.class_2559.field_11745, "/skyblocker config v" + modVersion, modVersion), Tips.getTipFactory("skyblocker.tips.compactDamage", class_2558.class_2559.field_11745, "/skyblocker config"), Tips.getTipFactory("skyblocker.tips.skyblockerScreen", class_2558.class_2559.field_11745, "/skyblocker"), Tips.getTipFactory("skyblocker.tips.tipsClick", class_2558.class_2559.field_11745, "/skyblocker tips next"), Tips.getTipFactory("skyblocker.tips.eventNotifications", class_2558.class_2559.field_11745, "/skyblocker config"), Tips.getTipFactory("skyblocker.tips.signCalculator"), Tips.getTipFactory("skyblocker.tips.calculateCommand", class_2558.class_2559.field_11745, "/skyblocker calculate"), Tips.getTipFactory("skyblocker.tips.fancierBars", class_2558.class_2559.field_11745, "/skyblocker bars"), Tips.getTipFactory("skyblocker.tips.crystalWaypointsShare", class_2558.class_2559.field_11745, "/skyblocker crystalWaypoints share"), Tips.getTipFactory("skyblocker.tips.gardenMouseLock", class_2558.class_2559.field_11745, "/skyblocker config"), Tips.getTipFactory("skyblocker.tips.newYearCakesHelper"), Tips.getTipFactory("skyblocker.tips.accessoryHelper"), Tips.getTipFactory("skyblocker.tips.fancyAuctionHouseCheapHighlight"), Tips.getTipFactory("skyblocker.tips.viewRecipe")));
    private static boolean sentTip = false;

    private static Supplier<class_2561> getTipFactory(@Translatable String key) {
        return () -> class_2561.method_43471((String)key);
    }

    private static Supplier<class_2561> getTipFactory(@Translatable String key, class_2558.class_2559 clickAction, String value) {
        return Tips.getTipFactory(key, clickAction, value, new Object[0]);
    }

    private static Supplier<class_2561> getTipFactory(@Translatable String key, class_2558.class_2559 clickAction, String value, Object ... args) {
        class_2558.class_10610 event = switch (clickAction) {
            case class_2558.class_2559.field_11745 -> new class_2558.class_10610(value);
            case class_2558.class_2559.field_11749 -> new class_2558.class_10608(URI.create(value));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(clickAction));
        };
        return () -> Tips.lambda$getTipFactory$2(key, args, (class_2558)event);
    }

    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register(Tips::registerTipsCommand);
        SkyblockEvents.JOIN.register(Tips::sendNextTip);
        Collections.shuffle(TIPS);
    }

    private static void registerTipsCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"tips").then(ClientCommandManager.literal((String)"enable").executes(Tips::enableTips))).then(ClientCommandManager.literal((String)"disable").executes(Tips::disableTips))).then(ClientCommandManager.literal((String)"previous").executes(Tips::sendPreviousTipCommand))).then(ClientCommandManager.literal((String)"next").executes(Tips::sendNextTipCommand))));
    }

    private static int enableTips(CommandContext<FabricClientCommandSource> context) {
        SkyblockerConfigManager.update(config -> {
            config.general.enableTips = true;
        });
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.tips.enabled")).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.tips.clickDisable").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/skyblocker tips disable")))));
        return 1;
    }

    private static int disableTips(CommandContext<FabricClientCommandSource> context) {
        SkyblockerConfigManager.update(config -> {
            config.general.enableTips = false;
        });
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.tips.disabled")).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.tips.clickEnable").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/skyblocker tips enable")))));
        return 1;
    }

    private static void sendNextTip() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && SkyblockerConfigManager.get().general.enableTips && !sentTip) {
            client.field_1724.method_7353(Tips.tipMessage(Tips.nextTip()), false);
            sentTip = true;
        }
    }

    private static int sendNextTipCommand(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback(Tips.tipMessage(Tips.nextTip()));
        return 1;
    }

    public static class_2561 nextTip() {
        return class_2561.method_43469((String)"skyblocker.tips.tip", (Object[])new Object[]{Tips.nextTipInternal()});
    }

    private static class_2561 nextTipInternal() {
        ++currentTipIndex;
        return TIPS.get(currentTipIndex %= TIPS.size()).get();
    }

    private static int sendPreviousTipCommand(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback(Tips.tipMessage(Tips.previousTip()));
        return 1;
    }

    public static class_2561 previousTip() {
        return class_2561.method_43469((String)"skyblocker.tips.tip", (Object[])new Object[]{Tips.previousTipInternal()});
    }

    private static class_2561 previousTipInternal() {
        --currentTipIndex;
        currentTipIndex += TIPS.size();
        return TIPS.get(currentTipIndex %= TIPS.size()).get();
    }

    private static class_2561 tipMessage(class_2561 tip) {
        return Constants.PREFIX.get().method_10852(tip).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.tips.clickPreviousTip").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/skyblocker tips previous")))).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.tips.clickNextTip").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/skyblocker tips next")))).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.tips.clickDisable").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/skyblocker tips disable"))));
    }

    private static /* synthetic */ class_2561 lambda$getTipFactory$2(String key, Object[] args, class_2558 event) {
        return class_2561.method_43469((String)key, (Object[])args).method_27694(style -> style.method_10958(event));
    }
}

