/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.auction;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.skyblock.auction.AuctionHouseScreenHandler;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.render.gui.AbstractCustomHypixelGUI;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import net.minecraft.class_8816;
import org.joml.Matrix3x2fStack;

public class AuctionViewScreen
extends AbstractCustomHypixelGUI<AuctionHouseScreenHandler> {
    protected static final class_2960 BACKGROUND_TEXTURE = SkyblockerMod.id("textures/gui/auctions_gui/browser/background_view.png");
    public static final int BACK_BUTTON_SLOT = 49;
    class_8667 verticalLayout = class_8667.method_52741();
    public final boolean isBinAuction;
    private class_7842 priceWidget;
    private final class_2561 clickToEditBidText = class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.editBid").method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
    private class_7842 infoTextWidget;
    public String minBid = "";
    private BuyState buyState = null;
    private class_5250 priceText = class_2561.method_43470((String)"?");
    private class_4185 buyButton;
    private class_7842 priceTextWidget;
    private int buySlotID = -1;
    private boolean priceParsed = false;
    private boolean wonAuction = true;
    private boolean changeProfile = false;

    public AuctionViewScreen(AuctionHouseScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.field_2779 = 187;
        this.isBinAuction = this.method_25440().getString().toLowerCase(Locale.ENGLISH).contains("bin");
        this.field_25270 = 93;
        this.field_25267 = 5;
        this.field_25268 = 4;
    }

    public boolean method_25404(class_11908 input) {
        if (input.method_74231()) {
            this.clickSlot(49);
            return true;
        }
        return super.method_25404(input);
    }

    protected void method_25426() {
        super.method_25426();
        this.verticalLayout = class_8667.method_52741();
        this.verticalLayout.method_52735(2).method_52740().method_46467();
        this.priceTextWidget = new class_7842((class_2561)(this.isBinAuction ? class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.price") : class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.newBid")), this.field_22793).method_73395(this.field_2792 - 10, class_7842.class_11764.field_62127);
        this.verticalLayout.method_52736((class_8021)this.priceTextWidget);
        this.priceWidget = new class_7842((class_2561)class_2561.method_43470((String)"?"), this.field_22793).method_73395(this.field_2792 - 10, class_7842.class_11764.field_62127);
        this.priceWidget.field_22763 = true;
        this.verticalLayout.method_52736((class_8021)this.priceWidget);
        this.infoTextWidget = new class_7842((class_2561)class_2561.method_43470((String)"Can't Afford"), this.field_22793).method_73395(this.field_2792 - 10, class_7842.class_11764.field_62127);
        this.verticalLayout.method_52736((class_8021)this.infoTextWidget);
        this.buyButton = class_4185.method_46430((class_2561)(this.isBinAuction ? class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.buy") : class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.bid")), button -> {
            if (this.buySlotID == -1) {
                return;
            }
            this.clickSlot(this.buySlotID);
        }).method_46437(60, 15).method_46431();
        this.verticalLayout.method_52736((class_8021)this.buyButton);
        this.verticalLayout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.updateLayout();
        class_4185 backButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"<"), button -> this.clickSlot(49)).method_46433(this.field_2776 + this.field_2792 - 16, this.field_2800 + 4).method_46437(12, 12).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"or press ESC!"))).method_46431();
        backButton.method_47402(Duration.ofSeconds(1L));
        this.method_37063((class_364)backButton);
    }

    private void changeState(BuyState newState) {
        if (newState == this.buyState) {
            return;
        }
        this.buyState = newState;
        switch (this.buyState.ordinal()) {
            case 0: {
                this.infoTextWidget.method_25355((class_2561)class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.cantAfford").method_54663(-65536));
                this.buyButton.field_22763 = false;
                break;
            }
            case 2: {
                this.infoTextWidget.method_25355((class_2561)class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.alreadyTopBid").method_54663(-171));
                break;
            }
            case 1: {
                this.infoTextWidget.method_25355((class_2561)class_2561.method_43473());
                break;
            }
            case 3: {
                this.infoTextWidget.method_25355((class_2561)(this.changeProfile ? class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.differentProfile") : (this.wonAuction ? class_2561.method_43473() : class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.didntWin"))));
                this.priceWidget.field_22763 = false;
                if (this.changeProfile) {
                    this.buyButton.method_25355((class_2561)class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.changeProfile").method_10862(class_2583.field_24360.method_10977(class_124.field_1075)));
                } else if (this.wonAuction) {
                    this.buyButton.method_25355((class_2561)class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.collectAuction"));
                } else {
                    this.buyButton.method_25355((class_2561)class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.collectBid"));
                }
                this.buyButton.method_25358(this.field_22793.method_27525((class_5348)this.buyButton.method_25369()) + 4);
                this.priceTextWidget.method_25355((class_2561)class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.auctionEnded"));
                break;
            }
            case 4: {
                this.buyButton.method_25355((class_2561)class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.cancelAuction").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
                this.buyButton.method_25358(this.field_22793.method_27525((class_5348)this.buyButton.method_25369()) + 4);
                this.buyButton.field_22763 = true;
                this.buyButton.field_22764 = true;
                break;
            }
            case 5: {
                this.buyButton.field_22764 = false;
                this.priceWidget.field_22763 = false;
                this.infoTextWidget.method_25355((class_2561)class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.yourAuction"));
            }
        }
        this.updateLayout();
    }

    private void updateLayout() {
        this.verticalLayout.method_48222();
        class_7843.method_46442((class_8021)this.verticalLayout, (int)this.field_2776, (int)(this.field_2800 + 36), (int)this.field_2792, (int)60);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25290(class_10799.field_56883, BACKGROUND_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.isWaitingForServer) {
            context.method_51433(this.field_22793, "Waiting...", 0, 0, -1, true);
        }
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)(this.field_2776 + 77), (float)(this.field_2800 + 14));
        matrices.scale(1.375f, 1.375f);
        class_1799 stack = ((AuctionHouseScreenHandler)this.field_2797).method_7611(13).method_7677();
        context.method_51427(stack, 0, 0);
        context.method_51431(this.field_22793, stack, 0, 0);
        matrices.popMatrix();
        if (!this.isBinAuction && this.buyState != BuyState.COLLECT_AUCTION) {
            if (this.priceWidget.method_25405((double)mouseX, (double)mouseY) && this.buyState != BuyState.CANT_AFFORD) {
                this.priceWidget.method_25355(this.clickToEditBidText);
            } else {
                this.priceWidget.method_25355((class_2561)this.priceText);
            }
        }
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2380(class_332 context, int x, int y) {
        super.method_2380(context, x, y);
        if (x > this.field_2776 + 75 && x < this.field_2776 + 75 + 26 && y > this.field_2800 + 13 && y < this.field_2800 + 13 + 26) {
            context.method_51434(this.field_22793, this.method_51454(((AuctionHouseScreenHandler)this.field_2797).method_7611(13).method_7677()), x, y);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (!this.isBinAuction && this.priceWidget.method_25405(click.comp_4798(), click.comp_4799())) {
            this.clickSlot(31);
            return true;
        }
        return super.method_25402(click, doubled);
    }

    @Override
    public void onSlotChange(AuctionHouseScreenHandler handler, int slotId, class_1799 stack) {
        if (stack.method_31574(class_1802.field_8157) || slotId == 13 || slotId >= handler.method_17388() * 9) {
            return;
        }
        assert (this.field_22787 != null);
        if (stack.method_31574(class_1802.field_8353)) {
            this.changeState(BuyState.CANCELLABLE_AUCTION);
            this.buySlotID = slotId;
        }
        if (this.priceParsed) {
            return;
        }
        if (stack.method_31574(class_1802.field_8635)) {
            this.changeState(BuyState.CANT_AFFORD);
            this.getPriceFromTooltip(ItemUtils.getLore(stack));
            this.buySlotID = slotId;
        } else if (stack.method_31574(class_1802.field_8397)) {
            this.changeState(BuyState.AFFORD);
            this.getPriceFromTooltip(ItemUtils.getLore(stack));
            this.buySlotID = slotId;
        } else if (stack.method_31574(class_1802.field_8494)) {
            this.changeState(BuyState.TOP_BID);
            this.getPriceFromTooltip(ItemUtils.getLore(stack));
            this.buySlotID = slotId;
        } else if (stack.method_31574(class_1802.field_8448)) {
            this.getPriceFromTooltip(ItemUtils.getLore(stack));
            this.changeProfile = true;
            this.buySlotID = slotId;
        }
        String lowerCase = stack.method_7964().getString().toLowerCase(Locale.ENGLISH);
        if (this.priceParsed && lowerCase.contains("collect auction")) {
            this.changeState(BuyState.COLLECT_AUCTION);
        }
    }

    private void getPriceFromTooltip(List<class_2561> tooltip) {
        if (this.priceParsed) {
            return;
        }
        String minBid = null;
        String priceString = null;
        AtomicReference<String> stringAtomicReference = new AtomicReference<String>("");
        for (class_2561 text : tooltip) {
            String string = text.getString();
            String thingToLookFor = this.isBinAuction ? "price:" : "new bid:";
            String lowerCase = string.toLowerCase(Locale.ENGLISH);
            if (lowerCase.contains(thingToLookFor)) {
                split = string.split(":");
                if (split.length < 2) continue;
                priceString = split[1].trim();
            } else if (lowerCase.contains("minimum bid:") && !this.isBinAuction) {
                split = string.split(":");
                if (split.length < 2) continue;
                minBid = split[1].replace("coins", "").replace(",", "").trim();
            } else if (lowerCase.contains("you pay:")) {
                split = string.split(":");
                if (split.length < 2) continue;
                if (this.buyState != BuyState.CANT_AFFORD && !this.isBinAuction) {
                    this.infoTextWidget.method_25355((class_2561)class_2561.method_43469((String)"skyblocker.fancyAuctionHouse.youPay", (Object[])new Object[]{split[1].trim()}));
                }
            } else if (lowerCase.contains("top bid:")) {
                this.wonAuction = false;
            } else if (lowerCase.contains("correct profile")) {
                this.changeProfile = true;
                this.priceWidget.method_25355((class_2561)class_2561.method_43473());
            } else if (lowerCase.contains("own auction")) {
                this.changeState(BuyState.OWN_AUCTION);
            }
            text.method_27658((style, asString) -> {
                String res = Objects.equals(style.method_10973(), class_5251.method_27718((class_124)class_124.field_1065)) && !asString.matches(".*[]\\[+].*") && !asString.contains("Collect") ? asString : null;
                return Optional.ofNullable(res);
            }, class_2583.field_24360).ifPresent(s -> stringAtomicReference.set((String)stringAtomicReference.get() + s));
        }
        if (priceString == null) {
            priceString = stringAtomicReference.get();
        }
        this.minBid = minBid != null ? minBid : priceString;
        this.priceText = class_2561.method_43470((String)priceString).method_10862(class_2583.field_24360.method_27706(class_124.field_1067).method_10977(class_124.field_1065));
        this.priceWidget.method_25355((class_2561)this.priceText);
        this.priceParsed = true;
        this.updateLayout();
    }

    public class_8816 getConfirmPurchasePopup(class_2561 title) {
        return new class_8816.class_8817((class_437)this, title).method_54130((class_2561)class_2561.method_43471((String)"text.skyblocker.confirm"), popupScreen -> this.field_22787.field_1761.method_2906(this.field_22787.field_1724.field_7512.field_7763, 11, 0, class_1713.field_7790, (class_1657)this.field_22787.field_1724)).method_54130((class_2561)class_2561.method_43471((String)"gui.cancel"), class_8816::method_25419).method_54129((class_2561)(this.isBinAuction ? class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.price") : class_2561.method_43471((String)"skyblocker.fancyAuctionHouse.newBid")).method_27693(" ").method_10852((class_2561)this.priceText)).method_54128(() -> this.field_22787.field_1761.method_2906(this.field_22787.field_1724.field_7512.field_7763, 15, 0, class_1713.field_7790, (class_1657)this.field_22787.field_1724)).method_54125();
    }

    private static enum BuyState {
        CANT_AFFORD,
        AFFORD,
        TOP_BID,
        COLLECT_AUCTION,
        CANCELLABLE_AUCTION,
        OWN_AUCTION;

    }
}

