/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chat;

import de.hysky.skyblocker.skyblock.chat.ChatRule;
import de.hysky.skyblocker.skyblock.chat.ChatRuleConfigScreen;
import de.hysky.skyblocker.skyblock.chat.ChatRulesConfigScreen;
import de.hysky.skyblocker.skyblock.chat.ChatRulesHandler;
import java.awt.Color;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;

public class ChatRulesConfigListWidget
extends class_4265<AbstractChatRuleEntry> {
    private final ChatRulesConfigScreen screen;
    private boolean hasChanged;

    public ChatRulesConfigListWidget(class_310 client, ChatRulesConfigScreen screen, int width, int height, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
        this.screen = screen;
        this.hasChanged = false;
        this.updateEntries();
    }

    public void updateEntries() {
        this.method_25339();
        this.method_25321((class_350.class_351)new ChatRuleLabelsEntry());
        for (int i = 0; i < ChatRulesHandler.chatRuleList.getData().size(); ++i) {
            this.method_25321((class_350.class_351)new ChatRuleConfigEntry(i));
        }
    }

    public int method_25322() {
        return super.method_25322() + 100;
    }

    protected int method_65507() {
        return super.method_65507() + 50;
    }

    protected void addRuleAfterSelected() {
        this.hasChanged = true;
        int newIndex = Math.max(this.method_25396().indexOf(this.method_25334()), 0);
        ChatRulesHandler.chatRuleList.getData().add(newIndex, new ChatRule());
        this.updateEntries();
    }

    protected void removeEntry(AbstractChatRuleEntry entry) {
        this.hasChanged = true;
        super.method_25330((class_350.class_351)entry);
    }

    protected void saveRules() {
        this.hasChanged = false;
        ChatRulesHandler.saveChatRules();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasChanges() {
        if (this.hasChanged) return true;
        if (!this.method_25396().stream().filter(ChatRuleConfigEntry.class::isInstance).map(ChatRuleConfigEntry.class::cast).anyMatch(ChatRuleConfigEntry::isChange)) return false;
        return true;
    }

    private class ChatRuleLabelsEntry
    extends AbstractChatRuleEntry {
        private ChatRuleLabelsEntry() {
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            context.method_27534(((ChatRulesConfigListWidget)ChatRulesConfigListWidget.this).field_22740.field_1772, (class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleName"), ChatRulesConfigListWidget.this.method_25368() / 2 - 125, this.method_46427() + 5, -1);
            context.method_27534(((ChatRulesConfigListWidget)ChatRulesConfigListWidget.this).field_22740.field_1772, (class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleEnabled"), ChatRulesConfigListWidget.this.method_25368() / 2, this.method_46427() + 5, -1);
            context.method_27534(((ChatRulesConfigListWidget)ChatRulesConfigListWidget.this).field_22740.field_1772, (class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.modify"), ChatRulesConfigListWidget.this.method_25368() / 2 + 100, this.method_46427() + 5, -1);
        }
    }

    private class ChatRuleConfigEntry
    extends AbstractChatRuleEntry {
        private final int chatRuleIndex;
        private final ChatRule chatRule;
        private final List<? extends class_364> children;
        private final class_4185 enabledButton;
        private final class_4185 openConfigButton;
        private final class_4185 deleteButton;
        private final int nameX;
        private double oldScrollAmount;

        private ChatRuleConfigEntry(int chatRuleIndex) {
            this.nameX = ChatRulesConfigListWidget.this.field_22758 / 2 - 125;
            this.oldScrollAmount = 0.0;
            this.chatRuleIndex = chatRuleIndex;
            this.chatRule = ChatRulesHandler.chatRuleList.getData().get(chatRuleIndex);
            this.enabledButton = class_4185.method_46430((class_2561)this.enabledButtonText(), a -> this.toggleEnabled()).method_46437(50, 20).method_46433(ChatRulesConfigListWidget.this.field_22758 / 2 - 25, 5).method_46431();
            this.openConfigButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.editRule"), a -> ChatRulesConfigListWidget.this.field_22740.method_1507((class_437)new ChatRuleConfigScreen(ChatRulesConfigListWidget.this.screen, chatRuleIndex))).method_46437(50, 20).method_46433(ChatRulesConfigListWidget.this.field_22758 / 2 + 45, 5).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.editRule.@Tooltip"))).method_46431();
            this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectServer.delete"), a -> {
                this.oldScrollAmount = ChatRulesConfigListWidget.this.method_44387();
                ChatRulesConfigListWidget.this.field_22740.method_1507((class_437)new class_410(this::deleteEntry, (class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.deleteQuestion"), (class_2561)class_2561.method_43469((String)"skyblocker.config.chat.chatRules.screen.deleteWarning", (Object[])new Object[]{this.chatRule.getName()}), (class_2561)class_2561.method_43471((String)"selectServer.deleteButton"), class_5244.field_24335));
            }).method_46437(50, 20).method_46433(ChatRulesConfigListWidget.this.field_22758 / 2 + 105, 5).method_46431();
            this.children = List.of(this.enabledButton, this.openConfigButton, this.deleteButton);
        }

        private class_2561 enabledButtonText() {
            if (this.chatRule.getEnabled()) {
                return class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.true").method_54663(Color.GREEN.getRGB());
            }
            return class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.false").method_54663(Color.RED.getRGB());
        }

        private void toggleEnabled() {
            ChatRulesConfigListWidget.this.hasChanged = true;
            this.chatRule.setEnabled(!this.chatRule.getEnabled());
            this.enabledButton.method_25355(this.enabledButtonText());
        }

        private void deleteEntry(boolean confirmedAction) {
            if (confirmedAction) {
                ChatRulesHandler.chatRuleList.getData().remove(this.chatRuleIndex);
                ChatRulesConfigListWidget.this.removeEntry(this);
            }
            ChatRulesConfigListWidget.this.field_22740.method_1507((class_437)ChatRulesConfigListWidget.this.screen);
            ChatRulesConfigListWidget.this.method_44382(this.oldScrollAmount);
        }

        public List<? extends class_6379> method_37025() {
            return List.of(new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37033(class_6381.field_33788, ChatRuleConfigEntry.this.chatRule.getName());
                }
            });
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            this.enabledButton.method_46419(this.method_46427());
            this.enabledButton.method_25394(context, mouseX, mouseY, deltaTicks);
            this.openConfigButton.method_46419(this.method_46427());
            this.openConfigButton.method_25394(context, mouseX, mouseY, deltaTicks);
            this.deleteButton.method_46419(this.method_46427());
            this.deleteButton.method_25394(context, mouseX, mouseY, deltaTicks);
            context.method_25300(((ChatRulesConfigListWidget)ChatRulesConfigListWidget.this).field_22740.field_1772, this.chatRule.getName(), this.nameX, this.method_46427() + 5, -1);
        }

        public boolean isChange() {
            return this.chatRule.getEnabled() != ChatRulesHandler.chatRuleList.getData().get(this.chatRuleIndex).getEnabled();
        }
    }

    protected static abstract class AbstractChatRuleEntry
    extends class_4265.class_4266<AbstractChatRuleEntry> {
        protected AbstractChatRuleEntry() {
        }
    }
}

