/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chat;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.chat.ChatRule;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.TextTransformer;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.JsonData;
import de.hysky.skyblocker.utils.render.title.Title;
import de.hysky.skyblocker.utils.render.title.TitleContainer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class ChatRulesHandler {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Path CHAT_RULE_FILE = SkyblockerMod.CONFIG_DIR.resolve("chat_rules.json");
    private static final Codec<Map<String, List<ChatRule>>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, ChatRule.LIST_CODEC);
    @VisibleForTesting
    static final Codec<List<ChatRule>> UNBOXING_CODEC = Codec.either(ChatRule.LIST_CODEC, MAP_CODEC).xmap(either -> (List)either.map(ArrayList::new, map -> new ArrayList(map.getOrDefault("rules", ChatRulesHandler.getDefaultChatRules()))), value -> Either.right(Map.of("rules", value)));
    protected static final JsonData<List<ChatRule>> chatRuleList = new JsonData<List<ChatRule>>(CHAT_RULE_FILE, UNBOXING_CODEC, ChatRulesHandler.getDefaultChatRules());

    @Init
    public static void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> chatRuleList.init());
        ClientReceiveMessageEvents.ALLOW_GAME.register(ChatRulesHandler::checkMessage);
    }

    @VisibleForTesting
    static List<ChatRule> getDefaultChatRules() {
        return new ArrayList<ChatRule>(List.of(new ChatRule("Clean Hub Chat", false, true, true, true, "(selling)|(buying)|(lowb)|(visit)|(/p)|(/ah)|(my ah)", EnumSet.of(Location.HUB), true, false, false, "", null), new ChatRule("Mining Ability Alert", false, true, false, true, "is now available!", EnumSet.of(Location.DWARVEN_MINES, Location.CRYSTAL_HOLLOWS), false, false, true, "&1Ability", class_3417.field_15224)));
    }

    private static boolean checkMessage(class_2561 message, boolean overlay) {
        if (overlay || !Utils.isOnSkyblock()) {
            return true;
        }
        List<ChatRule> rules = chatRuleList.getData();
        if (!chatRuleList.isLoaded() || rules.isEmpty()) {
            return true;
        }
        String plain = class_124.method_539((String)message.getString());
        for (ChatRule rule : rules) {
            ChatRule.Match match = rule.isMatch(plain);
            if (!match.matches()) continue;
            Object newMessage = !rule.getReplaceMessage().isBlank() ? ChatRulesHandler.formatText(match.insertCaptureGroups(rule.getReplaceMessage())) : message;
            if (rule.getShowAnnouncement()) {
                TitleContainer.addTitle(new Title(newMessage.method_27661()), SkyblockerConfigManager.get().chat.chatRuleConfig.announcementLength);
            }
            if (rule.getShowActionBar() && ChatRulesHandler.CLIENT.field_1724 != null) {
                ChatRulesHandler.CLIENT.field_1724.method_7353(newMessage, true);
            }
            if (!rule.getHideMessage() && ChatRulesHandler.CLIENT.field_1724 != null) {
                Utils.sendMessageToBypassEvents(newMessage);
            }
            if (rule.getCustomSound() != null && ChatRulesHandler.CLIENT.field_1724 != null) {
                ChatRulesHandler.CLIENT.field_1724.method_5783(rule.getCustomSound(), 100.0f, 0.1f);
            }
            return false;
        }
        return true;
    }

    @NotNull
    protected static class_5250 formatText(@NotNull String codedString) {
        if (codedString.contains("\u00a7")) {
            return TextTransformer.fromLegacy(codedString, '\u00a7', false);
        }
        if (codedString.contains("&")) {
            return TextTransformer.fromLegacy(codedString, '&', false);
        }
        return class_2561.method_43470((String)codedString);
    }

    public static void saveChatRules() {
        if (chatRuleList.getData() != null) {
            chatRuleList.save();
        }
    }
}

