/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chocolatefactory;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.LineSmoothener;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RegexUtils;
import de.hysky.skyblocker.utils.SkyblockTime;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import de.hysky.skyblocker.utils.container.TooltipAdder;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChocolateFactorySolver
extends SimpleContainerSolver
implements TooltipAdder,
SlotTextAdder {
    private static final Pattern CPS_PATTERN = Pattern.compile("([\\d,.]+) Chocolate per second");
    private static final Pattern CPS_INCREASE_PATTERN = Pattern.compile("\\+([\\d,]+) Chocolate per second");
    private static final Pattern COST_PATTERN = Pattern.compile("Cost ([\\d,]+) Chocolate");
    private static final Pattern LEVEL_PATTERN = Pattern.compile("\\[(\\d+)]");
    private static final Pattern TOTAL_MULTIPLIER_PATTERN = Pattern.compile("Total Multiplier: ([\\d.]+)x");
    private static final Pattern MULTIPLIER_INCREASE_PATTERN = Pattern.compile("\\+([\\d.]+)x Chocolate per second");
    private static final Pattern CHOCOLATE_PATTERN = Pattern.compile("^([\\d,]+) Chocolate$");
    private static final Pattern PRESTIGE_REQUIREMENT_PATTERN = Pattern.compile("Chocolate this Prestige: ([\\d,]+) +Requires (\\S+) Chocolate this Prestige!");
    private static final Pattern TIME_TOWER_STATUS_PATTERN = Pattern.compile("Status: (ACTIVE|INACTIVE)");
    private static final Pattern TIME_TOWER_MULTIPLIER_PATTERN = Pattern.compile("by \\+([\\d.]+)x for \\dh\\.");
    private static final Pattern AVAILABLE_EGGS_PATTERN = Pattern.compile("Available eggs: (\\d+)");
    private static final Pattern ROMAN_LEVEL_PATTERN = Pattern.compile("(?:Chocolate Factory|Hand-Baked Chocolate|Time Tower|Rabbit Shrine|Coach Jackrabbit|Rabbit Barn) ?(?<level>\\w+)?");
    private static final Pattern PURCHASED_SLOTS_PATTERN = Pattern.compile("Purchased slots: (\\d+)/(\\d+)");
    private static final byte STRAY_RABBIT_START = 0;
    private static final byte STRAY_RABBIT_END = 26;
    private static final byte CHOCOLATE_SLOT = 13;
    private static final byte PRESTIGE_SLOT = 27;
    private static final byte RABBITS_START = 28;
    private static final byte RABBITS_END = 34;
    private static final byte RABBIT_BARN_SLOT = 35;
    private static final byte HAND_BAKED_CHOCOLATE_SLOT = 38;
    private static final byte TIME_TOWER_SLOT = 39;
    private static final byte RABBIT_SHRINE_SLOT = 41;
    private static final byte COACH_SLOT = 42;
    private static final byte CPS_SLOT = 45;
    private static final byte RABBIT_HITMAN_SLOT = 51;
    private final ObjectArrayList<Rabbit> cpsIncreaseFactors = new ObjectArrayList(8);
    private long totalChocolate = -1L;
    private double totalCps = -1.0;
    private double totalCpsMultiplier = -1.0;
    private long requiredUntilNextPrestige = -1L;
    private boolean canPrestige = false;
    private boolean reachedMaxPrestige = false;
    private double timeTowerMultiplier = -1.0;
    private boolean isTimeTowerMaxed = false;
    private boolean isTimeTowerActive = false;
    private int bestUpgrade = -1;
    private int bestAffordableUpgrade = -1;
    private int prestigeLevel = -1;
    private int hitmanAvailableEggs = -1;
    private int purchasedHitmanSlots = -1;
    private int maxHitmanSlots = -1;
    private int rabbitShrineLevel = -1;
    private int handBakedChocolateLevel = -1;
    private int rabbitBarnLevel = -1;
    private int timeTowerLevel = -1;
    private static StraySound ding = StraySound.NONE;
    private static int dingTick = 0;
    public static final ChocolateFactorySolver INSTANCE = new ChocolateFactorySolver();

    private ChocolateFactorySolver() {
        super("^Chocolate Factory$");
        ClientTickEvents.START_CLIENT_TICK.register(ChocolateFactorySolver::onTick);
    }

    private static void onTick(class_310 client) {
        if (ding != StraySound.NONE) {
            ++dingTick;
            if ((dingTick %= ding == StraySound.NORMAL ? 5 : 3) == 0) {
                client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)(ding == StraySound.NORMAL ? (class_3414)class_3417.field_14622.comp_349() : (class_3414)class_3417.field_15114.comp_349()), (float)1.0f, (float)1.0f));
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().helpers.chocolateFactory.enableChocolateFactoryHelper;
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        this.updateFactoryInfo(slots);
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        this.getPrestigeHighlight().ifPresent(highlights::add);
        highlights.addAll(this.getStrayRabbitHighlight(slots));
        if (this.totalChocolate <= 0L || this.cpsIncreaseFactors.isEmpty()) {
            return highlights;
        }
        Rabbit bestRabbit = (Rabbit)this.cpsIncreaseFactors.getFirst();
        this.bestUpgrade = bestRabbit.slot;
        if (bestRabbit.cost <= this.totalChocolate) {
            highlights.add(ColorHighlight.green(bestRabbit.slot));
            return highlights;
        }
        highlights.add(ColorHighlight.yellow(bestRabbit.slot));
        for (Rabbit rabbit : this.cpsIncreaseFactors.subList(1, this.cpsIncreaseFactors.size())) {
            if (rabbit.cost > this.totalChocolate) continue;
            this.bestAffordableUpgrade = rabbit.slot;
            highlights.add(ColorHighlight.green(rabbit.slot));
            break;
        }
        return highlights;
    }

    private void updateFactoryInfo(Int2ObjectMap<class_1799> slots) {
        Matcher purchasedSlotsMatcher;
        this.cpsIncreaseFactors.clear();
        for (int i = 28; i <= 34; ++i) {
            class_1799 item = (class_1799)slots.get(i);
            if (!item.method_31574(class_1802.field_8575)) continue;
            this.getRabbit(item, i).ifPresent(arg_0 -> this.cpsIncreaseFactors.add(arg_0));
        }
        this.getCoach((class_1799)slots.get(42)).ifPresent(arg_0 -> this.cpsIncreaseFactors.add(arg_0));
        RegexUtils.findLongFromMatcher(CHOCOLATE_PATTERN.matcher(((class_1799)slots.get(13)).method_7964().getString())).ifPresent(l -> {
            this.totalChocolate = l;
        });
        String cpsItemLore = ItemUtils.getConcatenatedLore((class_1799)slots.get(45));
        Matcher cpsMatcher = CPS_PATTERN.matcher(cpsItemLore);
        RegexUtils.findDoubleFromMatcher(cpsMatcher).ifPresent(d -> {
            this.totalCps = d;
        });
        Matcher multiplierMatcher = TOTAL_MULTIPLIER_PATTERN.matcher(cpsItemLore);
        RegexUtils.findDoubleFromMatcher(multiplierMatcher, cpsMatcher.hasMatch() ? cpsMatcher.end() : 0).ifPresent(d -> {
            this.totalCpsMultiplier = d;
        });
        String prestigeLore = ItemUtils.getConcatenatedLore((class_1799)slots.get(27));
        Matcher prestigeMatcher = PRESTIGE_REQUIREMENT_PATTERN.matcher(prestigeLore);
        OptionalLong currentChocolate = RegexUtils.findLongFromMatcher(prestigeMatcher);
        if (currentChocolate.isPresent()) {
            String requirement = prestigeMatcher.group(2);
            String amountString = requirement.replace("M", "000000").replace("B", "000000000");
            if (NumberUtils.isParsable((String)amountString)) {
                this.requiredUntilNextPrestige = Long.parseLong(amountString) - currentChocolate.getAsLong();
            }
            this.canPrestige = false;
        } else if (prestigeLore.endsWith("Click to prestige!")) {
            this.canPrestige = true;
            this.reachedMaxPrestige = false;
        } else if (prestigeLore.endsWith("You have reached max prestige!")) {
            this.canPrestige = false;
            this.reachedMaxPrestige = true;
        }
        Matcher upgradeMatcher = ROMAN_LEVEL_PATTERN.matcher(((class_1799)slots.get(27)).method_7964().getString());
        this.prestigeLevel = RegexUtils.findRomanNumeralFromMatcher(upgradeMatcher).orElse(-1);
        upgradeMatcher = ROMAN_LEVEL_PATTERN.matcher(((class_1799)slots.get(38)).method_7964().getString());
        this.handBakedChocolateLevel = RegexUtils.findRomanNumeralFromMatcher(upgradeMatcher).orElse(-1);
        upgradeMatcher.reset(((class_1799)slots.get(39)).method_7964().getString());
        this.timeTowerLevel = RegexUtils.findRomanNumeralFromMatcher(upgradeMatcher).orElse(-1);
        this.isTimeTowerMaxed = this.timeTowerLevel >= 15;
        String timeTowerLore = ItemUtils.getConcatenatedLore((class_1799)slots.get(39));
        Matcher timeTowerMultiplierMatcher = TIME_TOWER_MULTIPLIER_PATTERN.matcher(timeTowerLore);
        RegexUtils.findDoubleFromMatcher(timeTowerMultiplierMatcher).ifPresent(d -> {
            this.timeTowerMultiplier = d;
        });
        Matcher timeTowerStatusMatcher = TIME_TOWER_STATUS_PATTERN.matcher(timeTowerLore);
        if (timeTowerStatusMatcher.find(timeTowerMultiplierMatcher.hasMatch() ? timeTowerMultiplierMatcher.end() : 0)) {
            this.isTimeTowerActive = timeTowerStatusMatcher.group(1).equals("ACTIVE");
        }
        upgradeMatcher.reset(((class_1799)slots.get(41)).method_7964().getString());
        this.rabbitShrineLevel = RegexUtils.findRomanNumeralFromMatcher(upgradeMatcher).orElse(-1);
        upgradeMatcher.reset(((class_1799)slots.get(35)).method_7964().getString());
        this.rabbitBarnLevel = RegexUtils.findRomanNumeralFromMatcher(upgradeMatcher).orElse(-1);
        Matcher hitmanMatcher = ItemUtils.getLoreLineIfMatch((class_1799)slots.get(51), AVAILABLE_EGGS_PATTERN);
        if (hitmanMatcher != null) {
            this.hitmanAvailableEggs = RegexUtils.parseIntFromMatcher(hitmanMatcher, 1);
        }
        if ((purchasedSlotsMatcher = ItemUtils.getLoreLineIfMatch((class_1799)slots.get(51), PURCHASED_SLOTS_PATTERN)) != null) {
            this.purchasedHitmanSlots = RegexUtils.parseIntFromMatcher(purchasedSlotsMatcher, 1);
            this.maxHitmanSlots = RegexUtils.parseIntFromMatcher(purchasedSlotsMatcher, 2);
        }
        this.cpsIncreaseFactors.sort(Comparator.comparingDouble(rabbit -> (double)rabbit.cost() / rabbit.cpsIncrease()));
    }

    private Optional<Rabbit> getCoach(class_1799 coachItem) {
        if (!coachItem.method_31574(class_1802.field_8575)) {
            return Optional.empty();
        }
        String coachLore = ItemUtils.getConcatenatedLore(coachItem);
        if (this.totalCps < 0.0 || this.totalCpsMultiplier < 0.0) {
            return Optional.empty();
        }
        Matcher multiplierIncreaseMatcher = MULTIPLIER_INCREASE_PATTERN.matcher(coachLore);
        OptionalDouble currentCpsMultiplier = RegexUtils.findDoubleFromMatcher(multiplierIncreaseMatcher);
        if (currentCpsMultiplier.isEmpty()) {
            return Optional.empty();
        }
        OptionalDouble nextCpsMultiplier = RegexUtils.findDoubleFromMatcher(multiplierIncreaseMatcher);
        if (nextCpsMultiplier.isEmpty()) {
            nextCpsMultiplier = currentCpsMultiplier;
            currentCpsMultiplier = OptionalDouble.of(0.0);
        }
        Matcher levelMatcher = ROMAN_LEVEL_PATTERN.matcher(coachItem.method_7964().getString());
        int level = RegexUtils.findRomanNumeralFromMatcher(levelMatcher).orElse(-1);
        Matcher costMatcher = COST_PATTERN.matcher(coachLore);
        OptionalLong cost = RegexUtils.findLongFromMatcher(costMatcher, multiplierIncreaseMatcher.hasMatch() ? multiplierIncreaseMatcher.end() : 0);
        if (cost.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Rabbit(this.totalCps / this.totalCpsMultiplier * (nextCpsMultiplier.getAsDouble() - currentCpsMultiplier.getAsDouble()), cost.getAsLong(), 42, level));
    }

    private Optional<Rabbit> getRabbit(class_1799 item, int slot) {
        String lore = ItemUtils.getConcatenatedLore(item);
        Matcher cpsMatcher = CPS_INCREASE_PATTERN.matcher(lore);
        OptionalInt currentCps = RegexUtils.findIntFromMatcher(cpsMatcher);
        if (currentCps.isEmpty()) {
            return Optional.empty();
        }
        OptionalInt nextCps = RegexUtils.findIntFromMatcher(cpsMatcher);
        if (nextCps.isEmpty()) {
            nextCps = currentCps;
            currentCps = OptionalInt.of(0);
        }
        Matcher costMatcher = COST_PATTERN.matcher(lore);
        OptionalLong cost = RegexUtils.findLongFromMatcher(costMatcher, cpsMatcher.hasMatch() ? cpsMatcher.end() : 0);
        Matcher levelMatcher = LEVEL_PATTERN.matcher(lore);
        int level = RegexUtils.findIntFromMatcher(levelMatcher).orElse(0) - 1;
        if (cost.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Rabbit((double)(nextCps.getAsInt() - currentCps.getAsInt()) * (this.totalCpsMultiplier < 0.0 ? 1.0 : this.totalCpsMultiplier), cost.getAsLong(), slot, level));
    }

    private Optional<ColorHighlight> getPrestigeHighlight() {
        if (this.reachedMaxPrestige) {
            return Optional.empty();
        }
        if (this.canPrestige) {
            return Optional.of(ColorHighlight.green(27));
        }
        return Optional.of(ColorHighlight.red(27));
    }

    private List<ColorHighlight> getStrayRabbitHighlight(Int2ObjectMap<class_1799> slots) {
        ding = StraySound.NONE;
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        for (int i = 0; i <= 26; i = (int)((byte)(i + 1))) {
            String name;
            class_1799 item = (class_1799)slots.get(i);
            if (!item.method_31574(class_1802.field_8575) || !(name = item.method_7964().getString()).equals("CLICK ME!") && !name.startsWith("Golden Rabbit - ")) continue;
            if (SkyblockerConfigManager.get().helpers.chocolateFactory.straySound) {
                ding = name.startsWith("Golden") ? StraySound.GOLDEN : StraySound.NORMAL;
            }
            highlights.add(ColorHighlight.green(i));
        }
        return highlights;
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        int index;
        if (focusedSlot == null) {
            return;
        }
        int lineIndex = lines.size();
        boolean shouldAddLine = false;
        String lore = ItemUtils.concatenateLore(lines);
        Matcher costMatcher = COST_PATTERN.matcher(lore);
        OptionalLong cost = RegexUtils.findLongFromMatcher(costMatcher);
        if (cost.isPresent()) {
            shouldAddLine |= this.addUpgradeTimerToLore(lines, cost.getAsLong());
        }
        if ((index = focusedSlot.field_7874) == 27) {
            shouldAddLine |= this.addPrestigeTimerToLore(lines);
        } else if (index == 39) {
            shouldAddLine |= this.addTimeTowerStatsToLore(lines);
        } else if (index == 42 || index >= 28 && index <= 34) {
            shouldAddLine |= this.addRabbitStatsToLore(lines, index);
        }
        if (shouldAddLine) {
            lines.add(lineIndex, LineSmoothener.createSmoothLine());
        }
    }

    private boolean addUpgradeTimerToLore(List<class_2561> lines, long cost) {
        if (this.totalChocolate < 0L || this.totalCps < 0.0) {
            return false;
        }
        lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Time until upgrade: ").method_27692(class_124.field_1080)).method_10852((class_2561)this.formatTime((double)(cost - this.totalChocolate) / this.totalCps)));
        return true;
    }

    private boolean addPrestigeTimerToLore(List<class_2561> lines) {
        if (this.totalCps < 0.0 || this.reachedMaxPrestige) {
            return false;
        }
        if (this.requiredUntilNextPrestige > 0L && !this.canPrestige) {
            lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Chocolate until next prestige: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)Formatters.FLOAT_NUMBERS.format(this.requiredUntilNextPrestige)).method_27692(class_124.field_1065)));
        }
        lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Time until next prestige: ").method_27692(class_124.field_1080)).method_10852((class_2561)this.formatTime((double)this.requiredUntilNextPrestige / this.totalCps)));
        return true;
    }

    private boolean addTimeTowerStatsToLore(List<class_2561> lines) {
        if (this.totalCps < 0.0 || this.totalCpsMultiplier < 0.0 || this.timeTowerMultiplier < 0.0) {
            return false;
        }
        lines.add((class_2561)class_2561.method_43470((String)"Current stats:").method_27692(class_124.field_1080));
        lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"  CPS increase: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)Formatters.FLOAT_NUMBERS.format(this.totalCps / this.totalCpsMultiplier * this.timeTowerMultiplier)).method_27692(class_124.field_1065)));
        lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"  CPS when active: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)Formatters.FLOAT_NUMBERS.format(this.isTimeTowerActive ? this.totalCps : this.totalCps / this.totalCpsMultiplier * (this.timeTowerMultiplier + this.totalCpsMultiplier))).method_27692(class_124.field_1065)));
        if (!this.isTimeTowerMaxed) {
            lines.add((class_2561)class_2561.method_43470((String)"Stats after upgrade:").method_27692(class_124.field_1080));
            lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"  CPS increase: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)Formatters.FLOAT_NUMBERS.format(this.totalCps / this.totalCpsMultiplier * (this.timeTowerMultiplier + 0.1))).method_27692(class_124.field_1065)));
            lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"  CPS when active: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)Formatters.FLOAT_NUMBERS.format(this.isTimeTowerActive ? this.totalCps / this.totalCpsMultiplier * (this.totalCpsMultiplier + 0.1) : this.totalCps / this.totalCpsMultiplier * (this.timeTowerMultiplier + 0.1 + this.totalCpsMultiplier))).method_27692(class_124.field_1065)));
        }
        return true;
    }

    private boolean addRabbitStatsToLore(List<class_2561> lines, int slot) {
        if (this.cpsIncreaseFactors.isEmpty()) {
            return false;
        }
        for (Rabbit rabbit : this.cpsIncreaseFactors) {
            if (rabbit.slot != slot) continue;
            lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"CPS Increase: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)Formatters.FLOAT_NUMBERS.format(rabbit.cpsIncrease)).method_27692(class_124.field_1065)));
            lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Cost per CPS: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)Formatters.FLOAT_NUMBERS.format((double)rabbit.cost / rabbit.cpsIncrease)).method_27692(class_124.field_1065)));
            if (rabbit.slot == this.bestUpgrade) {
                if (rabbit.cost <= this.totalChocolate) {
                    lines.add((class_2561)class_2561.method_43470((String)"Best upgrade").method_27692(class_124.field_1060));
                } else {
                    lines.add((class_2561)class_2561.method_43470((String)"Best upgrade, can't afford").method_27692(class_124.field_1054));
                }
            } else if (rabbit.slot == this.bestAffordableUpgrade && rabbit.cost <= this.totalChocolate) {
                lines.add((class_2561)class_2561.method_43470((String)"Best upgrade you can afford").method_27692(class_124.field_1060));
            }
            return true;
        }
        return false;
    }

    private class_5250 formatTime(double seconds) {
        return SkyblockTime.formatTime(seconds).method_27692(class_124.field_1065);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    @NotNull
    public List<SlotText> getText(@Nullable class_1735 slot, @NotNull class_1799 stack, int slotId) {
        for (Rabbit rabbit : this.cpsIncreaseFactors) {
            if (slotId != rabbit.slot()) continue;
            class_5250 levelText = class_2561.method_43470((String)String.valueOf(rabbit.level())).method_27692(class_124.field_1065);
            return SlotText.topLeftList((class_2561)levelText);
        }
        return switch (slotId) {
            case 38 -> {
                if (this.handBakedChocolateLevel < 0 || this.handBakedChocolateLevel == 10) {
                    yield List.of();
                }
                class_5250 levelText = class_2561.method_43470((String)String.valueOf(this.handBakedChocolateLevel)).method_27692(class_124.field_1065);
                yield SlotText.topLeftList((class_2561)levelText);
            }
            case 41 -> {
                if (this.rabbitShrineLevel < 0 || this.rabbitShrineLevel == 20) {
                    yield List.of();
                }
                class_5250 levelText = class_2561.method_43470((String)String.valueOf(this.rabbitShrineLevel)).method_27692(class_124.field_1065);
                yield SlotText.topLeftList((class_2561)levelText);
            }
            case 35 -> {
                if (this.rabbitBarnLevel < 0 || this.rabbitBarnLevel == 245) {
                    yield List.of();
                }
                class_5250 levelText = class_2561.method_43470((String)String.valueOf(this.rabbitBarnLevel)).method_27692(class_124.field_1065);
                yield SlotText.topLeftList((class_2561)levelText);
            }
            case 39 -> {
                if (this.timeTowerLevel < 0 || this.isTimeTowerMaxed) {
                    yield List.of();
                }
                class_5250 levelText = class_2561.method_43470((String)String.valueOf(this.timeTowerLevel)).method_27692(class_124.field_1065);
                yield SlotText.topLeftList((class_2561)levelText);
            }
            case 51 -> {
                if (this.hitmanAvailableEggs < 0 || this.purchasedHitmanSlots < 0 || this.maxHitmanSlots < 0) {
                    yield List.of();
                }
                if (this.purchasedHitmanSlots == 0) {
                    yield SlotText.topLeftList((class_2561)class_2561.method_43470((String)"0/0").method_27692(class_124.field_1080));
                }
                class_5250 levelText = class_2561.method_43470((String)String.valueOf(this.hitmanAvailableEggs));
                levelText = this.hitmanAvailableEggs == this.purchasedHitmanSlots ? levelText.method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}) : (this.hitmanAvailableEggs == 0 ? levelText.method_27692(class_124.field_1080) : levelText.method_27692(class_124.field_1054));
                class_5250 result = class_2561.method_43473().method_10852((class_2561)levelText);
                if (this.purchasedHitmanSlots < this.maxHitmanSlots) {
                    result.method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.purchasedHitmanSlots)).method_27692(class_124.field_1054));
                }
                yield SlotText.topLeftList((class_2561)result);
            }
            case 27 -> {
                if (this.prestigeLevel < 0) {
                    yield List.of();
                }
                class_5250 levelText = class_2561.method_43470((String)String.valueOf(this.prestigeLevel)).method_27692(class_124.field_1065);
                yield SlotText.topLeftList((class_2561)levelText);
            }
            default -> List.of();
        };
    }

    @Override
    public void reset() {
        this.cpsIncreaseFactors.clear();
        this.totalChocolate = -1L;
        this.totalCps = -1.0;
        this.totalCpsMultiplier = -1.0;
        this.requiredUntilNextPrestige = -1L;
        this.canPrestige = false;
        this.reachedMaxPrestige = false;
        this.timeTowerMultiplier = -1.0;
        this.isTimeTowerMaxed = false;
        this.isTimeTowerActive = false;
        this.bestUpgrade = -1;
        this.bestAffordableUpgrade = -1;
        this.prestigeLevel = -1;
        this.hitmanAvailableEggs = -1;
        this.purchasedHitmanSlots = -1;
        this.maxHitmanSlots = -1;
        this.rabbitShrineLevel = -1;
        this.handBakedChocolateLevel = -1;
        this.rabbitBarnLevel = -1;
        this.timeTowerLevel = -1;
        dingTick = 0;
        ding = StraySound.NONE;
    }

    private static enum StraySound {
        NONE,
        NORMAL,
        GOLDEN;

    }

    public record Rabbit(double cpsIncrease, long cost, int slot, int level) {
    }
}

