/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chocolatefactory;

import com.mojang.brigadier.Message;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTowerReminder {
    private static final String TIME_TOWER_FILE = "time_tower.txt";
    private static final Pattern TIME_TOWER_PATTERN = Pattern.compile("^TIME TOWER! Your Chocolate Factory production has increased by \\+[\\d.]+x for \\dh!$");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Skyblocker Time Tower Reminder");
    private static boolean scheduled = false;

    private TimeTowerReminder() {
    }

    @Init
    public static void init() {
        SkyblockEvents.JOIN.register(TimeTowerReminder::checkTempFile);
        ClientReceiveMessageEvents.ALLOW_GAME.register(TimeTowerReminder::checkIfTimeTower);
    }

    public static boolean checkIfTimeTower(Message message, boolean overlay) {
        if (!TIME_TOWER_PATTERN.matcher(message.getString()).matches() || scheduled) {
            return true;
        }
        Scheduler.INSTANCE.schedule(TimeTowerReminder::sendMessage, 72000);
        scheduled = true;
        File tempFile = SkyblockerMod.CONFIG_DIR.resolve(TIME_TOWER_FILE).toFile();
        if (!tempFile.exists()) {
            try {
                tempFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("[Skyblocker Time Tower Reminder] Failed to create temp file for Time Tower Reminder!", (Throwable)e);
                return true;
            }
        }
        try (FileWriter writer = new FileWriter(tempFile);){
            writer.write(String.valueOf(System.currentTimeMillis()));
        }
        catch (IOException e) {
            LOGGER.error("[Skyblocker Time Tower Reminder] Failed to write to temp file for Time Tower Reminder!", (Throwable)e);
        }
        return true;
    }

    private static void sendMessage() {
        if (class_310.method_1551().field_1724 == null || !Utils.isOnSkyblock()) {
            return;
        }
        if (SkyblockerConfigManager.get().helpers.chocolateFactory.enableTimeTowerReminder) {
            class_310.method_1551().field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.helpers.chocolateFactory.sendTimeTowerReminderMessage").method_27692(class_124.field_1061)), false);
        }
        File tempFile = SkyblockerMod.CONFIG_DIR.resolve(TIME_TOWER_FILE).toFile();
        try {
            scheduled = false;
            if (tempFile.exists()) {
                Files.delete(tempFile.toPath());
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Time Tower Reminder] Failed to delete temp file for Time Tower Reminder!", (Throwable)e);
        }
    }

    private static void checkTempFile() {
        long time;
        File tempFile = SkyblockerMod.CONFIG_DIR.resolve(TIME_TOWER_FILE).toFile();
        if (!tempFile.exists() || scheduled) {
            return;
        }
        try (Stream<String> file = Files.lines(tempFile.toPath());){
            time = Long.parseLong(file.findFirst().orElseThrow());
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Time Tower Reminder] Failed to read temp file for Time Tower Reminder!", (Throwable)e);
            return;
        }
        if (System.currentTimeMillis() - time >= 3600000L) {
            TimeTowerReminder.sendMessage();
        } else {
            Scheduler.INSTANCE.schedule(TimeTowerReminder::sendMessage, 72000 - (int)((System.currentTimeMillis() - time) / 50L));
            scheduled = true;
        }
    }
}

