/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.device;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.WorldEvents;
import de.hysky.skyblocker.skyblock.dungeon.DungeonBoss;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public class TargetPractice {
    private static final class_2338 PRESSURE_PLATE = new class_2338(63, 127, 35);
    private static final int ACTIVATION_THRESHOLD = 1;
    private static final int UNACTIVATED = 0;
    private static final List<class_2338> POSSIBLE_TARGETS = List.of(new class_2338(68, 130, 50), new class_2338(66, 130, 50), new class_2338(64, 130, 50), new class_2338(68, 128, 50), new class_2338(66, 128, 50), new class_2338(64, 128, 50), new class_2338(68, 126, 50), new class_2338(66, 126, 50), new class_2338(64, 126, 50));
    private static final List<class_2338> HIT_TARGETS = new ArrayList<class_2338>();
    private static final float[] RED = ColorUtils.getFloatComponents(class_1767.field_7964);

    @Init
    public static void init() {
        WorldEvents.BLOCK_STATE_UPDATE.register(TargetPractice::onBlockStateUpdate);
        WorldRenderExtractionCallback.EVENT.register(TargetPractice::extractRendering);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> TargetPractice.reset());
    }

    private static void onBlockStateUpdate(class_2338 pos, class_2680 oldState, class_2680 newState) {
        if (!TargetPractice.shouldProcess()) {
            return;
        }
        if (pos.equals((Object)PRESSURE_PLATE) && newState.method_26204().equals(class_2246.field_10224)) {
            if ((Integer)newState.method_11654((class_2769)class_2741.field_12511) < 1) {
                TargetPractice.reset();
                return;
            }
            if (oldState.method_26204().equals(class_2246.field_10224) && (Integer)oldState.method_11654((class_2769)class_2741.field_12511) == 0) {
                TargetPractice.reset();
                return;
            }
        }
        if (POSSIBLE_TARGETS.contains(pos) && oldState.method_26204().equals(class_2246.field_10234) && newState.method_26204().equals(class_2246.field_10409)) {
            HIT_TARGETS.add(pos.method_10062());
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (!TargetPractice.shouldProcess()) {
            return;
        }
        for (class_2338 pos : HIT_TARGETS) {
            collector.submitFilledBox(pos, RED, 0.5f, false);
        }
    }

    private static boolean shouldProcess() {
        return SkyblockerConfigManager.get().dungeons.devices.solveTargetPractice && Utils.isInDungeons() && DungeonManager.isInBoss() && DungeonManager.getBoss() == DungeonBoss.MAXOR;
    }

    private static void reset() {
        HIT_TARGETS.clear();
    }
}

