/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.DungeonPuzzle;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1614;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class Silverfish
extends DungeonPuzzle {
    public static final Silverfish INSTANCE = new Silverfish();
    private static final float[] RED_COLOR_COMPONENTS = ColorUtils.getFloatComponents(class_1767.field_7964);
    final boolean[][] silverfishBoard = new boolean[17][17];
    Vector2ic silverfishPos;
    final List<Vector2ic> silverfishPath = new ArrayList<Vector2ic>();

    private Silverfish() {
        super("silverfish", "ice-silverfish-room");
    }

    @Init
    public static void init() {
        if (Debug.debugEnabled()) {
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"dungeons").then(ClientCommandManager.literal((String)"puzzle").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)Silverfish.INSTANCE.puzzleName).then(ClientCommandManager.literal((String)"printBoard").executes(context -> {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693(Silverfish.boardToString(Silverfish.INSTANCE.silverfishBoard)));
                return 1;
            }))).then(ClientCommandManager.literal((String)"printPath").executes(context -> {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693(Silverfish.INSTANCE.silverfishPath.toString()));
                return 1;
            })))))));
        }
    }

    private static String boardToString(boolean[][] silverfishBoard) {
        StringBuilder sb = new StringBuilder();
        for (boolean[] row : silverfishBoard) {
            sb.append("\n");
            for (boolean cell : row) {
                sb.append(cell ? (char)'#' : '.');
            }
        }
        return sb.toString();
    }

    @Override
    public void tick(class_310 client) {
        boolean silverfishChanged;
        if (!SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveSilverfish || client.field_1687 == null || !DungeonManager.isCurrentRoomMatched()) {
            return;
        }
        Room room = DungeonManager.getCurrentRoom();
        boolean boardChanged = false;
        class_2338.class_2339 pos = new class_2338.class_2339(23, 67, 24);
        for (int row = 0; row < this.silverfishBoard.length; ++row) {
            for (int col = 0; col < this.silverfishBoard[row].length; ++col) {
                boolean isBlock;
                boolean bl = isBlock = !client.field_1687.method_8320(room.relativeToActual((class_2338)pos)).method_26215();
                if (this.silverfishBoard[row][col] != isBlock) {
                    this.silverfishBoard[row][col] = isBlock;
                    boardChanged = true;
                }
                pos.method_10098(class_2350.field_11039);
            }
            pos.method_10100(this.silverfishBoard[row].length, 0, -1);
        }
        List entities = client.field_1687.method_8390(class_1614.class, class_238.method_30048((class_243)class_243.method_24953((class_2382)room.relativeToActual(new class_2338(15, 66, 16))), (double)16.0, (double)16.0, (double)16.0), silverfishEntity -> true);
        if (entities.isEmpty()) {
            return;
        }
        class_2338 newSilverfishBlockPos = room.actualToRelative(((class_1614)entities.getFirst()).method_24515());
        Vector2i newSilverfishPos = new Vector2i(24 - newSilverfishBlockPos.method_10260(), 23 - newSilverfishBlockPos.method_10263());
        if (newSilverfishPos.x() < 0 || newSilverfishPos.x() >= 17 || newSilverfishPos.y() < 0 || newSilverfishPos.y() >= 17) {
            return;
        }
        boolean bl = silverfishChanged = !newSilverfishPos.equals((Object)this.silverfishPos);
        if (silverfishChanged) {
            this.silverfishPos = newSilverfishPos;
        }
        if (silverfishChanged || boardChanged) {
            this.solve();
        }
    }

    void solve() {
        if (this.silverfishPos == null) {
            return;
        }
        HashSet<Vector2ic> visited = new HashSet<Vector2ic>();
        ArrayDeque<List<Vector2ic>> queue = new ArrayDeque<List<Vector2ic>>();
        queue.add(List.of(this.silverfishPos));
        visited.add(this.silverfishPos);
        while (!queue.isEmpty()) {
            List path = (List)queue.poll();
            Vector2ic pos = (Vector2ic)path.get(path.size() - 1);
            if (pos.x() == 0 && pos.y() >= 7 && pos.y() <= 9) {
                this.silverfishPath.clear();
                this.silverfishPath.addAll(path);
                return;
            }
            Vector2i posMutable = new Vector2i(pos);
            while (posMutable.x() < 17 && !this.silverfishBoard[posMutable.x()][posMutable.y()]) {
                posMutable.add(1, 0);
            }
            posMutable.add(-1, 0);
            this.addQueue(visited, queue, path, (Vector2ic)posMutable);
            posMutable = new Vector2i(pos);
            while (posMutable.x() >= 0 && !this.silverfishBoard[posMutable.x()][posMutable.y()]) {
                posMutable.add(-1, 0);
            }
            posMutable.add(1, 0);
            this.addQueue(visited, queue, path, (Vector2ic)posMutable);
            posMutable = new Vector2i(pos);
            while (posMutable.y() < 17 && !this.silverfishBoard[posMutable.x()][posMutable.y()]) {
                posMutable.add(0, 1);
            }
            posMutable.add(0, -1);
            this.addQueue(visited, queue, path, (Vector2ic)posMutable);
            posMutable = new Vector2i(pos);
            while (posMutable.y() >= 0 && !this.silverfishBoard[posMutable.x()][posMutable.y()]) {
                posMutable.add(0, -1);
            }
            posMutable.add(0, 1);
            this.addQueue(visited, queue, path, (Vector2ic)posMutable);
        }
    }

    private void addQueue(Set<Vector2ic> visited, Queue<List<Vector2ic>> queue, List<Vector2ic> path, Vector2ic newPos) {
        if (!visited.contains(newPos)) {
            ArrayList<Vector2ic> newPath = new ArrayList<Vector2ic>(path);
            newPath.add(newPos);
            queue.add(newPath);
            visited.add(newPos);
        }
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        if (!SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveSilverfish || !DungeonManager.isCurrentRoomMatched() || this.silverfishPath.isEmpty()) {
            return;
        }
        Room room = DungeonManager.getCurrentRoom();
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int i = 0; i < this.silverfishPath.size() - 1; ++i) {
            class_243 start = class_243.method_24953((class_2382)room.relativeToActual((class_2338)pos.method_10103(23 - this.silverfishPath.get(i).y(), 67, 24 - this.silverfishPath.get(i).x())));
            class_243 end = class_243.method_24953((class_2382)room.relativeToActual((class_2338)pos.method_10103(23 - this.silverfishPath.get(i + 1).y(), 67, 24 - this.silverfishPath.get(i + 1).x())));
            collector.submitLinesFromPoints(new class_243[]{start, end}, RED_COLOR_COMPONENTS, 1.0f, 5.0f, true);
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (boolean[] silverfishBoardRow : this.silverfishBoard) {
            Arrays.fill(silverfishBoardRow, false);
        }
        this.silverfishPos = null;
    }
}

