/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle;

import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.DungeonPuzzle;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.skyblock.waypoint.FairySouls;
import de.hysky.skyblocker.utils.SkyblockTime;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;

public class Trivia
extends DungeonPuzzle {
    private static final Trivia INSTANCE = new Trivia();
    @VisibleForTesting
    public static final Pattern PATTERN = Pattern.compile("^ +(?:([A-Za-z,' ]*\\?)| ([\u24d0\u24d1\u24d2]) ([a-zA-Z0-9 ]+))|(\\[STATUE] Oruo the Omniscient: (\\w+ answered Question #\\d correctly!|I bestow upon you all the power of a hundred years!|Yikes))$");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2338 CHOICE_A = new class_2338(20, 70, 6);
    private static final class_2338 CHOICE_B = new class_2338(15, 70, 9);
    private static final class_2338 CHOICE_C = new class_2338(10, 70, 6);
    private static final float[] ANSWER_COLOR = new float[]{0.0f, 1.0f, 0.0f};
    private static final class_2350[] DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    private static final ArrayList<class_238> BOXES_TO_HIGHLIGHT = new ArrayList();
    private static final Map<String, List<String>> answers = new Object2ObjectOpenHashMap();
    private List<String> solutions = Collections.emptyList();
    private static String currentSolution = "";

    public Trivia() {
        super("trivia", "trivia-room");
        ClientReceiveMessageEvents.ALLOW_GAME.register(this::onMessage);
    }

    public boolean shouldRun() {
        return Utils.isInDungeons() && SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveTrivia;
    }

    public boolean onMessage(class_2561 message, boolean overlay) {
        if (!this.shouldRun() || overlay) {
            return true;
        }
        Matcher matcher = PATTERN.matcher(class_124.method_539((String)message.getString()));
        if (!matcher.matches()) {
            return true;
        }
        if (matcher.group(4) != null) {
            this.reset();
            return true;
        }
        String answerChoice = matcher.group(3);
        if (answerChoice == null) {
            this.updateSolutions(matcher.group(0));
            this.reset();
        } else {
            if (this.solutions.isEmpty()) {
                return true;
            }
            if (!this.solutions.contains(answerChoice)) {
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) {
                    return true;
                }
                Utils.sendMessageToBypassEvents(class_2561.method_30163((String)("    " + String.valueOf(class_124.field_1065) + " " + matcher.group(2) + " " + String.valueOf(class_124.field_1061) + answerChoice)));
                return false;
            }
            currentSolution = matcher.group(2);
        }
        return true;
    }

    private void updateSolutions(String question) {
        try {
            String trimmedQuestion = question.trim();
            if (trimmedQuestion.equals("What SkyBlock year is it?")) {
                int year = SkyblockTime.skyblockYear.get();
                this.solutions = Collections.singletonList("Year " + year);
            } else {
                this.solutions = answers.getOrDefault(trimmedQuestion, Collections.emptyList());
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to update the Trivia puzzle answers!", (Throwable)e);
        }
    }

    @Override
    public void tick(class_310 client) {
        if (!this.shouldRun() || currentSolution.isEmpty() || !BOXES_TO_HIGHLIGHT.isEmpty() || client.field_1687 == null) {
            return;
        }
        class_2338 correctBlockPos = Trivia.updateCorrectBlockPos();
        if (correctBlockPos == null) {
            return;
        }
        Room room = DungeonManager.getCurrentRoom();
        for (class_2350 direction : DIRECTIONS) {
            class_238 buttonBox = RenderHelper.getBlockBoundingBox(client.field_1687, room.relativeToActual(correctBlockPos).method_10093(direction));
            if (buttonBox == null) continue;
            BOXES_TO_HIGHLIGHT.add(buttonBox);
        }
    }

    @Nullable
    private static class_2338 updateCorrectBlockPos() {
        String string = currentSolution;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"\u24d0", "\u24d1", "\u24d2"}, (Object)string, n)) {
            case 0 -> CHOICE_A;
            case 1 -> CHOICE_B;
            case 2 -> CHOICE_C;
            default -> null;
        };
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        if (!this.shouldRun() || BOXES_TO_HIGHLIGHT.isEmpty()) {
            return;
        }
        for (class_238 box : BOXES_TO_HIGHLIGHT) {
            collector.submitFilledBox(box, ANSWER_COLOR, 0.5f, false);
            collector.submitOutlinedBox(box, ANSWER_COLOR, 5.0f, false);
        }
    }

    @Override
    public void reset() {
        currentSolution = "";
        BOXES_TO_HIGHLIGHT.clear();
    }

    @Init(priority=100)
    public static void init() {
        answers.put("What is the status of The Watcher?", List.of("Stalker"));
        answers.put("What is the status of Bonzo?", List.of("New Necromancer"));
        answers.put("What is the status of Scarf?", List.of("Apprentice Necromancer"));
        answers.put("What is the status of The Professor?", List.of("Professor"));
        answers.put("What is the status of Thorn?", List.of("Shaman Necromancer"));
        answers.put("What is the status of Livid?", List.of("Master Necromancer"));
        answers.put("What is the status of Sadan?", List.of("Necromancer Lord"));
        answers.put("What is the status of Maxor?", List.of("The Wither Lords"));
        answers.put("What is the status of Goldor?", List.of("The Wither Lords"));
        answers.put("What is the status of Storm?", List.of("The Wither Lords"));
        answers.put("What is the status of Necron?", List.of("The Wither Lords"));
        answers.put("What is the status of Maxor, Storm, Goldor, and Necron?", List.of("The Wither Lords"));
        answers.put("Which brother is on the Spider's Den?", List.of("Rick"));
        answers.put("What is the name of Rick's brother?", List.of("Pat"));
        answers.put("glass?", List.of("Wool Weaver"));
        answers.put("What is the name of the person that upgrades pets?", List.of("Kat"));
        answers.put("What is the name of the lady of the Nether?", List.of("Elle"));
        answers.put("Which villager in the Village gives you a Rogue Sword?", List.of("Jamie"));
        answers.put("How many unique minions are there?", List.of("59 Minions"));
        answers.put("Which of these enemies does not spawn in the Spider's Den?", List.of("Zombie Spider", "Cave Spider", "Wither Skeleton", "Dashing Spooder", "Broodfather", "Night Spider"));
        answers.put("Which of these monsters only spawns at night?", List.of("Zombie Villager", "Ghast"));
        answers.put("Which of these is not a dragon in The End?", List.of("Zoomer Dragon", "Weak Dragon", "Stonk Dragon", "Holy Dragon", "Boomer Dragon", "Booger Dragon", "Older Dragon", "Elder Dragon", "Stable Dragon", "Professor Dragon"));
        FairySouls.runAsyncAfterFairySoulsLoad(() -> {
            answers.put("How many total Fairy Souls are there?", Trivia.getFairySoulsSizeString(null));
            answers.put("How many Fairy Souls are there in Spider's Den?", Trivia.getFairySoulsSizeString("combat_1"));
            answers.put("How many Fairy Souls are there in The End?", Trivia.getFairySoulsSizeString("combat_3"));
            answers.put("How many Fairy Souls are there in The Farming Islands?", Trivia.getFairySoulsSizeString("farming_1"));
            answers.put("How many Fairy Souls are there in Crimson Isle?", Trivia.getFairySoulsSizeString("crimson_isle"));
            answers.put("How many Fairy Souls are there in The Park?", Trivia.getFairySoulsSizeString("foraging_1"));
            answers.put("How many Fairy Souls are there in Jerry's Workshop?", Trivia.getFairySoulsSizeString("winter"));
            answers.put("How many Fairy Souls are there in Hub?", Trivia.getFairySoulsSizeString("hub"));
            answers.put("How many Fairy Souls are there in The Hub?", Trivia.getFairySoulsSizeString("hub"));
            answers.put("How many Fairy Souls are there in Deep Caverns?", Trivia.getFairySoulsSizeString("mining_2"));
            answers.put("How many Fairy Souls are there in Gold Mine?", Trivia.getFairySoulsSizeString("mining_1"));
            answers.put("How many Fairy Souls are there in Dungeon Hub?", Trivia.getFairySoulsSizeString("dungeon_hub"));
        });
    }

    @NotNull
    private static List<String> getFairySoulsSizeString(@Nullable String location) {
        return List.of("%d Fairy Souls".formatted(FairySouls.getFairySoulsSize(location)));
    }
}

