/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle.boulder;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.DungeonPuzzle;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.boulder.BoulderBoard;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.boulder.BoulderObject;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.boulder.BoulderSolver;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.render.title.Title;
import de.hysky.skyblocker.utils.render.title.TitleContainer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class Boulder
extends DungeonPuzzle {
    private static final Boulder INSTANCE = new Boulder();
    private static final float[] RED_COLOR_COMPONENTS = ColorUtils.getFloatComponents(class_1767.field_7964);
    private static final float[] ORANGE_COLOR_COMPONENTS = ColorUtils.getFloatComponents(class_1767.field_7946);
    private static final int BASE_Y = 65;
    static class_243[] linePoints;
    static class_238 boundingBox;

    private Boulder() {
        super("boulder", "boxes-room");
    }

    @Init
    public static void init() {
    }

    @Override
    public void tick(class_310 client) {
        if (!(this.shouldSolve() && SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveBoulder && client.field_1687 != null && DungeonManager.isCurrentRoomMatched())) {
            return;
        }
        Room room = DungeonManager.getCurrentRoom();
        class_2338 chestPos = new class_2338(15, 65, 29);
        class_2338 start = new class_2338(25, 65, 25);
        class_2338 end = new class_2338(5, 65, 8);
        BoulderObject target = new BoulderObject(chestPos.method_10263(), chestPos.method_10263(), chestPos.method_10260(), "T");
        BoulderBoard board = new BoulderBoard(8, 7, target);
        int column = 1;
        for (int z = start.method_10260(); z > end.method_10260(); --z) {
            int row = 0;
            for (int x = start.method_10263(); x > end.method_10263(); --x) {
                if (Math.abs(start.method_10263() - x) % 3 != 1 || Math.abs(start.method_10260() - z) % 3 != 1) continue;
                String blockType = Boulder.getBlockType(client.field_1687, x, 65, z);
                board.placeObject(column, row, new BoulderObject(x, 65, z, blockType));
                ++row;
            }
            if (row != board.getWidth()) continue;
            ++column;
        }
        char[][] boardArray = board.getBoardCharArray();
        List<BoulderSolver.GameState> initialStates = Arrays.asList(new BoulderSolver.GameState(boardArray, board.getHeight() - 1, 0), new BoulderSolver.GameState(boardArray, board.getHeight() - 1, 1), new BoulderSolver.GameState(boardArray, board.getHeight() - 1, 2), new BoulderSolver.GameState(boardArray, board.getHeight() - 1, 3), new BoulderSolver.GameState(boardArray, board.getHeight() - 1, 4), new BoulderSolver.GameState(boardArray, board.getHeight() - 1, 5), new BoulderSolver.GameState(boardArray, board.getHeight() - 1, 6));
        List<int[]> solution = BoulderSolver.aStarSolve(initialStates);
        if (solution != null) {
            linePoints = new class_243[solution.size()];
            int index = 0;
            for (int[] coord : solution) {
                int x = coord[0];
                int y = coord[1];
                Boulder.linePoints[index++] = class_243.method_24953((class_2382)room.relativeToActual(board.getObject3DPosition(x, y)));
            }
            class_2338 button = null;
            if (linePoints != null && linePoints.length > 0) {
                for (int i = 0; i < linePoints.length - 1; ++i) {
                    class_243 point1 = linePoints[i];
                    class_243 point2 = linePoints[i + 1];
                    button = Boulder.checkForButtonBlocksOnLine(client.field_1687, point1, point2);
                    if (button == null) continue;
                    boundingBox = RenderHelper.getBlockBoundingBox(client.field_1687, button);
                    break;
                }
                if (button == null) {
                    this.reset();
                }
            }
        } else {
            Title title = new Title("skyblocker.dungeons.puzzle.boulder.noSolution", class_124.field_1060);
            TitleContainer.addTitleAndPlaySound(title, 15);
            this.reset();
        }
    }

    public static String getBlockType(class_638 world, int x, int y, int z) {
        class_2248 block = world.method_8320(DungeonManager.getCurrentRoom().relativeToActual(new class_2338(x, y, z))).method_26204();
        return block == class_2246.field_10148 || block == class_2246.field_10334 ? "B" : ".";
    }

    private static class_2338 checkForButtonBlocksOnLine(class_638 world, class_243 point1, class_243 point2) {
        double x1 = point1.method_10216();
        double y1 = point1.method_10214() + 1.0;
        double z1 = point1.method_10215();
        double x2 = point2.method_10216();
        double y2 = point2.method_10214() + 1.0;
        double z2 = point2.method_10215();
        int steps = (int)Math.max(Math.abs(x2 - x1), Math.max(Math.abs(y2 - y1), Math.abs(z2 - z1)));
        double xStep = (x2 - x1) / (double)steps;
        double yStep = (y2 - y1) / (double)steps;
        double zStep = (z2 - z1) / (double)steps;
        for (int step = 0; step <= steps; ++step) {
            double currentX = x1 + (double)step * xStep;
            double currentY = y1 + (double)step * yStep;
            double currentZ = z1 + (double)step * zStep;
            class_2338 blockPos = class_2338.method_49637((double)currentX, (double)currentY, (double)currentZ);
            class_2248 block = world.method_8320(blockPos).method_26204();
            if (block != class_2246.field_10494) continue;
            return blockPos;
        }
        return null;
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        if (!(this.shouldSolve() && SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveBoulder && DungeonManager.isCurrentRoomMatched())) {
            return;
        }
        float alpha = 1.0f;
        float lineWidth = 5.0f;
        if (linePoints != null && linePoints.length > 0) {
            for (int i = 0; i < linePoints.length - 1; ++i) {
                class_243 startPoint = linePoints[i];
                class_243 endPoint = linePoints[i + 1];
                collector.submitLinesFromPoints(new class_243[]{startPoint, endPoint}, ORANGE_COLOR_COMPONENTS, alpha, lineWidth, true);
            }
            if (boundingBox != null) {
                collector.submitFilledBox(boundingBox, RED_COLOR_COMPONENTS, 0.5f, false);
                collector.submitOutlinedBox(boundingBox, RED_COLOR_COMPONENTS, 5.0f, false);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        linePoints = null;
        boundingBox = null;
    }
}

