/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle.boulder;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;

public class BoulderSolver {
    public static List<int[]> aStarSolve(List<GameState> initialStates) {
        HashSet<GameState> visited = new HashSet<GameState>();
        PriorityQueue<Pair<GameState, List<int[]>>> queue = new PriorityQueue<Pair<GameState, List<int[]>>>(new AStarComparator());
        for (GameState initialState : initialStates) {
            queue.add((Pair<GameState, List<int[]>>)Pair.of((Object)initialState, new ArrayList()));
        }
        int maxIterations = 10000;
        int iterations = 0;
        while (!queue.isEmpty() && iterations < maxIterations) {
            Pair<GameState, List<int[]>> pair = queue.poll();
            GameState state = (GameState)pair.left();
            List path = (List)pair.right();
            if (state.isSolved()) {
                return path;
            }
            if (visited.contains(state)) continue;
            visited.add(state);
            int[] currentCoord = new int[]{state.playerX, state.playerY};
            path.add(currentCoord);
            int[][] nArrayArray = new int[][]{{-1, 0}, {0, -1}, {0, 1}, {1, 0}};
            int n = nArrayArray.length;
            for (int i = 0; i < n; ++i) {
                GameState newState = new GameState(state.grid, state.playerX, state.playerY);
                int[] direction = nArrayArray[i];
                if (!newState.movePlayer(direction[0], direction[1])) continue;
                queue.add((Pair<GameState, List<int[]>>)Pair.of((Object)newState, new ArrayList(path)));
            }
            ++iterations;
        }
        return null;
    }

    private static class AStarComparator
    implements Comparator<Pair<GameState, List<int[]>>> {
        private AStarComparator() {
        }

        @Override
        public int compare(Pair<GameState, List<int[]>> a, Pair<GameState, List<int[]>> b) {
            int costA = ((List)a.right()).size() + ((GameState)a.left()).heuristic();
            int costB = ((List)b.right()).size() + ((GameState)b.left()).heuristic();
            return Integer.compare(costA, costB);
        }
    }

    public static class GameState {
        private final char[][] grid;
        private int playerX;
        private int playerY;

        public GameState(char[][] grid, int playerX, int playerY) {
            this.grid = this.copyGrid(grid);
            this.playerX = playerX;
            this.playerY = playerY;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GameState gameState = (GameState)obj;
            return Arrays.deepEquals((Object[])this.grid, (Object[])gameState.grid) && this.playerX == gameState.playerX && this.playerY == gameState.playerY;
        }

        public int hashCode() {
            int result = Arrays.deepHashCode((Object[])this.grid);
            result = 31 * result + this.playerX;
            result = 31 * result + this.playerY;
            return result;
        }

        public boolean movePlayer(int dx, int dy) {
            int newX = this.playerX + dx;
            int newY = this.playerY + dy;
            if (this.isValidPosition(newX, newY)) {
                if (this.grid[newX][newY] == 'B') {
                    int nextToBoxX = newX + dx;
                    int nextToBoxY = newY + dy;
                    if (this.isValidPosition(nextToBoxX, nextToBoxY) && this.grid[nextToBoxX][nextToBoxY] == '.') {
                        this.grid[newX][newY] = 46;
                        this.grid[nextToBoxX][nextToBoxY] = 66;
                        this.playerX = newX;
                        this.playerY = newY;
                        return true;
                    }
                } else {
                    this.playerX = newX;
                    this.playerY = newY;
                    return true;
                }
            }
            return false;
        }

        private boolean isValidPosition(int x, int y) {
            return x >= 0 && y >= 0 && x < this.grid.length && y < this.grid[0].length;
        }

        public boolean isSolved() {
            return this.grid[this.playerX][this.playerY] == 'T';
        }

        public int heuristic() {
            for (int i = 0; i < this.grid.length; ++i) {
                for (int j = 0; j < this.grid[0].length; ++j) {
                    if (this.grid[i][j] != 'T') continue;
                    return Math.abs(this.playerX - i) + Math.abs(this.playerY - j);
                }
            }
            return Integer.MAX_VALUE;
        }

        private char[][] copyGrid(char[][] original) {
            char[][] copy = new char[original.length][];
            for (int i = 0; i < original.length; ++i) {
                copy[i] = (char[])original[i].clone();
            }
            return copy;
        }
    }
}

