/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.secrets;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.skyblock.dungeon.DungeonClass;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class DungeonPlayerManager {
    public static final Pattern PLAYER_TAB_PATTERN = Pattern.compile("\\[\\d+] (?:\\[[A-Za-z]+] )?(?<name>[A-Za-z0-9_]+) (?:.+ )?\\((?<class>\\S+) ?(?<level>[LXVI0]+)?\\)");
    public static final Pattern PLAYER_GHOST_PATTERN = Pattern.compile(" \u2620 (?<name>[A-Za-z0-9_]+) .+ became a ghost\\.");
    private static boolean dungeonLoaded;
    @Nullable
    private static final DungeonPlayer[] players;

    @Init
    public static void init() {
        DungeonEvents.DUNGEON_LOADED.register(() -> {
            dungeonLoaded = true;
        });
        Scheduler.INSTANCE.scheduleCyclic(DungeonPlayerManager::updatePlayers, 1);
        ClientReceiveMessageEvents.ALLOW_GAME.register(DungeonPlayerManager::onPlayerGhost);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> DungeonPlayerManager.reset());
    }

    @Nullable
    public static DungeonPlayer[] getPlayers() {
        return players;
    }

    public static Optional<DungeonPlayer> getPlayer(String name) {
        return Arrays.stream(players).filter(Objects::nonNull).filter(p -> p.name.equals(name)).findAny();
    }

    public static DungeonClass getClassFromPlayer(class_1657 player) {
        return DungeonPlayerManager.getClassFromPlayer(player.method_7334().name());
    }

    public static DungeonClass getClassFromPlayer(String name) {
        return DungeonPlayerManager.getPlayer(name).map(DungeonPlayer::dungeonClass).orElse(DungeonClass.UNKNOWN);
    }

    private static void updatePlayers() {
        if (!dungeonLoaded) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            Matcher matcher = DungeonPlayerManager.getPlayerFromTab(i + 1);
            if (matcher == null) {
                DungeonPlayerManager.players[i] = null;
                continue;
            }
            String name = matcher.group("name");
            DungeonClass dungeonClass = DungeonClass.from(matcher.group("class"));
            if (players[i] != null && DungeonPlayerManager.players[i].name.equals(name)) {
                players[i].update(dungeonClass);
                continue;
            }
            DungeonPlayerManager.players[i] = new DungeonPlayer(name, dungeonClass);
        }
    }

    public static Matcher getPlayerFromTab(@Range(from=1L, to=5L) int index) {
        return PlayerListManager.regexAt(1 + (index - 1) * 4, PLAYER_TAB_PATTERN);
    }

    private static boolean onPlayerGhost(class_2561 text, boolean overlay) {
        if (!dungeonLoaded) {
            return true;
        }
        Matcher matcher = PLAYER_GHOST_PATTERN.matcher(text.getString());
        if (!matcher.find()) {
            return true;
        }
        String name = matcher.group("name");
        if (name.equals("You")) {
            assert (class_310.method_1551().field_1724 != null);
            name = class_310.method_1551().field_1724.method_5477().getString();
        }
        DungeonPlayerManager.getPlayer(name).ifPresentOrElse(DungeonPlayer::ghost, () -> DungeonManager.LOGGER.error("[Skyblocker Dungeon Player Manager] Received ghost message for player '{}' but player was not found in the player list: {}", (Object)matcher.group("name"), (Object)Arrays.toString(players)));
        return true;
    }

    private static void reset() {
        dungeonLoaded = false;
        Arrays.fill(players, null);
    }

    static {
        players = new DungeonPlayer[5];
    }

    public static class DungeonPlayer {
        @Nullable
        private UUID uuid;
        @NotNull
        private final String name;
        @NotNull
        private DungeonClass dungeonClass = DungeonClass.UNKNOWN;
        private boolean alive;
        private long lastGhostTime;

        public DungeonPlayer(@NotNull String name, @NotNull DungeonClass dungeonClass) {
            this.uuid = DungeonPlayer.findPlayerUuid(name);
            this.name = name;
            this.update(dungeonClass);
            CompletableFuture.runAsync(() -> class_310.method_1551().method_73361().comp_837().fetchProfile(this.uuid, false));
        }

        @Nullable
        private static UUID findPlayerUuid(@NotNull String name) {
            assert (class_310.method_1551().field_1687 != null);
            return StreamSupport.stream(class_310.method_1551().field_1687.method_18112().spliterator(), false).filter(class_1657.class::isInstance).map(class_1657.class::cast).filter(player -> player.method_7334().name().equals(name)).findAny().map(class_1297::method_5667).orElse(null);
        }

        private void update(DungeonClass dungeonClass) {
            if (this.dungeonClass == DungeonClass.UNKNOWN && this.lastGhostTime + 2000L > System.currentTimeMillis()) {
                return;
            }
            this.dungeonClass = dungeonClass;
            this.alive = dungeonClass != DungeonClass.UNKNOWN;
        }

        private void ghost() {
            this.update(DungeonClass.UNKNOWN);
            this.lastGhostTime = System.currentTimeMillis();
        }

        @Nullable
        public UUID uuid() {
            if (this.uuid == null) {
                this.uuid = DungeonPlayer.findPlayerUuid(this.name);
                return this.uuid;
            }
            return this.uuid;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public DungeonClass dungeonClass() {
            return this.dungeonClass;
        }

        public boolean alive() {
            return this.alive;
        }

        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DungeonPlayer.class, "uuid;name;dungeonClass;alive;lastGhostTime", "uuid", "name", "dungeonClass", "alive", "lastGhostTime"}, this);
        }
    }
}

