/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.skyblock.dwarven.CorpseType;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.PosUtils;
import de.hysky.skyblocker.utils.command.argumenttypes.blockpos.ClientBlockPosArgumentType;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorpseFinder {
    private static boolean isLocationCorrect = false;
    private static final Pattern CORPSE_FOUND_PATTERN = Pattern.compile("([A-Z]+) CORPSE LOOT!");
    private static final Pattern COORDS_PATTERN = Pattern.compile("x: (?<x>-?\\d+), y: (?<y>\\d+), z: (?<z>-?\\d+)");
    private static final String PREFIX = "[Skyblocker Corpse Finder] ";
    private static final Logger LOGGER = LoggerFactory.getLogger(CorpseFinder.class);
    private static final Map<CorpseType, List<Corpse>> corpsesByType = new EnumMap<CorpseType, List<Corpse>>(CorpseType.class);
    private static boolean seenDebugWarning = false;

    @Init
    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((ignored, ignored2, ignored3) -> {
            isLocationCorrect = false;
            corpsesByType.clear();
        });
        SkyblockEvents.LOCATION_CHANGE.register(CorpseFinder::handleLocationChange);
        ClientReceiveMessageEvents.ALLOW_GAME.register(CorpseFinder::onChatMessage);
        WorldRenderExtractionCallback.EVENT.register(CorpseFinder::extractRendering);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!SkyblockerConfigManager.get().mining.glacite.enableCorpseFinder || client.field_1724 == null) {
                return;
            }
            if (!isLocationCorrect) {
                return;
            }
            for (List<Corpse> corpses : corpsesByType.values()) {
                for (Corpse corpse : corpses) {
                    if (corpse.seen || !client.field_1724.method_6057((class_1297)corpse.entity)) continue;
                    CorpseFinder.setSeen(corpse);
                }
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"corpseHelper").then(ClientCommandManager.literal((String)"shareLocation").then(ClientCommandManager.argument((String)"blockPos", (ArgumentType)ClientBlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"corpseType", (ArgumentType)CorpseType.CorpseTypeArgumentType.corpseType()).executes(context -> {
            CorpseFinder.shareLocation(ClientBlockPosArgumentType.getBlockPos((CommandContext<FabricClientCommandSource>)context, "blockPos"), CorpseType.CorpseTypeArgumentType.getCorpseType(context, "corpseType"));
            return 1;
        })))))));
    }

    private static void handleLocationChange(Location location) {
        isLocationCorrect = location == Location.GLACITE_MINESHAFT;
    }

    public static void checkIfCorpse(class_1297 entity) {
        if (entity instanceof class_1531) {
            class_1531 armorStand = (class_1531)entity;
            CorpseFinder.checkIfCorpse(armorStand);
        }
    }

    public static void checkIfCorpse(class_1531 armorStand) {
        if (!isLocationCorrect || !SkyblockerConfigManager.get().mining.glacite.enableCorpseFinder) {
            return;
        }
        if (armorStand.method_16914() || armorStand.method_5767() || armorStand.method_61489()) {
            return;
        }
        CorpseFinder.handleArmorStand(armorStand);
    }

    private static void handleArmorStand(class_1531 armorStand) {
        String helmetItemId = armorStand.method_6118(class_1304.field_6169).getSkyblockId();
        CorpseType corpseType = CorpseType.fromHelmetItemId(helmetItemId);
        if (corpseType == CorpseType.UNKNOWN) {
            return;
        }
        LOGGER.debug("[Skyblocker Corpse Finder] Triggered code for handleArmorStand and matched with ITEM_IDS");
        List corpses = corpsesByType.computeIfAbsent(corpseType, k -> new ArrayList());
        if (corpses.stream().noneMatch(c -> c.entity.method_24515().equals((Object)armorStand.method_24515()))) {
            float[] color = CorpseFinder.getColors(corpseType.color);
            Waypoint corpseWaypoint = new Waypoint(armorStand.method_24515().method_10084(), Waypoint.Type.OUTLINED_WAYPOINT, color);
            if (Debug.debugEnabled() && SkyblockerConfigManager.get().debug.corpseFinderDebug && !seenDebugWarning) {
                seenDebugWarning = true;
                if (true) {
                    class_310.method_1551().field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)"Corpse finder debug mode is active! Please use it only for the sake of debugging corpse detection!").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})), false);
                }
            }
            Corpse newCorpse = new Corpse(armorStand, corpseWaypoint, corpseType);
            corpses.add(newCorpse);
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (!SkyblockerConfigManager.get().mining.glacite.enableCorpseFinder || !isLocationCorrect) {
            return;
        }
        for (List<Corpse> corpses : corpsesByType.values()) {
            for (Corpse corpse : corpses) {
                if (!corpse.waypoint.shouldRender() || !corpse.seen && (!Debug.debugEnabled() || !SkyblockerConfigManager.get().debug.corpseFinderDebug)) continue;
                corpse.waypoint.extractRendering(collector);
            }
        }
    }

    private static boolean onChatMessage(class_2561 text, boolean overlay) {
        Matcher matcherCorpse;
        if (overlay || !isLocationCorrect || !SkyblockerConfigManager.get().mining.glacite.enableCorpseFinder || class_310.method_1551().field_1724 == null) {
            return true;
        }
        String string = text.getString();
        if (string.contains(class_310.method_1551().method_1548().method_1676())) {
            return true;
        }
        if (SkyblockerConfigManager.get().mining.glacite.enableParsingChatCorpseFinder) {
            CorpseFinder.parseCords(text);
        }
        if (!(matcherCorpse = CORPSE_FOUND_PATTERN.matcher(string)).find()) {
            return true;
        }
        LOGGER.debug("[Skyblocker Corpse Finder] Triggered code for onChatMessage");
        LOGGER.debug("[Skyblocker Corpse Finder] State of corpsesByType: {}", corpsesByType);
        String corpseTypeString = matcherCorpse.group(1).toUpperCase(Locale.ENGLISH);
        CorpseType corpseType = (CorpseType)EnumUtils.getEnum(CorpseType.class, (String)corpseTypeString, (Enum)CorpseType.UNKNOWN);
        List<Corpse> corpses = corpsesByType.get((Object)corpseType);
        if (corpses == null) {
            LOGGER.warn("[Skyblocker Corpse Finder] Couldn't get corpses! corpse type string: {}, parsed corpse type: {}", (Object)corpseTypeString, (Object)corpseType);
            return true;
        }
        corpses.stream().min(Comparator.comparingDouble(corpse -> corpse.entity.method_5858((class_1297)class_310.method_1551().field_1724))).ifPresentOrElse(corpse -> {
            LOGGER.info("[Skyblocker Corpse Finder] Found corpse, marking as found! {}: {}", (Object)corpse.entity.method_5864(), (Object)corpse.entity.method_24515().method_23854());
            corpse.waypoint.setFound();
        }, () -> LOGGER.warn("[Skyblocker Corpse Finder] Couldn't find the closest corpse despite triggering onChatMessage!"));
        return true;
    }

    private static void setSeen(Corpse corpse) {
        corpse.seen = true;
        if (SkyblockerConfigManager.get().mining.glacite.autoShareCorpses) {
            CorpseFinder.shareLocation(corpse.entity.method_24515().method_10084(), corpse.corpseType);
            return;
        }
        if (class_156.method_658() - corpse.messageLastSent < 300L) {
            return;
        }
        corpse.messageLastSent = class_156.method_658();
        class_310.method_1551().field_1724.method_7353((class_2561)Constants.PREFIX.get().method_27693("Found a ").method_10852((class_2561)class_2561.method_43470((String)(WordUtils.capitalizeFully((String)corpse.corpseType.method_15434()) + " Corpse")).method_54663(corpse.corpseType.color.method_532().intValue())).method_27693(" at " + corpse.entity.method_24515().method_10084().method_23854() + "!").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/skyblocker corpseHelper shareLocation " + PosUtils.toSpaceSeparatedString(corpse.waypoint.pos) + " " + corpse.corpseType.toString().toLowerCase(Locale.ENGLISH))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to share the location in chat!").method_27692(class_124.field_1060)))), false);
    }

    private static void shareLocation(class_2338 pos, CorpseType corpseType) {
        MessageScheduler.INSTANCE.sendMessageAfterCooldown("/pc " + CorpseFinder.toSkyhanniFormat(pos) + " | (" + WordUtils.capitalizeFully((String)corpseType.method_15434()) + " Corpse)", true);
    }

    private static float[] getColors(class_124 color) {
        return ColorUtils.getFloatComponents(color.method_532());
    }

    private static String toSkyhanniFormat(class_2338 pos) {
        return String.format("x: %d, y: %d, z: %d", pos.method_10263() + 1, pos.method_10264(), pos.method_10260() + 1);
    }

    private static void parseCords(class_2561 text) {
        int z;
        int y;
        int x;
        String message = text.getString();
        Matcher matcher = COORDS_PATTERN.matcher(message);
        if (!matcher.find()) {
            return;
        }
        try {
            x = Integer.parseInt(matcher.group("x"));
            y = Integer.parseInt(matcher.group("y"));
            z = Integer.parseInt(matcher.group("z"));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("[Skyblocker Corpse Finder] Failed to parse message: `{}`, reason: {}", (Object)message, (Object)e.getMessage());
            return;
        }
        LOGGER.debug("[Skyblocker Corpse Finder] Parsed message! X:{}, Y:{}, Z:{}", new Object[]{x, y, z});
        boolean foundCorpse = false;
        class_2338 parsedPos = new class_2338(x - 1, y, z - 1);
        block2: for (List<Corpse> corpses : corpsesByType.values()) {
            for (Corpse corpse : corpses) {
                if (!corpse.waypoint.pos.equals((Object)parsedPos)) continue;
                corpse.seen = true;
                foundCorpse = true;
                LOGGER.info("[Skyblocker Corpse Finder] Setting corpse {} as seen!", (Object)corpse.entity);
                class_310.method_1551().field_1724.method_7353((class_2561)Constants.PREFIX.get().method_27693("Parsed message from chat, adding corpse at ").method_27693(corpse.entity.method_24515().method_23854()), false);
                continue block2;
            }
        }
        if (!foundCorpse) {
            LOGGER.warn("[Skyblocker Corpse Finder] Did NOT find any match for corpses! corpsesByType.values(): {}", corpsesByType.values());
            LOGGER.info("[Skyblocker Corpse Finder] Proceeding to iterate over all corpses!");
            for (List<Corpse> corpses : corpsesByType.values()) {
                for (Corpse corpse : corpses) {
                    LOGGER.info("[Skyblocker Corpse Finder] Corpse: {}, BlockPos: {}", (Object)corpse.entity, (Object)corpse.entity.method_24515());
                }
            }
        }
    }

    static class Corpse {
        private final class_1531 entity;
        private final Waypoint waypoint;
        private final CorpseType corpseType;
        private boolean seen;
        private long messageLastSent = 0L;

        Corpse(class_1531 entity, Waypoint waypoint, CorpseType corpseType) {
            this.entity = entity;
            this.waypoint = waypoint;
            this.seen = false;
            this.corpseType = corpseType;
        }
    }
}

