/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import de.hysky.skyblocker.utils.ItemUtils;
import it.unimi.dsi.fastutil.doubles.DoubleBooleanPair;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_3542;
import net.minecraft.class_7485;

public enum CorpseType implements class_3542
{
    LAPIS("LAPIS_ARMOR_HELMET", null, class_124.field_1078),
    UMBER("ARMOR_OF_YOG_HELMET", "UMBER_KEY", class_124.field_1065),
    TUNGSTEN("MINERAL_HELMET", "TUNGSTEN_KEY", class_124.field_1080),
    VANGUARD("VANGUARD_HELMET", "SKELETON_KEY", class_124.field_1075),
    UNKNOWN("UNKNOWN", null, class_124.field_1061);

    public static final Codec<CorpseType> CODEC;
    public final String helmetItemId;
    public final String keyItemId;
    public final class_124 color;

    private CorpseType(String helmetItemId, String keyItemId, class_124 color) {
        this.helmetItemId = helmetItemId;
        this.keyItemId = keyItemId;
        this.color = color;
    }

    static CorpseType fromHelmetItemId(String helmetItemId) {
        for (CorpseType value : CorpseType.values()) {
            if (!value.helmetItemId.equals(helmetItemId)) continue;
            return value;
        }
        return UNKNOWN;
    }

    public String method_15434() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public double getKeyPrice() throws IllegalStateException {
        return switch (this.ordinal()) {
            case 4 -> throw new IllegalStateException("There's no key or key price for the UNKNOWN corpse type!");
            case 0 -> 0.0;
            default -> {
                DoubleBooleanPair result = ItemUtils.getItemPrice(this.keyItemId);
                if (!result.rightBoolean()) {
                    throw new IllegalStateException("No price found for key item `" + this.keyItemId + "`!");
                }
                yield result.leftDouble();
            }
        };
    }

    static {
        CODEC = class_3542.method_28140(CorpseType::values);
    }

    public static class CorpseTypeArgumentType
    extends class_7485<CorpseType> {
        protected CorpseTypeArgumentType() {
            super(CODEC, CorpseType::values);
        }

        static CorpseTypeArgumentType corpseType() {
            return new CorpseTypeArgumentType();
        }

        static <S> CorpseType getCorpseType(CommandContext<S> context, String name) {
            return (CorpseType)((Object)context.getArgument(name, CorpseType.class));
        }
    }
}

