/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven.profittrackers;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.Codec;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.ItemPriceUpdateEvent;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.AbstractProfitTracker;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.CodecUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.ProfiledData;
import it.unimi.dsi.fastutil.doubles.DoubleBooleanPair;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.lang.runtime.SwitchBootstraps;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PowderMiningTracker
extends AbstractProfitTracker {
    public static final PowderMiningTracker INSTANCE = new PowderMiningTracker();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Skyblocker Powder Mining Tracker");
    private static final Object2ObjectArrayMap<String, String> NAME2ID_MAP = new Object2ObjectArrayMap(50);
    private Object2IntMap<String> currentProfileRewards = new Object2IntOpenHashMap();
    private final Object2IntAVLTreeMap<class_2561> shownRewards = new Object2IntAVLTreeMap(Comparator.comparingInt(text -> PowderMiningTracker.comparePriority(text.getString())).thenComparing(class_2561::getString));
    private final ProfiledData<Object2IntMap<String>> allRewards = new ProfiledData(this.getRewardFilePath("powder-mining.json"), CodecUtils.object2IntMapCodec(Codec.STRING));
    private boolean insideChestMessage = false;
    private double profit = 0.0;

    private PowderMiningTracker() {
    }

    public boolean isEnabled() {
        return SkyblockerConfigManager.get().mining.crystalHollows.enablePowderTracker;
    }

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(INSTANCE::onChatMessage);
        ItemPriceUpdateEvent.ON_PRICE_UPDATE.register(INSTANCE::onPriceUpdate);
        PowderMiningTracker.INSTANCE.allRewards.init();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"rewardTrackers").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"powderMining").then(ClientCommandManager.literal((String)"list").executes(ctx -> {
            if (PowderMiningTracker.INSTANCE.currentProfileRewards.isEmpty()) {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.powderTracker.emptyHistory").method_27692(class_124.field_1061)));
                return 1;
            }
            if (PowderMiningTracker.INSTANCE.shownRewards.isEmpty()) {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.powderTracker.rewardsFilteredOut").method_27692(class_124.field_1061)));
                return 1;
            }
            for (Object2IntMap.Entry entry : PowderMiningTracker.INSTANCE.shownRewards.object2IntEntrySet()) {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43473().method_10852((class_2561)entry.getKey()).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(entry.getIntValue()))));
            }
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"skyblocker.powderTracker.profit", (Object[])new Object[]{NumberFormat.getInstance().format(PowderMiningTracker.INSTANCE.profit)}).method_27692(class_124.field_1065));
            return 1;
        }))).then(ClientCommandManager.literal((String)"reset").executes(ctx -> {
            PowderMiningTracker.INSTANCE.currentProfileRewards.clear();
            PowderMiningTracker.INSTANCE.allRewards.save();
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.powderTracker.historyReset").method_27692(class_124.field_1060)));
            return 1;
        }))))));
        SkyblockEvents.PROFILE_CHANGE.register(INSTANCE::onProfileChange);
        SkyblockEvents.PROFILE_INIT.register(INSTANCE::onProfileInit);
    }

    private void onProfileChange(String prevProfileId, String newProfileId) {
        this.onProfileInit(newProfileId);
    }

    private void onProfileInit(String profileId) {
        if (!this.isEnabled()) {
            return;
        }
        this.currentProfileRewards = this.allRewards.computeIfAbsent(Object2IntArrayMap::new);
        this.recalculateAll();
    }

    private boolean onChatMessage(class_2561 text, boolean overlay) {
        if (Utils.getLocation() != Location.CRYSTAL_HOLLOWS || !INSTANCE.isEnabled() || overlay) {
            return true;
        }
        String message = text.getString();
        if (this.insideChestMessage && message.equals("\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac")) {
            this.insideChestMessage = false;
            return true;
        }
        if (!this.insideChestMessage && (message.equals("  CHEST LOCKPICKED ") || SkyblockerConfigManager.get().mining.crystalHollows.countNaturalChestsInTracker && message.equals("  LOOT CHEST COLLECTED "))) {
            this.insideChestMessage = true;
            return true;
        }
        if (!this.insideChestMessage) {
            return true;
        }
        Matcher matcher = REWARD_PATTERN.matcher(message);
        if (!matcher.matches()) {
            return true;
        }
        String itemName = matcher.group(1);
        int amount = NumberUtils.toInt((String)matcher.group(2).replace(",", ""), (int)1);
        String itemId = this.getItemId(itemName);
        if (itemId.isEmpty()) {
            LOGGER.error("No matching item id for name `{}`. Report this!", (Object)itemName);
            return true;
        }
        this.incrementReward(itemName, itemId, amount);
        this.calculateProfitForItem(itemId, amount);
        return true;
    }

    private void incrementReward(String itemName, String itemId, int amount) {
        this.currentProfileRewards.mergeInt((Object)itemId, amount, Integer::sum);
        if (!SkyblockerConfigManager.get().mining.crystalHollows.powderTrackerFilter.contains(itemName)) {
            if (itemId.equals("GEMSTONE_POWDER")) {
                this.shownRewards.merge((Object)class_2561.method_43470((String)"Gemstone Powder").method_27692(class_124.field_1076), amount, Integer::sum);
            } else {
                class_1799 stack = ItemRepository.getItemStack(itemId);
                if (stack == null) {
                    LOGGER.warn("Item stack for id `{}` is null! This might be caused by failed item repository downloads.", (Object)itemId);
                    return;
                }
                this.shownRewards.merge((Object)stack.method_7964(), amount, Integer::sum);
            }
        }
    }

    private static int comparePriority(String itemName) {
        int n;
        String string = PowderMiningTracker.replaceGemstoneSymbols(itemName);
        Objects.requireNonNull(string);
        String string2 = string;
        int n2 = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"Gemstone Powder", "Gold Essence", "Diamond Essence", String.class, String.class, String.class, String.class}, (Object)string2, n2)) {
                case 0: {
                    n = 1;
                    break block9;
                }
                case 1: {
                    n = 2;
                    break block9;
                }
                case 2: {
                    n = 3;
                    break block9;
                }
                case 3: {
                    String s = string2;
                    if (!s.startsWith("Rough")) {
                        n2 = 4;
                        continue block9;
                    }
                    n = 4;
                    break block9;
                }
                case 4: {
                    String s = string2;
                    if (!s.startsWith("Flawed")) {
                        n2 = 5;
                        continue block9;
                    }
                    n = 5;
                    break block9;
                }
                case 5: {
                    String s = string2;
                    if (!s.startsWith("Fine")) {
                        n2 = 6;
                        continue block9;
                    }
                    n = 6;
                    break block9;
                }
                case 6: {
                    String s = string2;
                    if (!s.startsWith("Flawless")) {
                        n2 = 7;
                        continue block9;
                    }
                    n = 7;
                    break block9;
                }
                default: {
                    n = 8;
                    break block9;
                }
            }
            break;
        }
        return n;
    }

    private void onPriceUpdate() {
        if (this.isEnabled()) {
            this.recalculatePrices();
        }
    }

    private void calculateProfitForItem(String itemId, int amount) {
        DoubleBooleanPair price = ItemUtils.getItemPrice(itemId);
        if (price.rightBoolean()) {
            this.profit += price.leftDouble() * (double)amount;
        }
    }

    private void recalculatePrices() {
        this.profit = 0.0;
        ObjectSortedSet set = this.shownRewards.object2IntEntrySet();
        for (Object2IntMap.Entry entry : set) {
            this.calculateProfitForItem(this.getItemId(((class_2561)entry.getKey()).getString()), entry.getIntValue());
        }
    }

    public void recalculateAll() {
        this.shownRewards.clear();
        ObjectSet set = this.currentProfileRewards.object2IntEntrySet();
        List<String> filters = SkyblockerConfigManager.get().mining.crystalHollows.powderTrackerFilter.stream().map(INSTANCE::getItemId).toList();
        for (Object2IntMap.Entry entry : set) {
            if (filters.contains(entry.getKey())) continue;
            if (((String)entry.getKey()).equals("GEMSTONE_POWDER")) {
                this.shownRewards.put((Object)class_2561.method_43470((String)"Gemstone Powder").method_27692(class_124.field_1076), entry.getIntValue());
                continue;
            }
            class_1799 stack = ItemRepository.getItemStack((String)entry.getKey());
            if (stack == null) {
                LOGGER.warn("Item stack for id `{}` is null! This might be caused by failed item repository downloads.", entry.getKey());
                continue;
            }
            this.shownRewards.put((Object)stack.method_7964(), entry.getIntValue());
        }
        this.recalculatePrices();
    }

    public static @Unmodifiable Object2ObjectMap<String, String> getName2IdMap() {
        return Object2ObjectMaps.unmodifiable(NAME2ID_MAP);
    }

    @NotNull
    private String getItemId(String itemName) {
        return (String)NAME2ID_MAP.getOrDefault((Object)itemName, (Object)"");
    }

    public static double getProfit() {
        return PowderMiningTracker.INSTANCE.profit;
    }

    public static Object2IntMap<class_2561> getShownRewards() {
        return PowderMiningTracker.INSTANCE.shownRewards;
    }

    static {
        NAME2ID_MAP.put((Object)"Gemstone Powder", (Object)"GEMSTONE_POWDER");
        NAME2ID_MAP.put((Object)"\u2764 Rough Ruby Gemstone", (Object)"ROUGH_RUBY_GEM");
        NAME2ID_MAP.put((Object)"\u2764 Flawed Ruby Gemstone", (Object)"FLAWED_RUBY_GEM");
        NAME2ID_MAP.put((Object)"\u2764 Fine Ruby Gemstone", (Object)"FINE_RUBY_GEM");
        NAME2ID_MAP.put((Object)"\u2764 Flawless Ruby Gemstone", (Object)"FLAWLESS_RUBY_GEM");
        NAME2ID_MAP.put((Object)"\u2748 Rough Amethyst Gemstone", (Object)"ROUGH_AMETHYST_GEM");
        NAME2ID_MAP.put((Object)"\u2748 Flawed Amethyst Gemstone", (Object)"FLAWED_AMETHYST_GEM");
        NAME2ID_MAP.put((Object)"\u2748 Fine Amethyst Gemstone", (Object)"FINE_AMETHYST_GEM");
        NAME2ID_MAP.put((Object)"\u2748 Flawless Amethyst Gemstone", (Object)"FLAWLESS_AMETHYST_GEM");
        NAME2ID_MAP.put((Object)"\u2618 Rough Jade Gemstone", (Object)"ROUGH_JADE_GEM");
        NAME2ID_MAP.put((Object)"\u2618 Flawed Jade Gemstone", (Object)"FLAWED_JADE_GEM");
        NAME2ID_MAP.put((Object)"\u2618 Fine Jade Gemstone", (Object)"FINE_JADE_GEM");
        NAME2ID_MAP.put((Object)"\u2618 Flawless Jade Gemstone", (Object)"FLAWLESS_JADE_GEM");
        NAME2ID_MAP.put((Object)"\u2e15 Rough Amber Gemstone", (Object)"ROUGH_AMBER_GEM");
        NAME2ID_MAP.put((Object)"\u2e15 Flawed Amber Gemstone", (Object)"FLAWED_AMBER_GEM");
        NAME2ID_MAP.put((Object)"\u2e15 Fine Amber Gemstone", (Object)"FINE_AMBER_GEM");
        NAME2ID_MAP.put((Object)"\u2e15 Flawless Amber Gemstone", (Object)"FLAWLESS_AMBER_GEM");
        NAME2ID_MAP.put((Object)"\u270e Rough Sapphire Gemstone", (Object)"ROUGH_SAPPHIRE_GEM");
        NAME2ID_MAP.put((Object)"\u270e Flawed Sapphire Gemstone", (Object)"FLAWED_SAPPHIRE_GEM");
        NAME2ID_MAP.put((Object)"\u270e Fine Sapphire Gemstone", (Object)"FINE_SAPPHIRE_GEM");
        NAME2ID_MAP.put((Object)"\u270e Flawless Sapphire Gemstone", (Object)"FLAWLESS_SAPPHIRE_GEM");
        NAME2ID_MAP.put((Object)"\u2727 Rough Topaz Gemstone", (Object)"ROUGH_TOPAZ_GEM");
        NAME2ID_MAP.put((Object)"\u2727 Flawed Topaz Gemstone", (Object)"FLAWED_TOPAZ_GEM");
        NAME2ID_MAP.put((Object)"\u2727 Fine Topaz Gemstone", (Object)"FINE_TOPAZ_GEM");
        NAME2ID_MAP.put((Object)"\u2727 Flawless Topaz Gemstone", (Object)"FLAWLESS_TOPAZ_GEM");
        NAME2ID_MAP.put((Object)"\u2741 Rough Jasper Gemstone", (Object)"ROUGH_JASPER_GEM");
        NAME2ID_MAP.put((Object)"\u2741 Flawed Jasper Gemstone", (Object)"FLAWED_JASPER_GEM");
        NAME2ID_MAP.put((Object)"\u2741 Fine Jasper Gemstone", (Object)"FINE_JASPER_GEM");
        NAME2ID_MAP.put((Object)"\u2741 Flawless Jasper Gemstone", (Object)"FLAWLESS_JASPER_GEM");
        NAME2ID_MAP.put((Object)"Pickonimbus 2000", (Object)"PICKONIMBUS");
        NAME2ID_MAP.put((Object)"Ascension Rope", (Object)"ASCENSION_ROPE");
        NAME2ID_MAP.put((Object)"Wishing Compass", (Object)"WISHING_COMPASS");
        NAME2ID_MAP.put((Object)"Gold Essence", (Object)"ESSENCE_GOLD");
        NAME2ID_MAP.put((Object)"Diamond Essence", (Object)"ESSENCE_DIAMOND");
        NAME2ID_MAP.put((Object)"Prehistoric Egg", (Object)"PREHISTORIC_EGG");
        NAME2ID_MAP.put((Object)"Sludge Juice", (Object)"SLUDGE_JUICE");
        NAME2ID_MAP.put((Object)"Oil Barrel", (Object)"OIL_BARREL");
        NAME2ID_MAP.put((Object)"Jungle Heart", (Object)"JUNGLE_HEART");
        NAME2ID_MAP.put((Object)"Treasurite", (Object)"TREASURITE");
        NAME2ID_MAP.put((Object)"Yoggie", (Object)"YOGGIE");
        NAME2ID_MAP.put((Object)"Goblin Egg", (Object)"GOBLIN_EGG");
        NAME2ID_MAP.put((Object)"Green Goblin Egg", (Object)"GOBLIN_EGG_GREEN");
        NAME2ID_MAP.put((Object)"Blue Goblin Egg", (Object)"GOBLIN_EGG_BLUE");
        NAME2ID_MAP.put((Object)"Red Goblin Egg", (Object)"GOBLIN_EGG_RED");
        NAME2ID_MAP.put((Object)"Yellow Goblin Egg", (Object)"GOBLIN_EGG_YELLOW");
        NAME2ID_MAP.put((Object)"Control Switch", (Object)"CONTROL_SWITCH");
        NAME2ID_MAP.put((Object)"Electron Transmitter", (Object)"ELECTRON_TRANSMITTER");
        NAME2ID_MAP.put((Object)"FTX 3070", (Object)"FTX_3070");
        NAME2ID_MAP.put((Object)"Synthetic Heart", (Object)"SYNTHETIC_HEART");
        NAME2ID_MAP.put((Object)"Robotron Reflector", (Object)"ROBOTRON_REFLECTOR");
        NAME2ID_MAP.put((Object)"Superlite Motor", (Object)"SUPERLITE_MOTOR");
    }
}

