/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse;

import de.hysky.skyblocker.skyblock.dwarven.CorpseType;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.CorpseLoot;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.CorpseProfitTracker;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.Reward;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.render.HudHelper;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import org.apache.commons.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorpseList
extends class_4265<AbstractEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorpseList.class);
    private static final int BORDER_COLOR = -9670522;
    private static final int INNER_MARGIN = 2;

    public CorpseList(class_310 client, int width, int height, int y, int entryHeight, List<CorpseLoot> lootList) {
        super(client, width, height, y, entryHeight);
        if (lootList.isEmpty()) {
            this.addEmptyEntry();
            this.addEmptyEntry();
            this.addEmptyEntry();
            this.method_25321((class_350.class_351)new SingleEntry((class_2561)class_2561.method_43470((String)"Your corpse history list is empty :(").method_27692(class_124.field_1061), false));
            return;
        }
        for (int i = 0; i < lootList.size(); ++i) {
            CorpseLoot loot = lootList.get(i);
            CorpseType type = loot.corpseType();
            this.method_25321((class_350.class_351)new SingleEntry((class_2561)class_2561.method_43470((String)(WordUtils.capitalizeFully((String)type.name()) + " Corpse")).method_27692(type.color)));
            this.method_25321((class_350.class_351)new SingleEntry((class_2561)class_2561.method_43470((String)DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.ofInstant(loot.timestamp(), ZoneId.systemDefault()))).method_27692(class_124.field_1076)));
            List<Reward> entries = loot.rewards();
            for (Reward reward : entries) {
                class_2561 itemName = CorpseList.getItemName(reward.itemId());
                if (CorpseProfitTracker.PRICELESS_ITEMS.contains(reward.itemId())) {
                    this.method_25321((class_350.class_351)new MultiEntry(itemName, reward.amount()));
                    continue;
                }
                this.method_25321((class_350.class_351)new MultiEntry(itemName, reward.amount(), reward.pricePerUnit()));
            }
            if (type != CorpseType.LAPIS && type != CorpseType.UNKNOWN) {
                this.method_25321((class_350.class_351)new MultiEntry(type.getKeyPrice(), true));
            }
            if (loot.isPriceDataComplete()) {
                this.method_25321((class_350.class_351)new MultiEntry(loot.profit()));
            } else {
                this.method_25321((class_350.class_351)new SingleEntry((class_2561)class_2561.method_43470((String)"Price data incomplete, can't calculate profit").method_27692(class_124.field_1061)));
            }
            if (i >= lootList.size() - 1) continue;
            this.addEmptyEntry();
            this.addEmptyEntry();
        }
    }

    public static class_2561 getItemName(String itemId) {
        return switch (itemId) {
            case "GLACITE_POWDER" -> class_2561.method_43470((String)"Glacite Powder").method_27692(class_124.field_1075);
            case "OPAL_CRYSTAL" -> class_2561.method_43470((String)"Opal Crystal").method_27692(class_124.field_1068);
            case "ONYX_CRYSTAL" -> class_2561.method_43470((String)"Onyx Crystal").method_27692(class_124.field_1063);
            case "AQUAMARINE_CRYSTAL" -> class_2561.method_43470((String)"Aquamarine Crystal").method_27692(class_124.field_1078);
            case "PERIDOT_CRYSTAL" -> class_2561.method_43470((String)"Peridot Crystal").method_27692(class_124.field_1077);
            case "CITRINE_CRYSTAL" -> class_2561.method_43470((String)"Citrine Crystal").method_27692(class_124.field_1079);
            case "RUBY_CRYSTAL" -> class_2561.method_43470((String)"Ruby Crystal").method_27692(class_124.field_1061);
            case "JASPER_CRYSTAL" -> class_2561.method_43470((String)"Jasper Crystal").method_27692(class_124.field_1076);
            case "ENCHANTMENT_ICE_COLD_1" -> class_2561.method_43470((String)"Enchanted Book (Ice Cold I)").method_27692(class_124.field_1068);
            default -> {
                class_1799 itemStack = ItemRepository.getItemStack(itemId);
                if (itemStack == null) {
                    LOGGER.error("Item stack for item ID {} is null", (Object)itemId);
                    yield class_2561.method_43473();
                }
                yield itemStack.method_7964();
            }
        };
    }

    private void addEmptyEntry() {
        this.method_25321((class_350.class_351)new EmptyEntry());
    }

    public int method_25322() {
        return 500;
    }

    public static class SingleEntry
    extends AbstractEntry {
        private boolean drawBorder = true;

        public SingleEntry(class_2561 text) {
            this.children = List.of(new class_7842(text, class_310.method_1551().field_1772));
        }

        public SingleEntry(class_2561 text, boolean drawBorder) {
            this(text);
            this.drawBorder = drawBorder;
        }

        @Override
        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            if (this.drawBorder) {
                HudHelper.drawBorder(context, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364() + 1, -9670522);
            }
            for (class_339 child : this.children) {
                child.method_46421(this.method_46426() + 2);
                child.method_46419(this.method_46427() + 2);
                child.method_25358(this.method_25368() - 4);
                child.method_25394(context, mouseX, mouseY, deltaTicks);
            }
        }
    }

    public static class MultiEntry
    extends AbstractEntry {
        @Nullable
        protected class_7842 itemName;
        @Nullable
        protected class_7842 amount = null;
        @Nullable
        protected class_7842 totalPrice;
        @Nullable
        protected class_7842 pricePerUnit = null;

        public MultiEntry(class_2561 itemName, int amount, double pricePerUnit) {
            this.itemName = new class_7842(itemName, class_310.method_1551().field_1772);
            this.amount = new class_7842((class_2561)class_2561.method_43470((String)("x" + amount)).method_27692(class_124.field_1075), class_310.method_1551().field_1772);
            this.totalPrice = new class_7842((class_2561)class_2561.method_43470((String)(NumberFormat.getInstance().format((double)amount * pricePerUnit) + " Coins")).method_27692(class_124.field_1065), class_310.method_1551().field_1772);
            this.pricePerUnit = new class_7842((class_2561)class_2561.method_43470((String)(NumberFormat.getInstance().format(pricePerUnit) + " each")).method_27692(class_124.field_1080), class_310.method_1551().field_1772);
            this.children = List.of(this.itemName, this.amount, this.totalPrice, this.pricePerUnit);
        }

        public MultiEntry(class_2561 itemName, int amount) {
            this.itemName = new class_7842(itemName, class_310.method_1551().field_1772);
            this.amount = new class_7842((class_2561)class_2561.method_43470((String)("x" + amount)).method_27692(class_124.field_1075), class_310.method_1551().field_1772);
            this.children = List.of(this.itemName, this.amount);
        }

        public MultiEntry(double profit) {
            this.itemName = new class_7842((class_2561)class_2561.method_43470((String)"Total Profit").method_27695(new class_124[]{class_124.field_1067, class_124.field_1065}), class_310.method_1551().field_1772);
            this.totalPrice = new class_7842((class_2561)class_2561.method_43470((String)(NumberFormat.getInstance().format(profit) + " Coins")).method_27692(profit > 0.0 ? class_124.field_1060 : class_124.field_1061), class_310.method_1551().field_1772);
            this.children = List.of(this.itemName, this.totalPrice);
        }

        public MultiEntry(double keyPrice, boolean isKey) {
            if (!isKey) {
                throw new IllegalArgumentException("This constructor is only for key entries");
            }
            this.itemName = new class_7842((class_2561)class_2561.method_43470((String)"Key Price").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), class_310.method_1551().field_1772);
            this.amount = new class_7842((class_2561)class_2561.method_43470((String)"x1").method_27692(class_124.field_1075), class_310.method_1551().field_1772);
            this.totalPrice = new class_7842((class_2561)class_2561.method_43470((String)("-" + NumberFormat.getInstance().format(keyPrice) + " Coins")).method_27692(class_124.field_1061), class_310.method_1551().field_1772);
            this.children = List.of(this.itemName, this.amount, this.totalPrice);
        }

        @Override
        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            int x = this.method_46426();
            int y = this.method_46427();
            int entryWidth = this.method_25368();
            int entryHeight = this.method_25364();
            HudHelper.drawBorder(context, x, y, entryWidth, entryHeight + 1, -9670522);
            HudHelper.drawBorder(context, x + entryWidth / 3, y, entryWidth / 6 + 2, entryHeight + 1, -9670522);
            HudHelper.drawBorder(context, x + entryWidth / 2, y, entryWidth / 4, entryHeight + 1, -9670522);
            int entryY = y + 2;
            if (this.itemName != null) {
                this.itemName.method_46421(x + 2);
                this.itemName.method_46419(entryY);
                this.itemName.method_73395(entryWidth / 3 - 4, class_7842.class_11764.field_62127);
                this.itemName.method_25394(context, mouseX, mouseY, deltaTicks);
            }
            if (this.amount != null) {
                MultiEntry.position(this.amount, x + entryWidth / 3 + 2, entryWidth / 6 - 4, entryY);
                this.amount.method_25394(context, mouseX, mouseY, deltaTicks);
            }
            if (this.totalPrice != null) {
                MultiEntry.position(this.totalPrice, x + entryWidth / 2 + 2, entryWidth / 4 - 4, entryY);
                this.totalPrice.method_25394(context, mouseX, mouseY, deltaTicks);
            }
            if (this.pricePerUnit != null) {
                MultiEntry.position(this.pricePerUnit, x + 3 * entryWidth / 4 + 2, entryWidth / 4 - 4, entryY);
                this.pricePerUnit.method_25394(context, mouseX, mouseY, deltaTicks);
            }
        }

        private static void position(class_7842 widget, int start, int width, int y) {
            widget.method_73395(width, class_7842.class_11764.field_62127);
            widget.method_46421(start + (width - widget.method_25368()) / 2);
            widget.method_46419(y);
        }
    }

    public static class EmptyEntry
    extends AbstractEntry {
        public EmptyEntry() {
            this.children = List.of();
        }
    }

    public static abstract class AbstractEntry
    extends class_4265.class_4266<AbstractEntry> {
        protected List<class_339> children;

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }
    }
}

