/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.fancybars;

import de.hysky.skyblocker.skyblock.fancybars.BarPositioner;
import de.hysky.skyblocker.skyblock.fancybars.EditBarWidget;
import de.hysky.skyblocker.skyblock.fancybars.FancyStatusBars;
import de.hysky.skyblocker.skyblock.fancybars.StatusBar;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectBooleanMutablePair;
import it.unimi.dsi.fastutil.objects.ObjectBooleanPair;
import it.unimi.dsi.fastutil.objects.ObjectObjectMutablePair;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_8027;
import net.minecraft.class_8028;
import net.minecraft.class_8029;
import net.minecraft.class_8030;
import net.minecraft.class_8816;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class StatusBarsConfigScreen
extends class_437 {
    private static final class_2960 HOTBAR_TEXTURE = class_2960.method_60656((String)"hud/hotbar");
    private static final int HOTBAR_WIDTH = 182;
    private static final float RESIZE_THRESHOLD = 0.75f;
    private static final int BAR_MINIMUM_WIDTH = 30;
    public static final long RESIZE_CURSOR = GLFW.glfwCreateStandardCursor((int)221189);
    private static final class_8028[] DIRECTION_CHECK_ORDER = new class_8028[]{class_8028.field_41828, class_8028.field_41829, class_8028.field_41826, class_8028.field_41827};
    private static boolean resizeCursor = false;
    private final Map<class_8030, Pair<StatusBar, BarPositioner.BarLocation>> rectToBar = new HashMap<class_8030, Pair<StatusBar, BarPositioner.BarLocation>>();
    private final ObjectBooleanPair<@Nullable StatusBar> resizeHover = new ObjectBooleanMutablePair(null, false);
    private final Pair<@Nullable StatusBar, @Nullable StatusBar> resizedBars = ObjectObjectMutablePair.of(null, null);
    @Nullable
    private StatusBar cursorBar = null;
    private class_8029 cursorOffset = new class_8029(0, 0);
    private BarPositioner.BarLocation currentInsertLocation = new BarPositioner.BarLocation(null, 0, 0);
    private boolean resizing = false;
    private EditBarWidget editBarWidget;

    private static void setResizeCursor(boolean bl) {
        if (bl != resizeCursor) {
            resizeCursor = bl;
            class_1041 window = class_310.method_1551().method_22683();
            if (resizeCursor) {
                GLFW.glfwSetCursor((long)window.method_4490(), (long)RESIZE_CURSOR);
            } else {
                GLFW.glfwSetCursor((long)window.method_4490(), (long)0L);
            }
        }
    }

    public StatusBarsConfigScreen() {
        super(class_2561.method_30163((String)"Status Bars Config"));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        block27: {
            class_8030 mouseRect;
            block28: {
                boolean hasRight;
                StatusBar rightBar;
                block31: {
                    boolean hasLeft;
                    StatusBar leftBar;
                    block29: {
                        float widthPerSize;
                        boolean doResize;
                        BarPositioner.SizeRule sizeRule;
                        int middleX;
                        block30: {
                            BarPositioner.BarAnchor barAnchor;
                            block26: {
                                super.method_25394(context, mouseX, mouseY, delta);
                                context.method_52706(class_10799.field_56883, HOTBAR_TEXTURE, this.field_22789 / 2 - 91, this.field_22790 - 22, 182, 22);
                                this.editBarWidget.method_25394(context, mouseX, mouseY, delta);
                                assert (this.field_22787 != null);
                                class_1041 window = this.field_22787.method_22683();
                                int scaleFactor = window.method_4476(0, this.field_22787.method_1573()) - window.method_4495() + 3;
                                if ((scaleFactor & 2) == 0) {
                                    ++scaleFactor;
                                }
                                mouseRect = new class_8030(new class_8029(mouseX - scaleFactor / 2, mouseY - scaleFactor / 2), scaleFactor, scaleFactor);
                                if (this.cursorBar == null) break block26;
                                this.cursorBar.renderCursor(context, mouseX + this.cursorOffset.comp_1193(), mouseY + this.cursorOffset.comp_1194(), delta);
                                boolean inserted = false;
                                boolean updatePositions = false;
                                block0: for (class_8030 screenRect : this.rectToBar.keySet()) {
                                    for (class_8028 direction : DIRECTION_CHECK_ORDER) {
                                        boolean overlaps = screenRect.method_48256(direction).method_48251(direction).method_48252(mouseRect);
                                        if (!overlaps) continue;
                                        Pair<StatusBar, BarPositioner.BarLocation> barPair = this.rectToBar.get(screenRect);
                                        BarPositioner.BarLocation barSnap = (BarPositioner.BarLocation)barPair.right();
                                        if (barSnap.barAnchor() == null) continue block0;
                                        if (direction.method_48237().equals((Object)class_8027.field_41823)) {
                                            int neighborInsertY = StatusBarsConfigScreen.getNeighborInsertY(barSnap, !direction.method_48241());
                                            inserted = true;
                                            if (this.currentInsertLocation.equals(barSnap.barAnchor(), barSnap.x(), neighborInsertY)) break block0;
                                            if (this.cursorBar.anchor != null) {
                                                FancyStatusBars.barPositioner.removeBar(this.cursorBar.anchor, this.cursorBar.gridY, this.cursorBar);
                                            }
                                            FancyStatusBars.barPositioner.addRow(barSnap.barAnchor(), neighborInsertY);
                                            FancyStatusBars.barPositioner.addBar(barSnap.barAnchor(), neighborInsertY, this.cursorBar);
                                            this.currentInsertLocation = BarPositioner.BarLocation.of(this.cursorBar);
                                            updatePositions = true;
                                            break block0;
                                        }
                                        int neighborInsertX = StatusBarsConfigScreen.getNeighborInsertX(barSnap, direction.method_48241());
                                        inserted = true;
                                        if (this.currentInsertLocation.equals(barSnap.barAnchor(), neighborInsertX, barSnap.y())) break block0;
                                        if (this.cursorBar.anchor != null) {
                                            FancyStatusBars.barPositioner.removeBar(this.cursorBar.anchor, this.cursorBar.gridY, this.cursorBar);
                                        }
                                        FancyStatusBars.barPositioner.addBar(barSnap.barAnchor(), barSnap.y(), neighborInsertX, this.cursorBar);
                                        this.currentInsertLocation = BarPositioner.BarLocation.of(this.cursorBar);
                                        updatePositions = true;
                                        break block0;
                                    }
                                }
                                if (updatePositions) {
                                    FancyStatusBars.updatePositions(true);
                                    return;
                                }
                                for (BarPositioner.BarAnchor barAnchor2 : BarPositioner.BarAnchor.allAnchors()) {
                                    class_8030 anchorHitbox = barAnchor2.getAnchorHitbox(barAnchor2.getAnchorPosition(this.field_22789, this.field_22790));
                                    if (FancyStatusBars.barPositioner.getRowCount(barAnchor2) != 0) {
                                        LinkedList<StatusBar> row;
                                        if (FancyStatusBars.barPositioner.getRowCount(barAnchor2) != 1 || (row = FancyStatusBars.barPositioner.getRow(barAnchor2, 0)).size() != 1 || row.getFirst() != this.cursorBar || !anchorHitbox.method_48252(mouseRect)) continue;
                                        inserted = true;
                                        continue;
                                    }
                                    context.method_25294(anchorHitbox.method_49620(), anchorHitbox.method_49618(), anchorHitbox.method_49621(), anchorHitbox.method_49619(), -1711276033);
                                    if (!anchorHitbox.method_48252(mouseRect)) continue;
                                    inserted = true;
                                    if (this.currentInsertLocation.barAnchor() == barAnchor2) continue;
                                    if (this.cursorBar.anchor != null) {
                                        FancyStatusBars.barPositioner.removeBar(this.cursorBar.anchor, this.cursorBar.gridY, this.cursorBar);
                                    }
                                    FancyStatusBars.barPositioner.addRow(barAnchor2);
                                    FancyStatusBars.barPositioner.addBar(barAnchor2, 0, this.cursorBar);
                                    this.currentInsertLocation = BarPositioner.BarLocation.of(this.cursorBar);
                                    FancyStatusBars.updatePositions(true);
                                }
                                if (!inserted) {
                                    if (this.cursorBar.anchor != null) {
                                        FancyStatusBars.barPositioner.removeBar(this.cursorBar.anchor, this.cursorBar.gridY, this.cursorBar);
                                    }
                                    this.currentInsertLocation = BarPositioner.BarLocation.NULL;
                                    FancyStatusBars.updatePositions(true);
                                    this.cursorBar.method_46421(this.field_22789 + 5);
                                }
                                break block27;
                            }
                            if (!this.resizing) break block28;
                            rightBar = (StatusBar)this.resizedBars.right();
                            leftBar = (StatusBar)this.resizedBars.left();
                            hasRight = rightBar != null;
                            boolean bl = hasLeft = leftBar != null;
                            if (!hasRight) {
                                barAnchor = leftBar.anchor;
                                middleX = leftBar.method_46426() + leftBar.method_25368();
                            } else {
                                barAnchor = rightBar.anchor;
                                middleX = rightBar.method_46426();
                            }
                            if (barAnchor == null) break block29;
                            sizeRule = barAnchor.getSizeRule();
                            doResize = true;
                            widthPerSize = sizeRule.isTargetSize() ? (float)sizeRule.totalWidth() / (float)sizeRule.targetSize() : (float)sizeRule.widthPerSize();
                            if (mouseX >= middleX) break block30;
                            if (!((float)(middleX - mouseX) > widthPerSize / 0.75f)) break block27;
                            if (hasRight && rightBar.size + 1 > sizeRule.maxSize()) {
                                doResize = false;
                            }
                            if (hasLeft && leftBar.size - 1 < sizeRule.minSize()) {
                                doResize = false;
                            }
                            if (!doResize) break block27;
                            if (hasRight) {
                                ++rightBar.size;
                            }
                            if (hasLeft) {
                                --leftBar.size;
                            }
                            FancyStatusBars.updatePositions(true);
                            break block27;
                        }
                        if (!((float)(mouseX - middleX) > widthPerSize / 0.75f)) break block27;
                        if (hasRight && rightBar.size - 1 < sizeRule.minSize()) {
                            doResize = false;
                        }
                        if (hasLeft && leftBar.size + 1 > sizeRule.maxSize()) {
                            doResize = false;
                        }
                        if (!doResize) break block27;
                        if (hasRight) {
                            --rightBar.size;
                        }
                        if (hasLeft) {
                            ++leftBar.size;
                        }
                        FancyStatusBars.updatePositions(true);
                        break block27;
                    }
                    if (!hasLeft) break block31;
                    leftBar.setWidth(Math.max(30, mouseX - leftBar.method_46426()));
                    break block27;
                }
                if (!hasRight) break block27;
                int endX = rightBar.method_46426() + rightBar.method_25368();
                rightBar.method_46421(Math.min(endX - 30, mouseX));
                rightBar.setWidth(endX - rightBar.method_46426());
                break block27;
            }
            block3: for (class_8030 screenRect : this.rectToBar.keySet()) {
                for (class_8028 direction : new class_8028[]{class_8028.field_41828, class_8028.field_41829}) {
                    boolean overlaps = screenRect.method_48256(direction).method_48251(direction).method_48252(mouseRect);
                    if (overlaps && !this.editBarWidget.method_25405(mouseX, mouseY)) {
                        Pair<StatusBar, BarPositioner.BarLocation> barPair = this.rectToBar.get(screenRect);
                        BarPositioner.BarLocation barLocation = (BarPositioner.BarLocation)barPair.right();
                        StatusBar bar = (StatusBar)barPair.left();
                        if (!bar.enabled) continue block3;
                        boolean right = direction.equals((Object)class_8028.field_41829);
                        if (barLocation.barAnchor() != null && (barLocation.barAnchor().getSizeRule().isTargetSize() && !FancyStatusBars.barPositioner.hasNeighbor(barLocation.barAnchor(), barLocation.y(), barLocation.x(), right) || !barLocation.barAnchor().getSizeRule().isTargetSize() && barLocation.x() == 0 && barLocation.barAnchor().isRight() != right)) continue block3;
                        this.resizeHover.first((Object)bar);
                        this.resizeHover.right(right);
                        StatusBarsConfigScreen.setResizeCursor(true);
                        break block3;
                    }
                    this.resizeHover.first(null);
                    StatusBarsConfigScreen.setResizeCursor(false);
                }
            }
        }
    }

    private static int getNeighborInsertX(BarPositioner.BarLocation barLocation, boolean right) {
        BarPositioner.BarAnchor barAnchor = barLocation.barAnchor();
        int gridX = barLocation.x();
        if (barAnchor == null) {
            return 0;
        }
        if (right) {
            return barAnchor.isRight() ? gridX + 1 : gridX;
        }
        return barAnchor.isRight() ? gridX : gridX + 1;
    }

    private static int getNeighborInsertY(BarPositioner.BarLocation barLocation, boolean up) {
        BarPositioner.BarAnchor barAnchor = barLocation.barAnchor();
        int gridY = barLocation.y();
        if (barAnchor == null) {
            return 0;
        }
        if (up) {
            return barAnchor.isUp() ? gridY + 1 : gridY;
        }
        return barAnchor.isUp() ? gridY : gridY + 1;
    }

    protected void method_25426() {
        super.method_25426();
        FancyStatusBars.updatePositions(true);
        this.editBarWidget = new EditBarWidget(0, 0, this);
        this.editBarWidget.field_22764 = false;
        this.method_25429((class_364)this.editBarWidget);
        Collection<StatusBar> values = FancyStatusBars.statusBars.values();
        values.forEach(this::setup);
        this.updateScreenRects();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"?"), button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new class_8816.class_8817((class_437)this, (class_2561)class_2561.method_43471((String)"skyblocker.bars.config.explanationTitle")).method_54130((class_2561)class_2561.method_43471((String)"gui.ok"), class_8816::method_25419).method_54129((class_2561)class_2561.method_43471((String)"skyblocker.bars.config.explanation")).method_54125());
        }).method_46434(this.field_22789 - 20, (this.field_22790 - 15) / 2, 15, 15).method_46431());
    }

    private void setup(StatusBar statusBar) {
        this.method_37063(statusBar);
        statusBar.setOnClick(this::onBarClick);
    }

    public void method_25432() {
        super.method_25432();
        FancyStatusBars.statusBars.values().forEach(statusBar -> statusBar.setOnClick(null));
        if (this.cursorBar != null) {
            this.cursorBar.inMouse = false;
        }
        FancyStatusBars.updatePositions(false);
        assert (this.field_22787 != null);
        StatusBarsConfigScreen.setResizeCursor(false);
        FancyStatusBars.saveBarConfig();
    }

    public boolean method_25421() {
        return false;
    }

    private void onBarClick(StatusBar statusBar, class_11909 click) {
        if (click.method_74245() == 0) {
            this.cursorOffset = new class_8029((int)((double)statusBar.method_46426() - click.comp_4798()), (int)((double)statusBar.method_46427() - click.comp_4799()));
            this.cursorBar = statusBar;
            this.cursorBar.inMouse = true;
            this.cursorBar.enabled = true;
            this.currentInsertLocation = BarPositioner.BarLocation.of(this.cursorBar);
            if (statusBar.anchor != null) {
                FancyStatusBars.barPositioner.removeBar(statusBar.anchor, statusBar.gridY, statusBar);
            }
            FancyStatusBars.updatePositions(true);
            this.cursorBar.method_46421(this.field_22789 + 5);
            this.updateScreenRects();
        } else if (click.method_74245() == 1) {
            int x = (int)Math.min(click.comp_4798() - 1.0, (double)(this.field_22789 - this.editBarWidget.method_25368()));
            int y = (int)Math.min(click.comp_4799() - 1.0, (double)(this.field_22790 - this.editBarWidget.method_25364()));
            this.editBarWidget.field_22764 = true;
            this.editBarWidget.setStatusBar(statusBar);
            this.editBarWidget.method_46421(x);
            this.editBarWidget.method_46419(y);
        }
    }

    private void updateScreenRects() {
        this.rectToBar.clear();
        FancyStatusBars.statusBars.values().forEach(statusBar1 -> {
            if (!statusBar1.enabled) {
                return;
            }
            this.rectToBar.put(new class_8030(new class_8029(statusBar1.method_46426(), statusBar1.method_46427()), statusBar1.method_25368(), statusBar1.method_25364()), (Pair<StatusBar, BarPositioner.BarLocation>)Pair.of((Object)statusBar1, (Object)BarPositioner.BarLocation.of(statusBar1)));
        });
    }

    public boolean method_25406(class_11909 click) {
        if (this.cursorBar != null) {
            this.cursorBar.inMouse = false;
            if (this.currentInsertLocation == BarPositioner.BarLocation.NULL) {
                this.cursorBar.x = (float)((click.comp_4798() + (double)this.cursorOffset.comp_1193()) / (double)this.field_22789);
                this.cursorBar.y = (float)((click.comp_4799() + (double)this.cursorOffset.comp_1194()) / (double)this.field_22790);
                this.cursorBar.width = Math.clamp(this.cursorBar.width, 30.0f / (float)this.field_22789, 1.0f);
            }
            this.currentInsertLocation = BarPositioner.BarLocation.NULL;
            this.cursorBar = null;
            FancyStatusBars.updatePositions(true);
            this.updateScreenRects();
            return true;
        }
        if (this.resizing) {
            this.resizing = false;
            StatusBar bar = null;
            if (this.resizedBars.left() != null) {
                bar = (StatusBar)this.resizedBars.left();
            } else if (this.resizedBars.right() != null) {
                bar = (StatusBar)this.resizedBars.right();
            }
            if (bar != null && bar.anchor == null) {
                bar.x = (float)bar.method_46426() / (float)this.field_22789;
                bar.width = (float)bar.method_25368() / (float)this.field_22789;
            }
            this.resizedBars.left(null);
            this.resizedBars.right(null);
            this.updateScreenRects();
            return true;
        }
        return super.method_25406(click);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        StatusBar first = (StatusBar)this.resizeHover.first();
        if (!this.editBarWidget.method_25405(click.comp_4798(), click.comp_4799()) && click.method_74245() == 0 && first != null) {
            BarPositioner.BarAnchor barAnchor = first.anchor;
            if (barAnchor != null) {
                if (this.resizeHover.rightBoolean()) {
                    this.resizedBars.left((Object)first);
                    if (FancyStatusBars.barPositioner.hasNeighbor(barAnchor, first.gridY, first.gridX, true)) {
                        this.resizedBars.right((Object)FancyStatusBars.barPositioner.getBar(barAnchor, first.gridY, first.gridX + (barAnchor.isRight() ? 1 : -1)));
                    } else {
                        this.resizedBars.right(null);
                    }
                } else {
                    this.resizedBars.right((Object)first);
                    if (FancyStatusBars.barPositioner.hasNeighbor(barAnchor, first.gridY, first.gridX, false)) {
                        this.resizedBars.left((Object)FancyStatusBars.barPositioner.getBar(barAnchor, first.gridY, first.gridX + (barAnchor.isRight() ? -1 : 1)));
                    } else {
                        this.resizedBars.left(null);
                    }
                }
            } else if (this.resizeHover.rightBoolean()) {
                this.resizedBars.left((Object)first);
                this.resizedBars.right(null);
            } else {
                this.resizedBars.right((Object)first);
                this.resizedBars.left(null);
            }
            this.resizing = true;
            return true;
        }
        return super.method_25402(click, doubled);
    }
}

