/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.galatea;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsConfigurationScreen;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.ComponentBasedWidget;
import de.hysky.skyblocker.utils.Location;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;

@RegisterWidget
public class TreeBreakProgressHud
extends ComponentBasedWidget {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Set<Location> AVAILABLE_LOCATIONS = Set.of(Location.GALATEA);
    private static TreeBreakProgressHud instance;
    private static Int2ObjectMap<class_1531> armorstands;

    public TreeBreakProgressHud() {
        super(class_2561.method_43470((String)"Tree Break Progress").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}), class_124.field_1060.method_532(), "hud_treeprogress");
        instance = this;
        this.update();
    }

    public static void onEntityUpdate(class_1531 entity) {
        if (entity.method_5797() != null) {
            armorstands.put(entity.method_5628(), (Object)entity);
        }
    }

    @Override
    public boolean shouldUpdateBeforeRendering() {
        return true;
    }

    public static TreeBreakProgressHud getInstance() {
        return instance;
    }

    @Override
    public Set<Location> availableLocations() {
        return AVAILABLE_LOCATIONS;
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        if (!this.availableLocations().contains((Object)location)) {
            return;
        }
        SkyblockerConfigManager.get().foraging.galatea.enableTreeBreakProgress = enabled;
    }

    @Override
    public boolean isEnabledIn(Location location) {
        return this.availableLocations().contains((Object)location) && SkyblockerConfigManager.get().foraging.galatea.enableTreeBreakProgress;
    }

    @Override
    public boolean shouldRender(Location location) {
        return super.shouldRender(location) && this.isOwnTree(this.getClosestTree());
    }

    private class_1531 getClosestTree() {
        if (TreeBreakProgressHud.CLIENT.field_1724 == null) {
            return null;
        }
        return armorstands.values().stream().filter(entity -> {
            class_2561 name = entity.method_5797();
            if (name == null) {
                return false;
            }
            return name.getString().contains("FIG TREE") || name.getString().contains("MANGROVE TREE");
        }).min(Comparator.comparingDouble(e -> e.method_5858((class_1297)TreeBreakProgressHud.CLIENT.field_1724))).orElse(null);
    }

    private boolean isOwnTree(class_1531 tree) {
        if (TreeBreakProgressHud.CLIENT.field_1724 == null) {
            return false;
        }
        if (tree == null) {
            return false;
        }
        class_243 treePos = tree.method_73189();
        List<class_1531> groupedArmorStands = armorstands.values().stream().filter(e -> {
            class_243 pos = e.method_73189();
            return Math.abs(pos.field_1352 - treePos.field_1352) < 0.1 && Math.abs(pos.field_1351 - treePos.field_1351) < 2.0 && Math.abs(pos.field_1350 - treePos.field_1350) < 0.1;
        }).toList();
        String playerName = TreeBreakProgressHud.CLIENT.field_1724.method_5477().getString();
        return groupedArmorStands.stream().anyMatch(armorStand -> {
            String name = armorStand.method_5477().getString();
            return name.contains(playerName) || name.contains(" players");
        });
    }

    @Override
    public void updateContent() {
        class_638 world = TreeBreakProgressHud.CLIENT.field_1687;
        if (TreeBreakProgressHud.CLIENT.field_1755 instanceof WidgetsConfigurationScreen) {
            this.addSimpleIcoText(Ico.STRIPPED_SPRUCE_WOOD, "Fig Tree ", class_124.field_1060, "37%");
            return;
        }
        if (TreeBreakProgressHud.CLIENT.field_1724 == null || world == null) {
            return;
        }
        class_1531 closest = this.getClosestTree();
        if (closest == null || !this.isOwnTree(closest)) {
            return;
        }
        String closestName = closest.method_5477().getString();
        String treeName = closestName.contains("FIG") ? "Fig Tree" : "Mangrove Tree";
        class_1799 woodIcon = closestName.contains("FIG") ? Ico.STRIPPED_SPRUCE_WOOD : Ico.MANGROVE_LOG;
        this.addSimpleIcoText(woodIcon, treeName + " ", class_124.field_1060, closestName.replaceAll("[^0-9%]", ""));
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)"Tree Break Progress HUD");
    }

    static {
        armorstands = new Int2ObjectOpenHashMap();
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, clientWorld) -> armorstands.remove(entity.method_5628()));
    }
}

