/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.net.URI;
import java.util.Base64;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;

public class PlayerHeadHashCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> MANUAL_CACHES = Set.of("ewogICJ0aW1lc3RhbXAiIDogMTY5MjI5ODk2NTQ3MiwKICAicHJvZmlsZUlkIiA6ICJiNTAwOGEyMGJkY2U0YjJlOTU5NWZlNzY2MDlmYjUzNiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNT1JJU3hTVE9QQkFOIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2I5ZDdhM2I2ODQyMjRiYmZlY2Q3NDE0ZjM4MmI2NWI5MjdiYWI0ZGVkOWZmNGY2MzJiODAwNDc5MWRkYTY0OGIiCiAgICB9CiAgfQp9", "ewogICJ0aW1lc3RhbXAiIDogMTY5MjI5ODk1MjYwNCwKICAicHJvZmlsZUlkIiA6ICIxNmJhNWU4MDJhMmU0ZDJhYjEwZmZiYWJiYmQ1MDdlZSIsCiAgInByb2ZpbGVOYW1lIiA6ICJzbGlua3l1c2VyMzMxNSIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS9hMTgzOWVkZGU5ZWQ1ZjI5YWRlMGVlZjcxMmExOTRlN2VmMTI2ZjZmNDc3MWU1YWQzMDdhYjU0MGFiOGEzM2FhIgogICAgfQogIH0KfQ==", "ewogICJ0aW1lc3RhbXAiIDogMTY5MjI5OTAwMTI4NywKICAicHJvZmlsZUlkIiA6ICJiMjdjMjlkZWZiNWU0OTEyYjFlYmQ5NDVkMmI2NzE0YSIsCiAgInByb2ZpbGVOYW1lIiA6ICJIRUtUMCIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS9jZDFhNzA5MjgyM2IxNTk0YTcwMmNjODU3YjM5MGZlODk1MTE1YTg1OGRlNmQ3YWYzNDRhMGM4YmY4OTcxYjAiCiAgICB9CiAgfQp9", "ewogICJ0aW1lc3RhbXAiIDogMTY5MjI5ODk4NTY0MSwKICAicHJvZmlsZUlkIiA6ICI4MTYyODhjZGZkZTg0YTIyOGRhMTBlNTI0MzA3MzQwYyIsCiAgInByb2ZpbGVOYW1lIiA6ICJSeXVKYWNoYSIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS9kMzk1OGZjYmQ1MDkwN2ViY2VhYmQ2NjA2ZDhkOGJhMTVmN2RmZjU0MDY3N2Q1MTIxYjJmY2FjNWQ1NmM2OGQzIgogICAgfQogIH0KfQ==", "ewogICJ0aW1lc3RhbXAiIDogMTY5MjI5ODkzODg3OCwKICAicHJvZmlsZUlkIiA6ICJlMWFmMzI1NzM4MjU0MDE1YTYyZDZmZmFhY2U1YTIyNCIsCiAgInByb2ZpbGVOYW1lIiA6ICJfcHZwU21hc2hfIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2MxZjQwOTEzNzYyODlhOWQ0OGYwMDU3Y2Y3M2JjMjgxNjZmYTI4ODk4ZWFiOGRkOWUzOGZkZTRlMDJiNjcwNmEiCiAgICB9CiAgfQp9");
    private static final IntOpenHashSet CACHE = new IntOpenHashSet();

    protected static void loadSkins(JsonArray items) {
        try {
            Stream<String> apiItemTextures = items.asList().stream().map(JsonElement::getAsJsonObject).filter(item -> item.get("material").getAsString().equals("SKULL_ITEM")).filter(item -> item.has("skin")).map(item -> item.getAsJsonObject("skin").get("value").getAsString());
            Stream overrideTextures = MANUAL_CACHES.stream();
            Stream.concat(apiItemTextures, overrideTextures).map(PlayerHeadHashCache::getSkinHashFromBase64).filter(hash -> hash != null && !hash.isEmpty()).mapToInt(String::hashCode).forEach(arg_0 -> ((IntOpenHashSet)CACHE).add(arg_0));
            LOGGER.info("[Skyblocker Player Head Hash Cache] Successfully cached the hashes of all player head items!");
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Player Head Hash Cache] Failed to cache skin hashes!", (Throwable)e);
        }
    }

    public static String getSkinHashFromBase64(String base64) {
        try {
            String decoded = new String(Base64.getDecoder().decode(base64));
            JsonObject profile = JsonParser.parseString((String)decoded).getAsJsonObject();
            String url = profile.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
            return PlayerHeadHashCache.getSkinHashFromUrl(url);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Player Head Hash Cache] Error parsing head's base64 '{}'.", (Object)base64, (Object)e);
            return "";
        }
    }

    public static String getSkinHashFromUrl(String url) {
        if (url != null && url.equals("ETF pre test, skin check")) {
            return "";
        }
        try {
            return FilenameUtils.getBaseName((String)new URI(url).getPath());
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Player Head Hash Cache] Malformed Skin URL! URL: {}", (Object)url, (Object)e);
            return "";
        }
    }

    public static boolean contains(int hash) {
        return CACHE.contains(hash);
    }
}

