/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.background.adders;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.background.ColoredItemBackground;
import de.hysky.skyblocker.utils.ItemUtils;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_9848;

public class JacobMedalBackground
extends ColoredItemBackground<Integer> {
    private static final Pattern PATTERN = Pattern.compile("You placed in the (?<bracket>DIAMOND|PLATINUM|GOLD|SILVER|BRONZE) bracket!");
    private static final Map<String, Integer> BRACKET_COLORS = Map.of("DIAMOND", Objects.requireNonNull(class_124.field_1075.method_532()), "PLATINUM", Objects.requireNonNull(class_124.field_1062.method_532()), "GOLD", Objects.requireNonNull(class_124.field_1065.method_532()), "SILVER", Objects.requireNonNull(class_124.field_1068.method_532()), "BRONZE", Objects.requireNonNull(class_124.field_1061.method_532()));

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().general.itemInfoDisplay.jacobMedalBackgrounds;
    }

    @Override
    protected Integer getColorKey(class_1799 stack, Int2ReferenceOpenHashMap<Integer> cache) {
        Integer color;
        int hashCode;
        if (stack == null || stack.method_7960()) {
            return null;
        }
        int n = hashCode = stack.getUuid().isEmpty() ? System.identityHashCode(stack) : stack.getUuid().hashCode();
        if (cache.containsKey(hashCode)) {
            return (Integer)cache.get(hashCode);
        }
        Matcher matcher = ItemUtils.getLoreLineIfMatch(stack, PATTERN);
        if (matcher != null && (color = BRACKET_COLORS.get(matcher.group("bracket"))) != null) {
            cache.put(hashCode, (Object)color);
            return color;
        }
        cache.put(hashCode, null);
        return null;
    }

    @Override
    protected void draw(class_332 context, int x, int y, Integer color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        context.method_52710(class_10799.field_56883, this.getSprite(), x, y, 16, 16, class_9848.method_61318((float)SkyblockerConfigManager.get().general.itemInfoDisplay.itemBackgroundOpacity, (float)r, (float)g, (float)b));
    }
}

