/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom.screen;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.custom.screen.ColorSelectionWidget;
import de.hysky.skyblocker.skyblock.item.custom.screen.CustomizeScreen;
import de.hysky.skyblocker.skyblock.item.custom.screen.HeadSelectionWidget;
import de.hysky.skyblocker.skyblock.item.custom.screen.IdentifierTextField;
import de.hysky.skyblocker.skyblock.item.custom.screen.PlayerWidget;
import de.hysky.skyblocker.skyblock.item.custom.screen.TrimSelectionWidget;
import de.hysky.skyblocker.utils.ItemUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3489;
import net.minecraft.class_364;
import net.minecraft.class_6382;
import net.minecraft.class_742;
import net.minecraft.class_745;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8086;
import net.minecraft.class_8667;
import net.minecraft.class_9017;

public class ArmorTab
extends class_8086
implements Closeable {
    private static final class_2960 INNER_SPACE_TEXTURE = SkyblockerMod.id("menu_inner_space");
    private static final int PLAYER_WIDGET_WIDTH = 84;
    private static final int PADDING = 10;
    private static final class_1304[] ARMOR_SLOTS = (class_1304[])class_1304.field_54086.stream().filter(slot -> slot.method_5925() == class_1304.class_1305.field_6178).toArray(class_1304[]::new);
    private static final class_1799 BARRIER = new class_1799((class_1935)class_1802.field_8077);
    private final class_1799[] armor = new class_1799[4];
    private final CustomizeScreen parent;
    private int selectedSlot = 0;
    private final TrimSelectionWidget trimSelectionWidget;
    private final ColorSelectionWidget colorSelectionWidget;
    private final HeadSelectionWidget headSelectionWidget;
    private final ModelFieldContainer modelFieldContainer;
    private final boolean nothingCustomizable;
    private final class_745 player;

    public ArmorTab(CustomizeScreen parent) {
        super((class_2561)class_2561.method_43470((String)"Armor"));
        this.player = new class_745(this, CustomizeScreen.CLIENT.field_1687, CustomizeScreen.CLIENT.method_53462()){

            public boolean method_5756(class_1657 player) {
                return true;
            }

            public void method_6116(class_1304 slot, class_1799 oldStack, class_1799 newStack) {
            }
        };
        this.parent = parent;
        this.field_42139.method_48636(5).method_48635(10);
        List<class_1799> list = ItemUtils.getArmor((class_1309)CustomizeScreen.CLIENT.field_1724);
        for (int i = 0; i < list.size(); ++i) {
            class_1799 copy;
            this.armor[3 - i] = copy = list.get(i).method_7972();
            this.player.method_5673(ARMOR_SLOTS[i], copy);
        }
        while (this.selectedSlot < this.armor.length - 1 && !ArmorTab.canEdit(this.armor[this.selectedSlot])) {
            ++this.selectedSlot;
        }
        this.nothingCustomizable = !ArmorTab.canEdit(this.armor[this.selectedSlot]);
        class_8667 vertical = class_8667.method_52741().method_52735(1);
        PlayerWidget playerWidget = new PlayerWidget(0, 0, 84, 165, (class_742)this.player);
        vertical.method_52736((class_8021)playerWidget);
        PieceSelectionWidget pieceSelectionWidget = new PieceSelectionWidget(0, 0);
        vertical.method_52736((class_8021)pieceSelectionWidget);
        this.field_42139.method_52733((class_8021)vertical, 0, 0, 2, 1, class_7847::method_46474);
        int width = 200;
        this.headSelectionWidget = new HeadSelectionWidget(0, 0, width, 165);
        this.field_42139.method_52733((class_8021)this.headSelectionWidget, 0, 1, 2, 1, class_7847::method_46474);
        class_8667 layoutWidget = class_8667.method_52742().method_52735(5);
        int containerWidth = (int)((float)width * 0.33333334f);
        this.trimSelectionWidget = new TrimSelectionWidget(0, 0, width - containerWidth - 5, 80);
        this.modelFieldContainer = (ModelFieldContainer)layoutWidget.method_52736((class_8021)new ModelFieldContainer(containerWidth, 80));
        layoutWidget.method_52736((class_8021)this.trimSelectionWidget);
        layoutWidget.method_48222();
        this.field_42139.method_46452((class_8021)layoutWidget, 0, 1);
        class_327 textRenderer = class_310.method_1551().field_1772;
        this.colorSelectionWidget = new ColorSelectionWidget(0, 0, width, 100, textRenderer);
        this.field_42139.method_46452((class_8021)this.colorSelectionWidget, 1, 1);
        if (this.nothingCustomizable) {
            this.field_42139.method_52733((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"skyblocker.customization.nothingCustomizable"), textRenderer), 0, 1, 2, 1, p -> p.method_46474().method_46467());
        }
        this.updateWidgets();
    }

    private static boolean canEdit(class_1799 stack) {
        boolean hasUuid;
        boolean bl = hasUuid = !stack.getUuid().isEmpty();
        if (stack.method_31574(class_1802.field_8575)) {
            return hasUuid;
        }
        return stack.method_31573(class_3489.field_41890) && hasUuid;
    }

    private void updateWidgets() {
        if (this.nothingCustomizable) {
            this.headSelectionWidget.field_22764 = false;
            this.trimSelectionWidget.field_22764 = false;
            this.colorSelectionWidget.field_22764 = false;
            this.modelFieldContainer.field_22764 = false;
            return;
        }
        class_1799 item = this.armor[this.selectedSlot];
        this.parent.backupConfigs(item);
        boolean isPlayerHead = item.method_31574(class_1802.field_8575);
        this.headSelectionWidget.setCurrentItem(item);
        this.trimSelectionWidget.setCurrentItem(item);
        this.colorSelectionWidget.setCurrentItem(item);
        this.headSelectionWidget.field_22764 = isPlayerHead;
        this.trimSelectionWidget.field_22764 = !isPlayerHead;
        this.colorSelectionWidget.field_22764 = !isPlayerHead;
        this.modelFieldContainer.field_22764 = !isPlayerHead;
        String uuid = item.getUuid();
        if (SkyblockerConfigManager.get().general.customArmorModel.containsKey((Object)uuid)) {
            class_2960 identifier = (class_2960)SkyblockerConfigManager.get().general.customArmorModel.get((Object)uuid);
            String string = identifier.toString();
            this.modelFieldContainer.field.method_1852(string);
        } else {
            this.modelFieldContainer.field.method_1852("");
        }
    }

    void tick() {
        ++this.player.field_6012;
    }

    public void method_48611(class_8030 tabArea) {
        int width = Math.min(460, tabArea.comp_1196()) - 84 - 30;
        this.headSelectionWidget.method_25358(width);
        int modelFieldWidth = (int)((float)width * 0.33333334f);
        this.trimSelectionWidget.method_25358(width - modelFieldWidth - 5);
        this.modelFieldContainer.method_25358(modelFieldWidth);
        this.colorSelectionWidget.method_25358(width);
        super.method_48611(tabArea);
    }

    public void recreate() {
        if (this.colorSelectionWidget != null) {
            this.colorSelectionWidget.getTimelineWidget().recreateImage();
        }
    }

    @Override
    public void close() {
        this.colorSelectionWidget.close();
    }

    private class PieceSelectionWidget
    extends class_339 {
        private static final class_2960 HOTBAR_TEXTURE = SkyblockerMod.id("armor_customization_screen/mini_hotbar");
        private static final class_2960 HOTBAR_SELECTION_TEXTURE = SkyblockerMod.id("hotbar_selection_full");
        private final boolean[] selectable;

        private PieceSelectionWidget(int x, int y) {
            super(x, y, 84, 24, class_2561.method_30163((String)""));
            this.selectable = new boolean[ArmorTab.this.armor.length];
            for (int i = 0; i < ArmorTab.this.armor.length; ++i) {
                this.selectable[i] = ArmorTab.canEdit(ArmorTab.this.armor[i]);
            }
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            int i;
            context.method_52706(class_10799.field_56883, HOTBAR_TEXTURE, this.method_46426() + 1, this.method_46427() + 1, 82, 22);
            int hoveredSlot = -1;
            int localX = mouseX - this.method_46426() - 2;
            int localY = mouseY - this.method_46427() - 2;
            if (localY >= 0 && localY < 20) {
                int n = hoveredSlot = localX / 20 >= ArmorTab.this.armor.length ? -1 : localX / 20;
            }
            if (hoveredSlot >= 0 && this.selectable[hoveredSlot]) {
                i = this.method_46426() + 2 + hoveredSlot * 20;
                context.method_25294(i, this.method_46427() + 2, i + 20, this.method_46427() + 22, 0x20FFFFFF);
            }
            for (i = 0; i < ArmorTab.this.armor.length; ++i) {
                context.method_51427(ArmorTab.this.armor[i], this.method_46426() + 4 + i * 20, this.method_46427() + 4);
                if (this.selectable[i] || ArmorTab.this.armor[i].method_7960()) continue;
                context.method_51427(BARRIER, this.method_46426() + 4 + i * 20, this.method_46427() + 4);
            }
            context.method_52706(class_10799.field_56883, HOTBAR_SELECTION_TEXTURE, this.method_46426() + ArmorTab.this.selectedSlot * 20, this.method_46427(), 24, 24);
            if (this.method_49606()) {
                context.method_74037(this.method_37303() ? class_11876.field_62455 : class_11876.field_62459);
            }
        }

        public void method_25348(class_11909 click, boolean doubled) {
            double localX = click.comp_4798() - (double)this.method_46426() - 2.0;
            double localY = click.comp_4799() - (double)this.method_46427() - 2.0;
            if (localY < 0.0 || localY >= 20.0) {
                return;
            }
            int i = (int)(localX / 20.0);
            if (i < 0 || i >= ArmorTab.this.armor.length || !this.selectable[i]) {
                return;
            }
            if (i != ArmorTab.this.selectedSlot) {
                ArmorTab.this.selectedSlot = i;
                ArmorTab.this.updateWidgets();
            }
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return this.field_22763 && this.field_22764 && mouseX >= (double)(this.method_46426() + 2) && mouseY >= (double)(this.method_46427() + 2) && mouseX < (double)(this.method_55442() - 2) && mouseY < (double)(this.method_55443() - 2);
        }

        protected void method_47399(class_6382 builder) {
        }
    }

    private class ModelFieldContainer
    extends class_9017 {
        private final class_2561 TEXT;
        private final class_7843 containerLayout;
        private final IdentifierTextField field;

        private ModelFieldContainer(int width, int height) {
            super(0, 0, width, height, (class_2561)class_2561.method_43473());
            this.TEXT = class_2561.method_43471((String)"skyblocker.customization.armor.modelOverride").method_27692(class_124.field_1056).method_27692(class_124.field_1080);
            this.containerLayout = new class_7843();
            this.field = (IdentifierTextField)this.containerLayout.method_46441((class_8021)new IdentifierTextField(width - 10, 20, identifier -> {
                String uuid = ArmorTab.this.armor[ArmorTab.this.selectedSlot].getUuid();
                if (uuid.isEmpty()) {
                    return;
                }
                if (identifier == null) {
                    SkyblockerConfigManager.get().general.customArmorModel.remove((Object)uuid);
                } else {
                    SkyblockerConfigManager.get().general.customArmorModel.put((Object)uuid, identifier);
                }
                ArmorTab.this.colorSelectionWidget.refresh();
            }));
            this.containerLayout.method_48222();
            this.field.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.customization.armor.modelOverride.tooltip")));
            this.field.method_47402(Duration.ofMillis(400L));
        }

        public void method_46421(int x) {
            super.method_46421(x);
            class_7843.method_46440((int)this.method_46426(), (int)this.method_25368(), (int)this.containerLayout.method_25368(), arg_0 -> ((class_7843)this.containerLayout).method_46421(arg_0), (float)0.5f);
        }

        public void method_25358(int width) {
            super.method_25358(width);
            this.containerLayout.method_46449(width);
            this.containerLayout.method_48222();
            this.field.method_25358(width - 10);
            this.method_46421(this.method_46426());
        }

        public void method_46419(int y) {
            super.method_46419(y);
            class_7843.method_46440((int)this.method_46427(), (int)this.method_25364(), (int)this.containerLayout.method_25364(), arg_0 -> ((class_7843)this.containerLayout).method_46419(arg_0), (float)0.5f);
        }

        public List<? extends class_364> method_25396() {
            return this.field_22764 ? List.of(this.field) : List.of();
        }

        protected int method_44395() {
            return 0;
        }

        protected double method_44393() {
            return 0.0;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            if (!this.field_22764) {
                return;
            }
            context.method_52706(class_10799.field_56883, INNER_SPACE_TEXTURE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            int padding = 5;
            int startY = this.method_46427() + padding;
            ModelFieldContainer.method_52718((class_332)context, (class_327)CustomizeScreen.CLIENT.field_1772, (class_2561)this.TEXT, (int)(this.method_46426() + padding), (int)startY, (int)(this.method_55442() - padding), (int)(startY + 9), (int)-1);
            this.field.method_25394(context, mouseX, mouseY, deltaTicks);
        }

        protected void method_47399(class_6382 builder) {
        }
    }
}

