/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.slottext;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.WardrobeKeybinds;
import de.hysky.skyblocker.skyblock.bazaar.BazaarHelper;
import de.hysky.skyblocker.skyblock.chocolatefactory.ChocolateFactorySolver;
import de.hysky.skyblocker.skyblock.dungeon.terminal.SameColorTerminal;
import de.hysky.skyblocker.skyblock.galatea.TunerSolver;
import de.hysky.skyblocker.skyblock.hunting.AttributeLevelHelper;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.skyblock.item.slottext.SlotTextMode;
import de.hysky.skyblocker.skyblock.item.slottext.adders.BestiaryLevelAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.CatacombsLevelAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.ChoosePetLevelAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.CollectionAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.CommunityShopAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.EnchantmentLevelAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.EssenceShopAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.EvolvingItemAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.HotfPerkLevelAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.HotmPerkLevelAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.MinionLevelAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.NewYearCakeAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.PetLevelAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.PotionLevelAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.PowerStonesGuideAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.PrehistoricEggAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.RancherBootsSpeedAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.SkillLevelAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.SkyblockGuideAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.SkyblockLevelAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.StatsTuningAdder;
import de.hysky.skyblocker.skyblock.item.slottext.adders.YourEssenceAdder;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerScreen;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_304;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class SlotTextManager {
    private static final SlotTextAdder[] adders = new SlotTextAdder[]{new EssenceShopAdder(), new EnchantmentLevelAdder(), new MinionLevelAdder(), new PetLevelAdder(), new ChoosePetLevelAdder(), new SkyblockLevelAdder(), new HotmPerkLevelAdder(), new HotfPerkLevelAdder(), new SkillLevelAdder(), new CatacombsLevelAdder.Dungeoneering(), new CatacombsLevelAdder.DungeonClasses(), new CatacombsLevelAdder.ReadyUp(), new RancherBootsSpeedAdder(), new PrehistoricEggAdder(), new PotionLevelAdder(), new CollectionAdder(), new CommunityShopAdder(), new YourEssenceAdder(), new PowerStonesGuideAdder(), new BazaarHelper(), new StatsTuningAdder(), TunerSolver.INSTANCE, ChocolateFactorySolver.INSTANCE, new EvolvingItemAdder(), new NewYearCakeAdder(), WardrobeKeybinds.INSTANCE, new SkyblockGuideAdder(), SameColorTerminal.INSTANCE, AttributeLevelHelper.INSTANCE, new BestiaryLevelAdder()};
    private static final ArrayList<SlotTextAdder> currentScreenAdders = new ArrayList();
    private static final class_304 keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.skyblocker.slottext", 342, SkyblockerMod.KEYBINDING_CATEGORY));
    private static boolean keyHeld = false;

    private SlotTextManager() {
    }

    @Init
    public static void init() {
        ScreenEvents.AFTER_INIT.register((client, screen, width, height) -> {
            if (screen instanceof class_465 && Utils.isOnSkyblock() || screen instanceof ProfileViewerScreen) {
                SlotTextManager.onScreenChange(screen);
                ScreenEvents.remove((class_437)screen).register(ignored -> currentScreenAdders.clear());
            }
            ScreenKeyboardEvents.afterKeyPress((class_437)screen).register((screen1, input) -> {
                if (keyBinding.method_1417(input)) {
                    SkyblockerConfigManager.get().uiAndVisuals.slotText.slotTextToggled = !SkyblockerConfigManager.get().uiAndVisuals.slotText.slotTextToggled;
                    keyHeld = true;
                }
            });
            ScreenKeyboardEvents.afterKeyRelease((class_437)screen).register((screen1, input) -> {
                if (keyBinding.method_1417(input)) {
                    keyHeld = false;
                }
            });
        });
    }

    private static void onScreenChange(class_437 screen) {
        for (SlotTextAdder adder : adders) {
            if (!adder.isEnabled() || !adder.test(screen)) continue;
            currentScreenAdders.add(adder);
        }
    }

    @NotNull
    public static List<SlotText> getText(@Nullable class_1735 slot, @NotNull class_1799 stack, int slotId) {
        ObjectArrayList text = new ObjectArrayList();
        if (currentScreenAdders.isEmpty() || !SlotTextManager.isEnabled()) {
            return text;
        }
        for (SlotTextAdder adder : currentScreenAdders) {
            text.addAll(adder.getText(slot, stack, slotId));
        }
        return text;
    }

    public static void renderSlotText(class_332 context, class_327 textRenderer, @NotNull class_1735 slot) {
        SlotTextManager.renderSlotText(context, textRenderer, slot, slot.method_7677(), slot.field_7874, slot.field_7873, slot.field_7872);
    }

    public static void renderSlotText(class_332 context, class_327 textRenderer, @Nullable class_1735 slot, class_1799 stack, int slotId, int x, int y) {
        List<SlotText> textList = SlotTextManager.getText(slot, stack, slotId);
        if (textList.isEmpty()) {
            return;
        }
        Matrix3x2fStack matrices = context.method_51448();
        for (SlotText slotText : textList) {
            matrices.pushMatrix();
            int length = textRenderer.method_27525((class_5348)slotText.text());
            if (length > 16) {
                float scale = 16.0f / (float)length;
                matrices.scale(scale, scale);
                switch (slotText.position()) {
                    case TOP_LEFT: 
                    case TOP_RIGHT: {
                        matrices.translate((float)x / scale - (float)x, (float)y / scale - (float)y);
                        break;
                    }
                    case BOTTOM_LEFT: 
                    case BOTTOM_RIGHT: {
                        float f = (float)x / scale - (float)x;
                        float f2 = ((float)y + 16.0f) / scale;
                        Objects.requireNonNull(textRenderer);
                        matrices.translate(f, f2 - 9.0f + 2.0f - (float)y);
                    }
                }
            } else {
                switch (slotText.position()) {
                    case TOP_LEFT: {
                        break;
                    }
                    case TOP_RIGHT: {
                        matrices.translate(16.0f - (float)length, 0.0f);
                        break;
                    }
                    case BOTTOM_LEFT: {
                        Objects.requireNonNull(textRenderer);
                        matrices.translate(0.0f, 16.0f - 9.0f + 2.0f);
                        break;
                    }
                    case BOTTOM_RIGHT: {
                        float f = 16.0f - (float)length;
                        Objects.requireNonNull(textRenderer);
                        matrices.translate(f, 16.0f - 9.0f + 2.0f);
                    }
                }
            }
            context.method_51439(textRenderer, slotText.text(), x, y, -1, true);
            matrices.popMatrix();
        }
    }

    public static Stream<SlotTextAdder> getAdderStream() {
        return Arrays.stream(adders);
    }

    public static boolean isEnabled(String adderId) {
        return SkyblockerConfigManager.get().uiAndVisuals.slotText.textEnabled.getOrDefault((Object)adderId, true);
    }

    public static boolean isEnabled() {
        return switch (SkyblockerConfigManager.get().uiAndVisuals.slotText.slotTextMode) {
            default -> throw new MatchException(null, null);
            case SlotTextMode.ENABLED -> true;
            case SlotTextMode.DISABLED -> false;
            case SlotTextMode.PRESS_TO_TOGGLE -> SkyblockerConfigManager.get().uiAndVisuals.slotText.slotTextToggled;
            case SlotTextMode.HOLD_TO_HIDE -> {
                if (!keyHeld) {
                    yield true;
                }
                yield false;
            }
            case SlotTextMode.HOLD_TO_SHOW -> keyHeld;
        };
    }
}

