/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.slottext.adders;

import de.hysky.skyblocker.skyblock.item.slottext.SimpleSlotTextAdder;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RomanNumerals;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_9322;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class EnchantmentLevelAdder
extends SimpleSlotTextAdder {
    private static final SlotTextAdder.ConfigInformation CONFIG_INFORMATION = new SlotTextAdder.ConfigInformation("enchantment_level", "skyblocker.config.uiAndVisuals.slotText.enchantmentLevel");
    @VisibleForTesting
    static final Object2ObjectMap<String, String> ENCHANTMENT_ABBREVIATIONS = new Object2ObjectOpenHashMap();
    @VisibleForTesting
    static final Map<String, String> ULTIMATE_ENCHANTMENT_ABBREVIATIONS = new Object2ObjectOpenHashMap();

    public EnchantmentLevelAdder() {
        super(CONFIG_INFORMATION);
    }

    @Override
    @NotNull
    public List<SlotText> getText(@Nullable class_1735 slot, @NotNull class_1799 stack, int slotId) {
        if (!stack.method_31574(class_1802.field_8598)) {
            return List.of();
        }
        String name = stack.method_7964().getString();
        if (name.equals("Enchanted Book")) {
            class_2487 nbt = ItemUtils.getCustomData((class_9322)stack);
            if (nbt.method_33133() || !nbt.method_10545("enchantments")) {
                return List.of();
            }
            class_2487 enchantments = nbt.method_68568("enchantments");
            if (enchantments.method_10546() != 1) {
                return List.of();
            }
            String enchantmentId = (String)enchantments.method_10541().iterator().next();
            int level = enchantments.method_68083(enchantmentId, 0);
            SlotText enchantmentLevel = SlotText.bottomLeft((class_2561)class_2561.method_43470((String)String.valueOf(level)).method_54663(16768449));
            return this.getAbbreviation(enchantmentId).map(text -> List.of(SlotText.topRight(text), enchantmentLevel)).orElseGet(() -> List.of(enchantmentLevel));
        }
        int level = EnchantmentLevelAdder.getEnchantLevelFromString(name);
        return level != 0 ? SlotText.bottomLeftList((class_2561)class_2561.method_43470((String)String.valueOf(level)).method_54663(16768449)) : List.of();
    }

    private Optional<class_2561> getAbbreviation(String enchantmentId) {
        if (ENCHANTMENT_ABBREVIATIONS.containsKey((Object)enchantmentId)) {
            return Optional.of(class_2561.method_43470((String)((String)ENCHANTMENT_ABBREVIATIONS.get((Object)enchantmentId))).method_54663(class_124.field_1078.method_532().intValue()));
        }
        if (ULTIMATE_ENCHANTMENT_ABBREVIATIONS.containsKey(enchantmentId)) {
            return Optional.of(class_2561.method_43470((String)ULTIMATE_ENCHANTMENT_ABBREVIATIONS.get(enchantmentId)).method_54663(class_124.field_1076.method_532().intValue()));
        }
        return Optional.empty();
    }

    private static int getEnchantLevelFromString(String str) {
        return RomanNumerals.romanToDecimal(str.substring(str.lastIndexOf(32) + 1));
    }

    static {
        ENCHANTMENT_ABBREVIATIONS.put((Object)"absorb", (Object)"AB");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"angler", (Object)"AN");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"aqua_affinity", (Object)"AA");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"arcane", (Object)"WS");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"aiming", (Object)"DT");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"bane_of_arthropods", (Object)"BA");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"big_brain", (Object)"BB");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"blast_protection", (Object)"BP");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"blessing", (Object)"BL");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"caster", (Object)"CA");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"cayenne", (Object)"CY");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"champion", (Object)"CH");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"chance", (Object)"CN");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"charm", (Object)"CM");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"cleave", (Object)"CL");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"compact", (Object)"CO");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"corruption", (Object)"CP");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"counter_strike", (Object)"CS");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"critical", (Object)"CR");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"cubism", (Object)"CU");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"cultivating", (Object)"CT");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"dedication", (Object)"DD");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"delicate", (Object)"DE");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"depth_strider", (Object)"DS");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"divine_gift", (Object)"DG");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"dragon_hunter", (Object)"GV");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"efficiency", (Object)"EF");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"ender_slayer", (Object)"ES");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"execute", (Object)"EX");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"experience", (Object)"XP");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"expertise", (Object)"EP");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"feather_falling", (Object)"FF");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"ferocious_mana", (Object)"FM");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"fire_aspect", (Object)"FA");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"fire_protection", (Object)"FI");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"first_strike", (Object)"FS");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"flame", (Object)"FL");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"forest_pledge", (Object)"FP");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"fortune", (Object)"FO");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"frail", (Object)"FR");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"frost_walker", (Object)"FW");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"giant_killer", (Object)"GK");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"great_spook", (Object)"GS");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"green_thumb", (Object)"GT");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"growth", (Object)"GR");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"hardened_mana", (Object)"HM");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"harvesting", (Object)"HV");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"hecatomb", (Object)"HE");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"ice_cold", (Object)"IC");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"impaling", (Object)"IM");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"infinite_quiver", (Object)"IQ");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"knockback", (Object)"KB");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"lapidary", (Object)"LP");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"lethality", (Object)"LE");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"life_steal", (Object)"LS");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"looting", (Object)"LO");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"luck", (Object)"LU");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"luck_of_the_sea", (Object)"LA");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"lure", (Object)"LR");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"magnet", (Object)"MG");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"mana_steal", (Object)"MS");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"mana_vampire", (Object)"MV");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"overload", (Object)"OV");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"paleontologist", (Object)"PA");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"pesterminator", (Object)"PS");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"piercing", (Object)"PI");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"piscary", (Object)"PC");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"power", (Object)"PW");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"pristine", (Object)"PM");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"projectile_protection", (Object)"PP");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"PROSECUTE", (Object)"PO");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"prosperity", (Object)"PE");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"protection", (Object)"PR");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"punch", (Object)"PU");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"quantum", (Object)"QU");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"quick_bite", (Object)"QB");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"rainbow", (Object)"RA");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"reflection", (Object)"RF");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"rejuvenate", (Object)"RJ");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"replenish", (Object)"RP");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"respiration", (Object)"RE");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"respite", (Object)"RS");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"scavenger", (Object)"SV");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"scuba", (Object)"SC");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"sharpness", (Object)"SH");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"silk_touch", (Object)"ST");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"small_brain", (Object)"SB");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"smarty_pants", (Object)"SP");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"smelting_touch", (Object)"SE");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"smite", (Object)"SI");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"smoldering", (Object)"SD");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"snipe", (Object)"SN");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"spiked_hook", (Object)"SK");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"stealth", (Object)"SL");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"strong_mana", (Object)"SM");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"sugar_rush", (Object)"SR");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"sunder", (Object)"SU");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"syphon", (Object)"DR");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"tabasco", (Object)"TA");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"thorns", (Object)"TN");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"thunderbolt", (Object)"TB");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"thunderlord", (Object)"TL");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"tidal", (Object)"TD");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"titan_killer", (Object)"TK");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"toxophilite", (Object)"TX");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"transylvanian", (Object)"TY");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"triple_strike", (Object)"TS");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"true_protection", (Object)"TP");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"turbo_cactus", (Object)"TI");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"turbo_cane", (Object)"TC");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"turbo_carrot", (Object)"TR");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"turbo_coco", (Object)"TO");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"turbo_melon", (Object)"TE");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"turbo_mushrooms", (Object)"TM");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"turbo_potato", (Object)"TT");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"turbo_pumpkin", (Object)"TU");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"turbo_warts", (Object)"TW");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"turbo_wheat", (Object)"TH");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"vampirism", (Object)"VP");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"venomous", (Object)"VE");
        ENCHANTMENT_ABBREVIATIONS.put((Object)"vicious", (Object)"VI");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_bank", "B");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_bobbin_time", "BT");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_chimera", "CH");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_combo", "CO");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_reiterate", "D");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_fatal_tempo", "FT");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_first_impression", "FI");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_flash", "F");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_flowstate", "FL");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_habanero_tactics", "HT");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_inferno", "I");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_last_stand", "LS");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_legion", "L");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_missile", "M");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_no_pain_no_gain", "NP");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_one_for_all", "O");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_refrigerate", "RF");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_rend", "R");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_soul_eater", "SE");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_swarm", "SW");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("the_one", "TO");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_jerry", "UJ");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_wise", "UW");
        ULTIMATE_ENCHANTMENT_ABBREVIATIONS.put("ultimate_wisdom", "W");
    }
}

