/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.injected.SkyblockerStack;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.ProfiledData;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_437;
import net.minecraft.class_476;

public class AccessoriesHelper {
    private static final Path FILE = SkyblockerMod.CONFIG_DIR.resolve("collected_accessories.json");
    private static final Pattern ACCESSORY_BAG_TITLE = Pattern.compile("Accessory Bag(?: \\((?<page>\\d+)\\/\\d+\\))?");
    private static final ProfiledData<ProfileAccessoryData> COLLECTED_ACCESSORIES = new ProfiledData<ProfileAccessoryData>(FILE, ProfileAccessoryData.CODEC, true);
    private static final Predicate<String> NON_EMPTY = s -> !s.isEmpty();
    private static final Predicate<Accessory> HAS_FAMILY = Accessory::hasFamily;
    private static final ToIntFunction<Accessory> ACCESSORY_TIER = Accessory::tier;
    private static Map<String, Accessory> ACCESSORY_DATA = new Object2ObjectOpenHashMap();

    @Init
    public static void init() {
        COLLECTED_ACCESSORIES.init();
        ScreenEvents.BEFORE_INIT.register((_client, screen, _scaledWidth, _scaledHeight) -> {
            class_476 genericContainerScreen;
            Matcher matcher;
            if (Utils.isOnSkyblock() && TooltipInfoType.ACCESSORIES.isTooltipEnabled() && !Utils.getProfileId().isEmpty() && screen instanceof class_476 && (matcher = ACCESSORY_BAG_TITLE.matcher((genericContainerScreen = (class_476)screen).method_25440().getString())).matches()) {
                ScreenEvents.afterTick((class_437)screen).register(_screen -> {
                    class_1707 handler = (class_1707)genericContainerScreen.method_17577();
                    int page = matcher.group("page") != null ? Integer.parseInt(matcher.group("page")) : 1;
                    AccessoriesHelper.collectAccessories(handler.field_7761.subList(0, handler.method_17388() * 9), page);
                });
            }
        });
    }

    private static void collectAccessories(List<class_1735> slots, int page) {
        if (!COLLECTED_ACCESSORIES.isLoaded()) {
            return;
        }
        List<String> accessoryIds = slots.stream().map(class_1735::method_7677).map(SkyblockerStack::getSkyblockId).filter(NON_EMPTY).toList();
        COLLECTED_ACCESSORIES.computeIfAbsent(ProfileAccessoryData::createDefault).pages().put(page, (Object)new ObjectOpenHashSet(accessoryIds));
    }

    public static Pair<AccessoryReport, String> calculateReport4Accessory(String accessoryId) {
        if (!ACCESSORY_DATA.containsKey(accessoryId) || Utils.getProfileId().isEmpty()) {
            return Pair.of((Object)((Object)AccessoryReport.INELIGIBLE), null);
        }
        Accessory accessory = ACCESSORY_DATA.get(accessoryId);
        if (accessory.origin().orElse("").equals("RIFT")) {
            return Pair.of((Object)((Object)AccessoryReport.INELIGIBLE), null);
        }
        Set collectedAccessories = COLLECTED_ACCESSORIES.computeIfAbsent(ProfileAccessoryData::createDefault).pages().values().stream().flatMap(Collection::stream).filter(ACCESSORY_DATA::containsKey).map(ACCESSORY_DATA::get).collect(Collectors.toSet());
        if (accessory.family().isEmpty()) {
            return collectedAccessories.contains(accessory) ? Pair.of((Object)((Object)AccessoryReport.HAS_HIGHEST_TIER), null) : Pair.of((Object)((Object)AccessoryReport.MISSING), (Object)"");
        }
        Predicate<Accessory> HAS_SAME_FAMILY = accessory::hasSameFamily;
        Set collectedAccessoriesInTheSameFamily = collectedAccessories.stream().filter(HAS_FAMILY).filter(HAS_SAME_FAMILY).collect(Collectors.toSet());
        Set accessoriesInTheSameFamily = ACCESSORY_DATA.values().stream().filter(HAS_FAMILY).filter(HAS_SAME_FAMILY).collect(Collectors.toSet());
        int highestTierInFamily = accessoriesInTheSameFamily.stream().mapToInt(ACCESSORY_TIER).max().orElse(0);
        if (collectedAccessoriesInTheSameFamily.isEmpty()) {
            return Pair.of((Object)((Object)AccessoryReport.MISSING), (Object)String.format("(%d/%d)", accessory.tier(), highestTierInFamily));
        }
        int highestTierCollectedInFamily = collectedAccessoriesInTheSameFamily.stream().mapToInt(ACCESSORY_TIER).max().getAsInt();
        if (accessory.tier() == highestTierInFamily && highestTierCollectedInFamily == highestTierInFamily) {
            return Pair.of((Object)((Object)AccessoryReport.HAS_HIGHEST_TIER), null);
        }
        if (accessory.tier() > highestTierCollectedInFamily) {
            return Pair.of((Object)((Object)AccessoryReport.IS_GREATER_TIER), (Object)String.format("(%d\u2192%d/%d)", highestTierCollectedInFamily, accessory.tier(), highestTierInFamily));
        }
        if (accessory.tier() < highestTierCollectedInFamily) {
            return Pair.of((Object)((Object)AccessoryReport.OWNS_BETTER_TIER), (Object)String.format("(%d\u2192%d/%d)", highestTierCollectedInFamily, accessory.tier(), highestTierInFamily));
        }
        if (accessory.tier() < highestTierInFamily) {
            return Pair.of((Object)((Object)AccessoryReport.HAS_GREATER_TIER), (Object)String.format("(%d/%d)", highestTierCollectedInFamily, highestTierInFamily));
        }
        return Pair.of((Object)((Object)AccessoryReport.MISSING), (Object)String.format("(%d/%d)", accessory.tier(), highestTierInFamily));
    }

    public static void refreshData(Map<String, Accessory> data) {
        ACCESSORY_DATA = data;
    }

    private record ProfileAccessoryData(Int2ObjectOpenHashMap<ObjectOpenHashSet<String>> pages) {
        private static final Codec<ProfileAccessoryData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.INT, (Codec)Codec.STRING.listOf().xmap(ObjectOpenHashSet::new, ObjectArrayList::new)).xmap(Int2ObjectOpenHashMap::new, Int2ObjectOpenHashMap::new).fieldOf("pages").forGetter(ProfileAccessoryData::pages)).apply((Applicative)instance, ProfileAccessoryData::new));

        private static ProfileAccessoryData createDefault() {
            return new ProfileAccessoryData((Int2ObjectOpenHashMap<ObjectOpenHashSet<String>>)new Int2ObjectOpenHashMap());
        }
    }

    public static enum AccessoryReport {
        HAS_HIGHEST_TIER,
        IS_GREATER_TIER,
        HAS_GREATER_TIER,
        OWNS_BETTER_TIER,
        MISSING,
        INELIGIBLE;

    }

    public record Accessory(String id, Optional<String> family, int tier, Optional<String> origin) {
        private static final Codec<Accessory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(Accessory::id), (App)Codec.STRING.optionalFieldOf("family").forGetter(Accessory::family), (App)Codec.INT.optionalFieldOf("tier", (Object)0).forGetter(Accessory::tier), (App)Codec.STRING.optionalFieldOf("origin").forGetter(Accessory::origin)).apply((Applicative)instance, Accessory::new));
        public static final Codec<Map<String, Accessory>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, CODEC);

        private boolean hasFamily() {
            return this.family.isPresent();
        }

        private boolean hasSameFamily(Accessory other) {
            return other.family().equals(this.family);
        }
    }
}

