/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.mixins.accessors.HandledScreenAccessor;
import de.hysky.skyblocker.skyblock.bazaar.BazaarOrderTracker;
import de.hysky.skyblocker.skyblock.bazaar.ReorderHelper;
import de.hysky.skyblocker.skyblock.chocolatefactory.ChocolateFactorySolver;
import de.hysky.skyblocker.skyblock.dungeon.CroesusProfit;
import de.hysky.skyblocker.skyblock.dwarven.fossil.FossilSolver;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.AccessoryTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.AvgBinTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.BazaarPriceTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.BitsHelper;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.ColorTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.CraftPriceTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.DateCalculatorTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.DungeonQualityTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.EssenceShopPrice;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.EstimatedItemValueTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.HuntingBoxPriceTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.LBinTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.LineSmoothener;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.MotesTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.MuseumTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.NpcPriceTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.ObtainedDateTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.StackingEnchantProgressTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.SupercraftReminder;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.TrueHexDisplay;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.TrueHexDyeScreenDisplay;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.container.ContainerMatcher;
import de.hysky.skyblocker.utils.container.TooltipAdder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;

public class TooltipManager {
    private static final TooltipAdder[] adders = new TooltipAdder[]{new LineSmoothener(), new TrueHexDisplay(), new TrueHexDyeScreenDisplay(), new SupercraftReminder(), ChocolateFactorySolver.INSTANCE, BitsHelper.INSTANCE, new FossilSolver(), new ReorderHelper(), BazaarOrderTracker.INSTANCE, new StackingEnchantProgressTooltip(0), new NpcPriceTooltip(1), new BazaarPriceTooltip(2), new LBinTooltip(3), new AvgBinTooltip(4), new EssenceShopPrice(5), new CraftPriceTooltip(6), new EstimatedItemValueTooltip(7), new DungeonQualityTooltip(8), new MotesTooltip(9), new ObtainedDateTooltip(10), new MuseumTooltip(11), new ColorTooltip(12), new AccessoryTooltip(13), new DateCalculatorTooltip(14), new HuntingBoxPriceTooltip(15), CroesusProfit.INSTANCE};
    private static List<TooltipAdder> currentScreenAdders = new ArrayList<TooltipAdder>();

    private TooltipManager() {
    }

    @Init
    public static void init() {
        ItemTooltipCallback.EVENT.register((stack, tooltipContext, tooltipType, lines) -> {
            class_437 patt0$temp = class_310.method_1551().field_1755;
            if (patt0$temp instanceof class_465) {
                class_465 handledScreen = (class_465)patt0$temp;
                TooltipManager.addToTooltip(((HandledScreenAccessor)handledScreen).getFocusedSlot(), stack, lines);
            } else {
                TooltipManager.addToTooltip(null, stack, lines);
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, width, height) -> {
            TooltipManager.onScreenChange(screen);
            ScreenEvents.remove((class_437)screen).register(ignored -> {
                currentScreenAdders = List.of();
            });
        });
    }

    private static void onScreenChange(class_437 screen) {
        currentScreenAdders = Arrays.stream(adders).filter(ContainerMatcher::isEnabled).filter(adder -> adder.test(screen)).sorted(Comparator.comparingInt(TooltipAdder::getPriority)).toList();
    }

    @Deprecated
    public static List<class_2561> addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        if (!Utils.isOnSkyblock()) {
            return lines;
        }
        for (TooltipAdder adder : currentScreenAdders) {
            adder.addToTooltip(focusedSlot, stack, lines);
        }
        return lines;
    }
}

