/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.wikilookup;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.util.Either;
import de.hysky.skyblocker.skyblock.item.wikilookup.WikiLookup;
import de.hysky.skyblocker.skyblock.item.wikilookup.WikiLookupManager;
import de.hysky.skyblocker.utils.ItemUtils;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_9322;
import org.apache.commons.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantmentBookItemLookup
implements WikiLookup {
    private static final Predicate<class_1799> ENCHANTMENT_BOOK_FILTER = itemStack -> {
        class_2487 nbt = ItemUtils.getCustomData((class_9322)itemStack);
        if (itemStack.method_31574(class_1802.field_8598) && nbt.method_10545("enchantments")) {
            class_2487 enchantments = nbt.method_68568("enchantments");
            return enchantments.method_10541().size() == 1;
        }
        return false;
    };
    public static final EnchantmentBookItemLookup INSTANCE = new EnchantmentBookItemLookup();

    private EnchantmentBookItemLookup() {
    }

    @Override
    public void open(@NotNull class_1799 itemStack, @NotNull class_1657 player, boolean useOfficial) {
        class_2487 nbt = ItemUtils.getCustomData((class_9322)itemStack);
        class_2487 enchantments = nbt.method_68568("enchantments");
        String firstEnchantment = ((String)Iterables.getFirst((Iterable)enchantments.method_10541(), null)).replace("ultimate_", "").replace("_", " ").trim();
        String enchantment = (String)REPLACING_FUNCTION.apply(WordUtils.capitalizeFully((String)(firstEnchantment + " enchantment")));
        WikiLookupManager.openWikiLinkName(enchantment, player, useOfficial);
    }

    @Override
    public boolean canSearch(@Nullable String title, @NotNull Either<class_1735, class_1799> either) {
        class_1799 itemStack = WikiLookupManager.mapEitherToItemStack(either);
        return ENCHANTMENT_BOOK_FILTER.test(itemStack);
    }
}

