/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.wikilookup;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.wikilookup.EnchantmentBookItemLookup;
import de.hysky.skyblocker.skyblock.item.wikilookup.EventCalendarLookup;
import de.hysky.skyblocker.skyblock.item.wikilookup.PetItemLookup;
import de.hysky.skyblocker.skyblock.item.wikilookup.RegularItemLookup;
import de.hysky.skyblocker.skyblock.item.wikilookup.VisitorLookup;
import de.hysky.skyblocker.skyblock.item.wikilookup.WikiLookup;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.Constants;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_11908;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class WikiLookupManager {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static class_304 officialWikiLookup;
    public static class_304 fandomWikiLookup;
    private static final WikiLookup[] LOOKUPS;

    @Init
    public static void init() {
        officialWikiLookup = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.wikiLookup.official", class_3675.class_307.field_1668, 293, SkyblockerMod.KEYBINDING_CATEGORY));
        fandomWikiLookup = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.wikiLookup.fandom", class_3675.class_307.field_1668, 290, SkyblockerMod.KEYBINDING_CATEGORY));
    }

    public static String getKeysText() {
        String fandom;
        String official = officialWikiLookup.method_1415() ? null : officialWikiLookup.method_16007().getString();
        String string = fandom = fandomWikiLookup.method_1415() ? null : fandomWikiLookup.method_16007().getString();
        if (official == null && fandom == null) {
            return "";
        }
        if (official == null) {
            return fandom.toUpperCase(Locale.ENGLISH);
        }
        if (fandom == null) {
            return official.toUpperCase(Locale.ENGLISH);
        }
        return (official + "/" + fandom).toUpperCase(Locale.ENGLISH);
    }

    public static boolean handleWikiLookup(@NotNull Either<class_1735, class_1799> either, class_1657 player, class_11908 input) {
        return WikiLookupManager.handleWikiLookup(null, either, player, input);
    }

    public static boolean handleWikiLookup(@Nullable String title, @NotNull Either<class_1735, class_1799> either, class_1657 player, class_11908 input) {
        boolean official;
        if (SkyblockerConfigManager.get().general.wikiLookup.enableWikiLookup && ((official = officialWikiLookup.method_1417(input)) || fandomWikiLookup.method_1417(input))) {
            WikiLookupManager.openWiki(title, either, player, official);
            return true;
        }
        return false;
    }

    public static void openWiki(@NotNull class_1799 itemStack, @NotNull class_1657 player, boolean useOfficial) {
        WikiLookupManager.openWiki(null, (Either<class_1735, class_1799>)Either.right((Object)itemStack), player, useOfficial);
    }

    public static void openWiki(@Nullable String title, @NotNull Either<class_1735, class_1799> either, @NotNull class_1657 player, boolean useOfficial) {
        for (WikiLookup lookup : LOOKUPS) {
            if (!lookup.canSearch(title, either)) continue;
            class_1799 itemStack = WikiLookupManager.mapEitherToItemStack(either);
            lookup.open(itemStack, player, useOfficial);
            break;
        }
    }

    public static void openWikiLinkName(String name, @NotNull class_1657 player, boolean useOfficial) {
        String wikiLink = ItemRepository.getWikiLink(useOfficial) + "/" + name;
        WikiLookupManager.openWikiLink(wikiLink, player);
    }

    public static void openWikiLink(String wikiLink, class_1657 player) {
        CompletableFuture.runAsync(() -> class_156.method_668().method_670(wikiLink)).exceptionally(e -> {
            LOGGER.error("[Skyblocker] Error while retrieving wiki article: {}", (Object)wikiLink, e);
            player.method_7353((class_2561)Constants.PREFIX.get().method_27693("Error while retrieving wiki article, see logs..."), false);
            return null;
        });
    }

    public static class_1799 mapEitherToItemStack(Either<class_1735, class_1799> either) {
        return either.right().orElseGet(() -> either.mapLeft(class_1735::method_7677).left().orElse(class_1799.field_8037));
    }

    static {
        LOOKUPS = new WikiLookup[]{VisitorLookup.INSTANCE, PetItemLookup.INSTANCE, EnchantmentBookItemLookup.INSTANCE, EventCalendarLookup.INSTANCE, RegularItemLookup.INSTANCE};
    }
}

