/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.itemlist.recipes;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockRecipe;
import de.hysky.skyblocker.utils.SkyblockTime;
import io.github.moulberry.repo.data.NEUForgeRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8029;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class SkyblockForgeRecipe
implements SkyblockRecipe {
    public static final class_2960 ID = SkyblockerMod.id("skyblock_forge");
    private final List<class_1799> inputs;
    private final class_1799 output;
    private final String durationString;

    public SkyblockForgeRecipe(NEUForgeRecipe forgeRecipe) {
        this.inputs = forgeRecipe.getInputs().stream().map(SkyblockRecipe::getItemStack).toList();
        this.output = SkyblockRecipe.getItemStack(forgeRecipe.getOutputStack());
        int duration = forgeRecipe.getDuration();
        this.durationString = SkyblockTime.formatTimeString(duration);
    }

    public class_1799 getResult() {
        return this.output;
    }

    @Override
    public List<SkyblockRecipe.RecipeSlot> getInputSlots(int width, int height) {
        ArrayList<SkyblockRecipe.RecipeSlot> out = new ArrayList<SkyblockRecipe.RecipeSlot>();
        int centerX = width / 2;
        int centerY = height / 2;
        Vector2i radius = this.getGridSize();
        int startX = (int)((float)centerX / 2.0f - (float)radius.x / 2.0f * 18.0f);
        int startY = (int)((float)centerY - (float)radius.y / 2.0f * 18.0f);
        for (int i = 0; i < this.inputs.size(); ++i) {
            int x = startX + i % radius.x * 18;
            int y = startY + i / radius.x * 18;
            out.add(new SkyblockRecipe.RecipeSlot(x, y, this.inputs.get(i)));
        }
        return out;
    }

    public Vector2i getGridSize() {
        int gridWidth;
        int gridHeight = gridWidth = (int)Math.sqrt(this.inputs.size());
        int sqrt = gridWidth++;
        float percentage = (float)(this.inputs.size() - sqrt * sqrt) / (float)((sqrt + 1) * (sqrt + 1) - sqrt * sqrt);
        if (percentage > 0.005f && (double)percentage > 0.6) {
            ++gridHeight;
        }
        return new Vector2i(gridWidth, gridHeight);
    }

    @Override
    public List<SkyblockRecipe.RecipeSlot> getOutputSlots(int width, int height) {
        return Collections.singletonList(new SkyblockRecipe.RecipeSlot(Math.max(3 * width / 4, width / 2 + 30), height / 2 - 9, this.output));
    }

    @Override
    public List<class_1799> getInputs() {
        return this.inputs;
    }

    @Override
    public List<class_1799> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public class_2561 getExtraText() {
        return class_2561.method_43473();
    }

    @Override
    public class_2960 getCategoryIdentifier() {
        return ID;
    }

    @Override
    public class_2960 getRecipeIdentifier() {
        return class_2960.method_60655((String)"skyblock", (String)(this.output.getSkyblockId().toLowerCase(Locale.ENGLISH).replace(';', '_') + "_" + this.output.method_7947()));
    }

    @Override
    @Nullable
    public class_8029 getArrowLocation(int width, int height) {
        return new class_8029(width / 2, height / 2 - 9);
    }

    public String getDurationString() {
        return this.durationString;
    }

    @Override
    public void render(class_332 context, int width, int height, double mouseX, double mouseY) {
        class_8029 arrowLocation = this.getArrowLocation(width, height);
        if (arrowLocation != null) {
            context.method_25300(class_310.method_1551().field_1772, this.durationString, arrowLocation.comp_1193() + 12, arrowLocation.comp_1194() - 10, -1);
        }
    }
}

