/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.itemlist.recipes;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockRecipe;
import io.github.moulberry.repo.data.NEUNpcShopRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8029;
import org.jetbrains.annotations.Nullable;

public class SkyblockNpcShopRecipe
implements SkyblockRecipe {
    public static final class_2960 ID = SkyblockerMod.id("skyblock_npc_shop");
    private static final int SLOT_SIZE = 18;
    private static final int ARROW_LENGTH = 24;
    private static final int ARROW_PADDING = 3;
    private final class_1799 npcShop;
    private final List<class_1799> inputs;
    private final class_1799 output;

    public SkyblockNpcShopRecipe(NEUNpcShopRecipe shopRecipe) {
        this.npcShop = ItemRepository.getItemStack(shopRecipe.getIsSoldBy().getSkyblockItemId());
        this.inputs = shopRecipe.getCost().stream().map(SkyblockRecipe::getItemStack).toList();
        this.output = SkyblockRecipe.getItemStack(shopRecipe.getResult());
    }

    private boolean shouldSplit() {
        return this.inputs.size() > 3;
    }

    private int getRowSize() {
        return this.shouldSplit() ? Math.floorDiv(this.inputs.size(), 2) : this.inputs.size();
    }

    private int getCenterX(int width) {
        int centerX = width / 2;
        int size = this.inputs.size();
        centerX += Math.min(this.getRowSize(), 3) * 18 / 2 - 9;
        if (size > 1 && size % 2 == 1) {
            centerX -= 9;
        }
        return centerX;
    }

    @Override
    public List<SkyblockRecipe.RecipeSlot> getInputSlots(int width, int height) {
        ArrayList<SkyblockRecipe.RecipeSlot> slots = new ArrayList<SkyblockRecipe.RecipeSlot>();
        slots.add(new SkyblockRecipe.RecipeSlot((width - 18) / 2, 9, this.npcShop));
        int centerX = this.getCenterX(width);
        int centerY = height / 2;
        boolean onSecondRow = false;
        int rowSize = this.getRowSize();
        int x = centerX - 18 * Math.min(rowSize, 3) - 12 - 3;
        int y = this.shouldSplit() ? centerY - 9 + 3 : centerY;
        for (int i = 0; i < this.inputs.size(); ++i) {
            slots.add(new SkyblockRecipe.RecipeSlot(x, y, this.inputs.get(i)));
            x += 18;
            if ((i + 1) % rowSize != 0 || onSecondRow) continue;
            onSecondRow = true;
            x -= rowSize * 18;
            y += 18;
        }
        return slots;
    }

    @Override
    public List<SkyblockRecipe.RecipeSlot> getOutputSlots(int width, int height) {
        int centerX = this.getCenterX(width);
        int centerY = height / 2;
        if (this.inputs.size() == 7 || this.inputs.size() == 8) {
            centerX += 18;
        }
        return List.of(new SkyblockRecipe.RecipeSlot(centerX + 12 + 3, centerY, this.output));
    }

    @Override
    @Nullable
    public class_8029 getArrowLocation(int width, int height) {
        int centerX = this.getCenterX(width);
        int centerY = height / 2;
        if (this.inputs.size() == 7 || this.inputs.size() == 8) {
            centerX += 18;
        }
        return new class_8029(centerX - 12 - 1, centerY);
    }

    public class_1799 getNpcItem() {
        return this.npcShop;
    }

    @Override
    public List<class_1799> getInputs() {
        return this.inputs;
    }

    @Override
    public List<class_1799> getOutputs() {
        return Collections.singletonList(this.output);
    }

    @Override
    public class_2561 getExtraText() {
        return class_2561.method_43473();
    }

    @Override
    public class_2960 getCategoryIdentifier() {
        return ID;
    }

    @Override
    public class_2960 getRecipeIdentifier() {
        return class_2960.method_60655((String)"skyblock", (String)(this.output.getSkyblockId().toLowerCase(Locale.ENGLISH).replace(';', '_') + "_" + this.output.method_7947()));
    }
}

