/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.museum;

import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.museum.Donation;
import de.hysky.skyblocker.skyblock.museum.MuseumItemCache;
import de.hysky.skyblocker.skyblock.museum.PriceData;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import it.unimi.dsi.fastutil.objects.ObjectObjectMutablePair;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public class MuseumUtils {
    private static final Set<String> EQUIPMENT_TYPES = Set.of("BELT", "GLOVES", "CLOAK", "GAUNTLET", "NECKLACE", "BRACELET", "HAT", "LOCKET", "VINE", "GRIPPERS");

    protected static double getSetCraftCost(String id) {
        double cost = 0.0;
        for (Donation donation : MuseumItemCache.MUSEUM_DONATIONS) {
            if (!donation.getId().equals(id)) continue;
            for (ObjectObjectMutablePair<String, PriceData> piece : donation.getSet()) {
                cost += ItemUtils.getCraftCost((String)piece.left());
            }
        }
        return cost;
    }

    protected static class_2561 getDisplayName(String id, boolean isSet) {
        if (isSet) {
            class_2583 nameStyle = class_2583.field_24360;
            String setName = MuseumItemCache.ARMOR_NAMES.get(id);
            if (setName != null) {
                for (Donation donation : MuseumItemCache.MUSEUM_DONATIONS) {
                    if (!donation.getId().equals(id) || donation.getSet().isEmpty()) continue;
                    class_2561 pieceName = MuseumUtils.getDisplayName((String)donation.getSet().getFirst().left(), false);
                    if (pieceName == null) break;
                    List siblings = pieceName.method_10855();
                    nameStyle = siblings.isEmpty() ? class_2583.field_24360 : ((class_2561)siblings.getFirst()).method_10866();
                    break;
                }
                return class_2561.method_43470((String)setName).method_10862(nameStyle);
            }
        } else {
            class_1799 stack = ItemRepository.getItemStack(id);
            if (stack != null) {
                return stack.method_7964();
            }
        }
        return class_2561.method_43470((String)id);
    }

    protected static String getSetID(String id) {
        for (Donation donation : MuseumItemCache.MUSEUM_DONATIONS) {
            for (ObjectObjectMutablePair<String, PriceData> set : donation.getSet()) {
                if (!((String)set.left()).equals(id)) continue;
                return donation.getId();
            }
        }
        return null;
    }

    protected static List<String> getPiecesBySetID(String donationId) {
        return MuseumItemCache.MUSEUM_DONATIONS.stream().filter(d -> d.getId().equals(donationId)).flatMap(d -> d.getSet().stream()).map(ObjectObjectMutablePair::left).collect(Collectors.toList());
    }

    public static String formatArmorName(String id, boolean isEquipment) {
        String lowercaseKey = id.toLowerCase(Locale.ENGLISH);
        String withSpaces = lowercaseKey.replace("_", " ");
        String[] words = withSpaces.split(" ");
        StringBuilder formattedName = new StringBuilder();
        for (String word : words) {
            formattedName.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        if (isEquipment) {
            formattedName.append("Equipment");
        } else if (!lowercaseKey.matches(".*(armor|outfit|suit|tuxedo).*")) {
            formattedName.append("Armor");
        }
        return formattedName.toString().trim();
    }

    public static boolean isEquipment(String skyblockApiId) {
        String upperId = skyblockApiId.toUpperCase(Locale.ENGLISH);
        return EQUIPMENT_TYPES.stream().anyMatch(upperId::contains);
    }

    public static String formatPrice(double value) {
        return Formatters.SHORT_FLOAT_NUMBERS.format(value).replace(".0", "");
    }
}

