/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.util.UndashedUuid;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerNavButton;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerPage;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerTextWidget;
import de.hysky.skyblocker.skyblock.profileviewer.collections.CollectionsPage;
import de.hysky.skyblocker.skyblock.profileviewer.dungeons.DungeonsPage;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.InventoryPage;
import de.hysky.skyblocker.skyblock.profileviewer.skills.SkillsPage;
import de.hysky.skyblocker.skyblock.profileviewer.slayers.SlayersPage;
import de.hysky.skyblocker.utils.ApiAuthentication;
import de.hysky.skyblocker.utils.ApiUtils;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.ProfileUtils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_10799;
import net.minecraft.class_11786;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_640;
import net.minecraft.class_745;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileViewerScreen
extends class_437 {
    public static final Logger LOGGER = LoggerFactory.getLogger(ProfileViewerScreen.class);
    private static final class_2561 TITLE = class_2561.method_30163((String)"Skyblocker Profile Viewer");
    private static final String HYPIXEL_COLLECTIONS = "https://api.hypixel.net/v2/resources/skyblock/collections";
    private static final class_2960 TEXTURE = SkyblockerMod.id("textures/gui/profile_viewer/base_plate.png");
    private static final int GUI_WIDTH = 322;
    private static final int GUI_HEIGHT = 180;
    private static Map<String, String[]> COLLECTIONS;
    private static Map<String, IntList> TIER_REQUIREMENTS;
    private String playerName;
    private JsonObject hypixelProfile;
    private JsonObject playerProfile;
    private boolean profileNotFound = false;
    private String errorMessage = "No Profile";
    private int activePage = 0;
    private static final String[] PAGE_NAMES;
    private final ProfileViewerPage[] profileViewerPages = new ProfileViewerPage[PAGE_NAMES.length];
    private final List<ProfileViewerNavButton> profileViewerNavButtons = new ArrayList<ProfileViewerNavButton>();
    private class_745 entity;
    private ProfileViewerTextWidget textWidget;

    public ProfileViewerScreen(String username) {
        super(TITLE);
        this.fetchPlayerData(username).thenRun(this::initialisePagesAndWidgets);
        for (int i = 0; i < PAGE_NAMES.length; ++i) {
            this.profileViewerNavButtons.add(new ProfileViewerNavButton(this, PAGE_NAMES[i], i, i == 0));
        }
    }

    private void initialisePagesAndWidgets() {
        if (this.profileNotFound) {
            return;
        }
        this.textWidget = new ProfileViewerTextWidget(this.hypixelProfile, this.playerProfile);
        CompletableFuture<Void> skillsFuture = CompletableFuture.runAsync(() -> {
            this.profileViewerPages[0] = new SkillsPage(this.hypixelProfile, this.playerProfile);
        });
        CompletableFuture<Void> slayersFuture = CompletableFuture.runAsync(() -> {
            this.profileViewerPages[1] = new SlayersPage(this.playerProfile);
        });
        CompletableFuture<Void> dungeonsFuture = CompletableFuture.runAsync(() -> {
            this.profileViewerPages[2] = new DungeonsPage(this.playerProfile);
        });
        CompletableFuture<Void> inventoriesFuture = CompletableFuture.runAsync(() -> {
            this.profileViewerPages[3] = new InventoryPage(this.playerProfile);
        });
        CompletableFuture<Void> collectionsFuture = CompletableFuture.runAsync(() -> {
            this.profileViewerPages[4] = new CollectionsPage(this.hypixelProfile, this.playerProfile);
        });
        CompletableFuture.allOf(skillsFuture, slayersFuture, dungeonsFuture, inventoriesFuture, collectionsFuture).thenRun(() -> {
            ProfileViewerScreen profileViewerScreen = this;
            synchronized (profileViewerScreen) {
                this.method_41843();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        ProfileViewerScreen profileViewerScreen = this;
        synchronized (profileViewerScreen) {
            super.method_25394(context, mouseX, mouseY, delta);
        }
        int rootX = this.field_22789 / 2 - 161;
        int rootY = this.field_22790 / 2 - 90 + 5;
        context.method_25290(class_10799.field_56883, TEXTURE, rootX, rootY, 0.0f, 0.0f, 322, 180, 322, 180);
        for (ProfileViewerNavButton button : this.profileViewerNavButtons) {
            button.method_46421(rootX + button.getIndex() * 28 + 4);
            button.method_46419(rootY - 28);
            button.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.textWidget != null) {
            this.textWidget.render(context, this.field_22793, rootX + 8, rootY + 120, mouseX, mouseY);
        }
        this.drawPlayerEntity(context, this.playerName != null ? this.playerName : "Loading...", rootX, rootY, mouseX, mouseY);
        if (this.profileViewerPages[this.activePage] != null) {
            this.profileViewerPages[this.activePage].markWidgetsAsVisible();
            this.profileViewerPages[this.activePage].render(context, mouseX, mouseY, delta, rootX + 93, rootY + 7);
        } else {
            context.method_25300(this.field_22793, this.profileNotFound ? this.errorMessage : "Loading...", rootX + 200, rootY + 80, Color.WHITE.getRGB());
        }
    }

    private void drawPlayerEntity(class_332 context, String username, int rootX, int rootY, int mouseX, int mouseY) {
        if (this.entity != null) {
            class_490.method_2486((class_332)context, (int)(rootX + 9), (int)(rootY + 16), (int)(rootX + 89), (int)(rootY + 124), (int)42, (float)0.0625f, (float)mouseX, (float)mouseY, (class_1309)this.entity);
        }
        context.method_25300(this.field_22793, username.length() > 15 ? username.substring(0, 15) : username, rootX + 47, rootY + 14, Color.WHITE.getRGB());
    }

    private CompletableFuture<Void> fetchPlayerData(String username) {
        CompletionStage profileFuture = ProfileUtils.fetchFullProfile(username).thenAccept(profiles -> {
            try {
                Optional<JsonObject> selectedProfile = profiles.getAsJsonArray("profiles").asList().stream().map(JsonElement::getAsJsonObject).filter(profile -> profile.getAsJsonPrimitive("selected").getAsBoolean()).findFirst();
                if (selectedProfile.isPresent()) {
                    this.hypixelProfile = selectedProfile.get();
                    this.playerProfile = this.hypixelProfile.getAsJsonObject("members").get(ApiUtils.name2Uuid(username)).getAsJsonObject();
                }
            }
            catch (Exception e) {
                this.errorMessage = ApiAuthentication.getToken() == null ? "Invalid Skyblocker token" : "Skyblock profile not found";
                this.profileNotFound = true;
                LOGGER.warn("[Skyblocker Profile Viewer] Error while looking for profile", (Throwable)e);
            }
        });
        CompletableFuture<Void> playerFuture = CompletableFuture.runAsync(() -> {
            String stringifiedUuid = ApiUtils.name2Uuid(username);
            if (stringifiedUuid.isEmpty()) {
                this.playerName = "User not found";
                this.errorMessage = "Player UUID not found";
                this.profileNotFound = true;
            }
            UUID uuid = UndashedUuid.fromStringLenient((String)stringifiedUuid);
            ((CompletableFuture)((CompletableFuture)class_310.method_1551().method_73362().method_74320(class_9296.method_73312((UUID)uuid)).thenAccept(entry -> {
                this.playerName = ((class_11786.class_11787)entry.get()).method_73502().name();
                this.entity = new class_745(this, class_310.method_1551().field_1687, ((class_11786.class_11787)entry.get()).method_73502(), (Optional)entry){
                    final /* synthetic */ Optional val$entry;
                    {
                        this.val$entry = optional;
                        super(arg0, arg1);
                    }

                    public class_8685 method_52814() {
                        class_640 playerListEntry = new class_640(((class_11786.class_11787)this.val$entry.get()).method_73502(), false);
                        return playerListEntry.method_52810();
                    }

                    public boolean method_74091(class_1664 modelPart) {
                        return !modelPart.equals((Object)class_1664.field_7559);
                    }

                    public boolean method_5756(class_1657 player) {
                        return true;
                    }
                };
                this.entity.method_5880(false);
            })).exceptionally(ex -> {
                this.playerName = "User not found";
                this.errorMessage = "Player skin not found";
                this.profileNotFound = true;
                return null;
            })).join();
        });
        return CompletableFuture.allOf(new CompletableFuture[]{profileFuture, playerFuture});
    }

    public void onNavButtonClick(ProfileViewerNavButton clickedButton) {
        if (this.profileViewerPages[this.activePage] != null) {
            this.profileViewerPages[this.activePage].markWidgetsAsInvisible();
        }
        for (ProfileViewerNavButton button : this.profileViewerNavButtons) {
            button.setToggled(false);
        }
        this.activePage = clickedButton.getIndex();
        clickedButton.setToggled(true);
    }

    public void method_25426() {
        this.profileViewerNavButtons.forEach(x$0 -> {
            ProfileViewerNavButton cfr_ignored_0 = (ProfileViewerNavButton)this.method_37063((class_364)x$0);
        });
        for (ProfileViewerPage profileViewerPage : this.profileViewerPages) {
            if (profileViewerPage == null || profileViewerPage.getButtons() == null) continue;
            for (class_339 button : profileViewerPage.getButtons()) {
                if (button == null) continue;
                this.method_37063((class_364)button);
            }
        }
    }

    @Init
    public static void initClass() {
        ProfileViewerScreen.fetchCollectionsData();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pv").then(ClientCommandManager.argument((String)"username", (ArgumentType)StringArgumentType.string()).suggests((source, builder) -> class_2172.method_9253((String[])ProfileViewerScreen.getPlayerSuggestions((FabricClientCommandSource)source.getSource()), (SuggestionsBuilder)builder)).executes(Scheduler.queueOpenScreenFactoryCommand(context -> new ProfileViewerScreen(StringArgumentType.getString((CommandContext)context, (String)"username")))))).executes(Scheduler.queueOpenScreenCommand(() -> new ProfileViewerScreen(class_310.method_1551().method_1548().method_1676())));
            dispatcher.register(literalArgumentBuilder);
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then((ArgumentBuilder)literalArgumentBuilder));
        });
    }

    private static void fetchCollectionsData() {
        CompletableFuture.runAsync(() -> {
            try {
                JsonObject jsonObject = JsonParser.parseString((String)Http.sendGetRequest(HYPIXEL_COLLECTIONS)).getAsJsonObject();
                if (jsonObject.get("success").getAsBoolean()) {
                    HashMap<String, String[]> collectionsMap = new HashMap<String, String[]>();
                    HashMap<String, IntList> tierRequirementsMap = new HashMap<String, IntList>();
                    JsonObject collections = jsonObject.getAsJsonObject("collections");
                    collections.entrySet().forEach(entry -> {
                        String category = (String)entry.getKey();
                        JsonObject itemsObject = ((JsonElement)entry.getValue()).getAsJsonObject().getAsJsonObject("items");
                        String[] items = itemsObject.keySet().toArray(new String[0]);
                        collectionsMap.put(category, items);
                        itemsObject.entrySet().forEach(itemEntry -> {
                            IntImmutableList tierReqs = IntImmutableList.toList((IntStream)((JsonElement)itemEntry.getValue()).getAsJsonObject().getAsJsonArray("tiers").asList().stream().mapToInt(tier -> tier.getAsJsonObject().get("amountRequired").getAsInt()));
                            tierRequirementsMap.put((String)itemEntry.getKey(), (IntList)tierReqs);
                        });
                    });
                    COLLECTIONS = collectionsMap;
                    TIER_REQUIREMENTS = tierRequirementsMap;
                }
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker Profile Viewer] Failed to fetch collections data", (Throwable)e);
            }
        });
    }

    public static Map<String, String[]> getCollections() {
        return COLLECTIONS;
    }

    public static Map<String, IntList> getTierRequirements() {
        return TIER_REQUIREMENTS;
    }

    private static String[] getPlayerSuggestions(FabricClientCommandSource source) {
        return (String[])source.method_9262().stream().filter(playerName -> playerName.matches("[A-Za-z0-9_]+")).toArray(String[]::new);
    }

    static {
        PAGE_NAMES = new String[]{"Skills", "Slayers", "Dungeons", "Inventories", "Collections"};
    }
}

