/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.dungeons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.hysky.skyblocker.SkyblockerMod;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class DungeonFloorRunsWidget {
    private static final class_327 textRenderer = class_310.method_1551().field_1772;
    private static final class_2960 TEXTURE = SkyblockerMod.id("textures/gui/profile_viewer/dungeons_body.png");
    private static final String[] DUNGEONS = new String[]{"catacombs", "master_catacombs"};
    private JsonObject dungeonsStats;

    public DungeonFloorRunsWidget(JsonObject pProfile) {
        try {
            this.dungeonsStats = pProfile.getAsJsonObject("dungeons").getAsJsonObject("dungeon_types");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void render(class_332 context, int mouseX, int mouseY, int x, int y) {
        context.method_25290(class_10799.field_56883, TEXTURE, x, y, 0.0f, 0.0f, 109, 110, 109, 110);
        context.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)"Floor Runs").method_27692(class_124.field_1067), x + 6, y + 4, Color.WHITE.getRGB(), true);
        int columnX = x + 4;
        int elementY = y + 15;
        for (String dungeon : DUNGEONS) {
            try {
                JsonObject dungeonData = this.dungeonsStats.getAsJsonObject(dungeon).getAsJsonObject("tier_completions");
                ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>(dungeonData.entrySet());
                entries.sort(Comparator.comparing(Map.Entry::getKey));
                for (Map.Entry entry : entries) {
                    if (((String)entry.getKey()).equals("total")) continue;
                    String textToRender = String.format((dungeon.equals("catacombs") ? "\u00a7aF" : "\u00a7cM") + "%s\u00a7r %s", entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    context.method_51433(textRenderer, textToRender, columnX + 2, elementY + 2, Color.WHITE.getRGB(), true);
                    if (!((String)entry.getKey()).equals("0") && mouseX >= columnX && mouseX <= columnX + 40 && mouseY >= elementY && mouseY <= elementY + 9) {
                        ArrayList<class_5250> tooltipText = new ArrayList<class_5250>();
                        tooltipText.add(class_2561.method_43470((String)"Personal Bests").method_27695(new class_124[]{class_124.field_1067, class_124.field_1076}));
                        JsonObject fastestTimes = this.dungeonsStats.getAsJsonObject(dungeon).getAsJsonObject("fastest_time_s");
                        if (fastestTimes != null && fastestTimes.has((String)entry.getKey())) {
                            tooltipText.add(class_2561.method_43470((String)("S Run:  " + this.formatTime(fastestTimes.get((String)entry.getKey()).getAsLong()))).method_27692(class_124.field_1065));
                        }
                        if ((fastestTimes = this.dungeonsStats.getAsJsonObject(dungeon).getAsJsonObject("fastest_time_s_plus")) != null && fastestTimes.has((String)entry.getKey())) {
                            tooltipText.add(class_2561.method_43470((String)("S+ Run: " + this.formatTime(fastestTimes.get((String)entry.getKey()).getAsLong()))).method_27692(class_124.field_1065));
                        }
                        if ((fastestTimes = this.dungeonsStats.getAsJsonObject(dungeon).getAsJsonObject("fastest_time")) != null && fastestTimes.has((String)entry.getKey()) && tooltipText.size() == 1) {
                            tooltipText.add(class_2561.method_43470((String)("Completion:  " + this.formatTime(fastestTimes.get((String)entry.getKey()).getAsLong()))).method_27692(class_124.field_1065));
                        }
                        context.method_51434(textRenderer, tooltipText, mouseX, mouseY);
                    }
                    elementY += 11;
                }
                columnX += 52;
                elementY = y + 26;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private String formatTime(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        return String.format("%2d:%02d", minutes, seconds %= 60L);
    }
}

