/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.inventory;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.item.ItemProtection;
import de.hysky.skyblocker.skyblock.item.background.ItemBackgroundManager;
import de.hysky.skyblocker.skyblock.item.slottext.SlotTextManager;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerPage;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.PaginationButton;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.ItemLoader;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;

public class Inventory
implements ProfileViewerPage {
    private static final class_2960 TEXTURE = class_2960.method_60654((String)"textures/gui/container/generic_54.png");
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_327 textRenderer = Inventory.CLIENT.field_1772;
    private final IntIntPair dimensions;
    private final int itemsPerPage;
    private final List<class_1799> containerList;
    private final String containerName;
    private int activePage = 0;
    private int totalPages = 1;
    private final PaginationButton previousPage = new PaginationButton(this, -1000, 0, false);
    private final PaginationButton nextPage = new PaginationButton(this, -1000, 0, true);

    public Inventory(String name, IntIntPair dimensions, JsonObject inventory) {
        this(name, dimensions, inventory, new ItemLoader());
    }

    public Inventory(String name, IntIntPair dimensions, JsonObject inventory, ItemLoader itemLoader) {
        this.containerName = name;
        this.dimensions = dimensions;
        this.itemsPerPage = dimensions.rightInt() * dimensions.leftInt();
        this.containerList = itemLoader.loadItems(inventory);
        this.totalPages = (int)Math.ceil((double)this.containerList.size() / (double)this.itemsPerPage);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta, int rootX, int rootY) {
        int rootYAdjusted = rootY + (26 - this.dimensions.leftInt() * 3);
        context.method_25290(class_10799.field_56883, TEXTURE, rootX, rootYAdjusted, 0.0f, 0.0f, this.dimensions.rightInt() * 18 + 7, this.dimensions.leftInt() * 18 + 17, 256, 256);
        context.method_25290(class_10799.field_56883, TEXTURE, rootX + this.dimensions.rightInt() * 18 + 7, rootYAdjusted, 169.0f, 0.0f, 7, this.dimensions.leftInt() * 18 + 17, 256, 256);
        context.method_25290(class_10799.field_56883, TEXTURE, rootX, rootYAdjusted + this.dimensions.leftInt() * 18 + 17, 0.0f, 215.0f, this.dimensions.rightInt() * 18 + 7, 7, 256, 256);
        context.method_25290(class_10799.field_56883, TEXTURE, rootX + this.dimensions.rightInt() * 18 + 7, rootYAdjusted + this.dimensions.leftInt() * 18 + 17, 169.0f, 215.0f, 7, 7, 256, 256);
        context.method_51433(textRenderer, class_1074.method_4662((String)("skyblocker.profileviewer.inventory." + this.containerName), (Object[])new Object[0]), rootX + 7, rootYAdjusted + 7, Color.DARK_GRAY.getRGB(), false);
        if (this.containerList.size() > this.itemsPerPage) {
            this.previousPage.method_46421(rootX + 44);
            this.previousPage.method_46419(rootY + 136);
            this.previousPage.method_25394(context, mouseX, mouseY, delta);
            context.method_25300(textRenderer, "Page: " + (this.activePage + 1) + "/" + this.totalPages, rootX + 88, rootY + 140, Color.WHITE.getRGB());
            this.nextPage.method_46421(rootX + 121);
            this.nextPage.method_46419(rootY + 136);
            this.nextPage.method_25394(context, mouseX, mouseY, delta);
        }
        int startIndex = this.activePage * this.itemsPerPage;
        int endIndex = Math.min(startIndex + this.itemsPerPage, this.containerList.size());
        List tooltip = Collections.emptyList();
        for (int i = 0; i < endIndex - startIndex; ++i) {
            class_1799 stack = this.containerList.get(startIndex + i);
            if (stack.method_7960()) continue;
            int column = i % this.dimensions.rightInt();
            int row = i / this.dimensions.rightInt();
            int x = rootX + 8 + column * 18;
            int y = rootYAdjusted + 18 + row * 18;
            ItemBackgroundManager.drawBackgrounds(stack, context, x, y);
            if (ItemProtection.isItemProtected(stack)) {
                context.method_25290(class_10799.field_56883, ItemProtection.ITEM_PROTECTION_TEX, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            context.method_51427(stack, x, y);
            context.method_51431(textRenderer, stack, x, y);
            SlotTextManager.renderSlotText(context, textRenderer, null, stack, i, x, y);
            if (mouseX <= x - 2 || mouseX >= x + 16 + 1 || mouseY <= y - 2 || mouseY >= y + 16 + 1) continue;
            tooltip = stack.method_7950(class_1792.class_9635.field_51353, (class_1657)Inventory.CLIENT.field_1724, (class_1836)(Inventory.CLIENT.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070));
        }
        if (!tooltip.isEmpty()) {
            context.method_51434(textRenderer, tooltip, mouseX, mouseY);
        }
    }

    @Override
    public void nextPage() {
        if (this.activePage < this.totalPages - 1) {
            ++this.activePage;
        }
    }

    @Override
    public void previousPage() {
        if (this.activePage > 0) {
            --this.activePage;
        }
    }

    @Override
    public void markWidgetsAsVisible() {
        this.nextPage.field_22764 = true;
        this.previousPage.field_22764 = true;
        this.nextPage.field_22763 = true;
        this.previousPage.field_22763 = true;
    }

    @Override
    public void markWidgetsAsInvisible() {
        this.nextPage.field_22764 = false;
        this.previousPage.field_22764 = false;
        this.nextPage.field_22763 = false;
        this.previousPage.field_22763 = false;
    }

    @Override
    public List<class_339> getButtons() {
        ArrayList<class_339> buttons = new ArrayList<class_339>();
        buttons.add(this.nextPage);
        buttons.add(this.previousPage);
        return buttons;
    }
}

