/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.inventory;

import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.skyblock.item.SkyblockItemRarity;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.profileviewer.utils.LevelFinder;
import de.hysky.skyblocker.skyblock.profileviewer.utils.ProfileViewerUtils;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.NEURepoManager;
import io.github.moulberry.repo.constants.PetNumbers;
import io.github.moulberry.repo.data.NEUItem;
import io.github.moulberry.repo.data.Rarity;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class Pet {
    private static final Pattern statsMatcher = Pattern.compile("\\{[A-Za-z_]+}");
    private static final Pattern numberMatcher = Pattern.compile("\\{\\d+}");
    private final String name;
    private final double xp;
    private final SkyblockItemRarity tier;
    private final Optional<String> heldItem;
    private final Optional<String> skin;
    private final Optional<class_9296> skinTexture;
    private final int level;
    private final double perecentageToLevel;
    private final long levelXP;
    private final long nextLevelXP;
    private final class_1799 icon;

    public Pet(PetInfo petData) {
        LevelFinder.LevelInfo info = LevelFinder.getLevelInfo((String)(petData.type().equals("GOLDEN_DRAGON") ? "PET_GREG" : "PET_" + String.valueOf((Object)petData.tier())), (long)petData.exp());
        this.name = petData.type();
        this.xp = petData.exp();
        this.heldItem = petData.item();
        this.skin = petData.skin();
        this.skinTexture = this.calculateSkinTexture();
        this.tier = petData.tier();
        this.level = info.level;
        this.perecentageToLevel = info.fill;
        this.levelXP = info.levelXP;
        this.nextLevelXP = info.nextLevelXP;
        this.icon = this.createIcon();
    }

    private String getName() {
        return this.name;
    }

    public long getXP() {
        return (long)this.xp;
    }

    public SkyblockItemRarity getRarity() {
        return this.tier;
    }

    public int getTier() {
        return this.tier.ordinal();
    }

    private Optional<class_9296> calculateSkinTexture() {
        if (this.skin.isPresent()) {
            class_1799 item = ItemRepository.getItemStack("PET_SKIN_" + this.skin.get());
            if (item == null || item.method_7960()) {
                return Optional.empty();
            }
            class_9296 profile = (class_9296)item.method_58694(class_9334.field_49617);
            return profile != null ? Optional.of(profile) : Optional.empty();
        }
        return Optional.empty();
    }

    public int getLevel() {
        return this.level;
    }

    public class_1799 getIcon() {
        return this.icon;
    }

    private class_1799 createIcon() {
        if (NEURepoManager.isLoading() || !ItemRepository.filesImported()) {
            return Ico.BARRIER;
        }
        String targetItemId = this.getName() + ";" + (this.getTier() + (this.heldItem.isPresent() && this.heldItem.get().equals("PET_ITEM_TIER_BOOST") ? 1 : 0));
        NEUItem item = NEURepoManager.getItemByNeuId(targetItemId);
        if (item == null && this.heldItem.isPresent() && this.heldItem.get().equals("PET_ITEM_TIER_BOOST")) {
            item = NEURepoManager.getItemByNeuId(this.getName() + ";" + this.getTier());
        }
        return item == null ? Ico.BARRIER : this.fromNEUItem(item, this.heldItem.map(ItemRepository::getItemStack).orElse(null));
    }

    private class_1799 fromNEUItem(NEUItem item, class_1799 heldItem) {
        if (item == null) {
            return this.getErrorStack();
        }
        class_1799 petStack = ItemRepository.getItemStack(item.getSkyblockItemId());
        if (petStack == null || petStack.method_7960()) {
            return this.getErrorStack();
        }
        petStack = petStack.method_7972();
        List<class_2561> formattedLore = !this.name.equals("GOLDEN_DRAGON") || this.level >= 101 ? this.processLore(item.getLore(), heldItem) : this.buildGoldenDragonEggLore(item.getLore());
        class_2583 style = class_2583.field_24360.method_10978(Boolean.valueOf(false));
        if (this.level != 100 && this.level != 200) {
            String progress = "Progress to Level " + this.level + ": \u00a7e" + this.fixDecimals(this.perecentageToLevel * 100.0, true) + "%";
            formattedLore.add(formattedLore.size() - 1, (class_2561)class_2561.method_43470((String)progress).method_10862(style).method_27692(class_124.field_1080));
            String string = "\u00a72\u00a7m ".repeat((int)Math.round(this.perecentageToLevel * 30.0)) + "\u00a7f\u00a7m ".repeat(30 - (int)Math.round(this.perecentageToLevel * 30.0));
            formattedLore.add(formattedLore.size() - 1, (class_2561)class_2561.method_43470((String)(string + "\u00a7r\u00a7e " + ProfileViewerUtils.numLetterFormat(this.levelXP) + "\u00a76/\u00a7e" + ProfileViewerUtils.numLetterFormat(this.nextLevelXP))).method_10862(style));
            formattedLore.add(formattedLore.size() - 1, (class_2561)class_2561.method_43473());
        } else {
            formattedLore.add(formattedLore.size() - 1, (class_2561)class_2561.method_43470((String)"MAX LEVEL").method_10862(style).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
            formattedLore.add(formattedLore.size() - 1, (class_2561)class_2561.method_43470((String)("\u25b8 " + Formatters.INTEGER_NUMBERS.format((long)this.xp) + " XP")).method_10862(style).method_27692(class_124.field_1063));
            formattedLore.add(formattedLore.size() - 1, (class_2561)class_2561.method_43473());
        }
        if (this.skinTexture.isPresent() && this.skin.isPresent()) {
            NEUItem skinItem = NEURepoManager.getItemByNeuId("PET_SKIN_" + this.skin.get());
            if (skinItem != null) {
                formattedLore.set(0, class_2561.method_30163((String)(formattedLore.getFirst().getString() + ", " + class_124.method_539((String)skinItem.getDisplayName()))));
            }
            petStack.method_57379(class_9334.field_49617, (Object)this.skinTexture.get());
        }
        if (this.boosted()) {
            formattedLore.set(formattedLore.size() - 1, (class_2561)class_2561.method_43470((String)this.getRarity().next().toString()).method_10862(style).method_27695(new class_124[]{class_124.field_1067, this.getRarity().next().formatting}));
        }
        petStack.method_57379(class_9334.field_49632, (Object)new class_9290(formattedLore));
        String displayName = class_124.method_539((String)item.getDisplayName()).replace("[Lvl {LVL}]", "\u00a77[Lvl " + this.level + "]\u00a7r");
        petStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)displayName).method_10862(style).method_27692((this.boosted() ? this.getRarity().next() : this.getRarity()).formatting));
        return petStack;
    }

    private List<class_2561> processLore(List<String> lore, class_1799 heldItem) {
        Map petNums = NEURepoManager.getConstants().getPetNumbers();
        Rarity rarity = Rarity.values()[this.getTier()];
        PetNumbers data = (PetNumbers)((Map)petNums.get(this.getName())).get(rarity);
        ArrayList<class_2561> formattedLore = new ArrayList<class_2561>();
        for (String line : lore) {
            String statValue;
            String placeholder;
            if (line.contains("Right-click to add this") || line.contains("pet menu!")) continue;
            String formattedLine = line;
            Matcher stats = statsMatcher.matcher(formattedLine);
            Matcher other = numberMatcher.matcher(formattedLine);
            while (stats.find()) {
                placeholder = stats.group();
                String statKey = placeholder.substring(1, placeholder.length() - 1);
                statValue = String.valueOf(this.fixDecimals((Double)data.interpolatedStatsAtLevel(this.level).getStatNumbers().get(statKey), true));
                formattedLine = formattedLine.replace(placeholder, statValue);
            }
            while (other.find()) {
                placeholder = other.group();
                int numberKey = Integer.parseInt(placeholder.substring(1, placeholder.length() - 1));
                statValue = String.valueOf(this.fixDecimals((Double)data.interpolatedStatsAtLevel(this.level).getOtherNumbers().get(numberKey), false));
                formattedLine = formattedLine.replace(placeholder, statValue);
            }
            formattedLore.add(class_2561.method_30163((String)formattedLine));
        }
        if (heldItem != null) {
            formattedLore.set(formattedLore.size() - 2, class_2561.method_30163((String)("\u00a7r\u00a76Held Item: " + heldItem.method_7964().getString())));
            formattedLore.add(formattedLore.size() - 1, (class_2561)class_2561.method_43473());
        }
        return formattedLore;
    }

    private List<class_2561> buildGoldenDragonEggLore(List<String> lore) {
        ArrayList<class_2561> formattedLore = new ArrayList<class_2561>();
        class_2583 style = class_2583.field_24360.method_10978(Boolean.valueOf(false));
        formattedLore.add(class_2561.method_30163((String)lore.getFirst()));
        formattedLore.add((class_2561)class_2561.method_43473());
        formattedLore.add((class_2561)class_2561.method_43470((String)"Perks:").method_10862(style).method_27692(class_124.field_1080));
        formattedLore.add((class_2561)class_2561.method_43470((String)"???").method_10862(style).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        formattedLore.add((class_2561)class_2561.method_43473());
        formattedLore.add((class_2561)class_2561.method_43470((String)"Hatches at level \u00a7b100").method_10862(style).method_27692(class_124.field_1080));
        formattedLore.add((class_2561)class_2561.method_43473());
        formattedLore.add(class_2561.method_30163((String)lore.getLast()));
        return formattedLore;
    }

    private String fixDecimals(double num, boolean truncate) {
        if (num % 1.0 == 0.0) {
            return String.valueOf((int)num);
        }
        BigDecimal roundedNum = new BigDecimal(num).setScale(truncate ? 1 : 3, RoundingMode.HALF_UP);
        return roundedNum.stripTrailingZeros().toPlainString();
    }

    private boolean boosted() {
        return this.heldItem.isPresent() && this.heldItem.get().equals("PET_ITEM_TIER_BOOST");
    }

    private class_1799 getErrorStack() {
        class_1799 errIcon = new class_1799((class_1935)class_1802.field_8077);
        errIcon.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)this.getName()));
        return errIcon;
    }
}

