/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.inventory;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.item.ItemProtection;
import de.hysky.skyblocker.skyblock.item.background.ItemBackgroundManager;
import de.hysky.skyblocker.skyblock.item.slottext.SlotTextManager;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerPage;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.InventoryItemLoader;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class PlayerInventory
implements ProfileViewerPage {
    private static final class_2960 TEXTURE = class_2960.method_60654((String)"textures/gui/container/generic_54.png");
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_327 textRenderer = PlayerInventory.CLIENT.field_1772;
    private final List<class_1799> containerList;
    private List<class_2561> tooltip = Collections.emptyList();

    public PlayerInventory(JsonObject inventory) {
        this.containerList = new InventoryItemLoader().loadItems(inventory);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta, int rootX, int rootY) {
        this.drawContainerTextures(context, "armor", rootX, rootY + 108, IntIntPair.of((int)1, (int)4));
        this.drawContainerTextures(context, "inventory", rootX, rootY + 2, IntIntPair.of((int)4, (int)9));
        this.drawContainerTextures(context, "equipment", rootX + 90, rootY + 108, IntIntPair.of((int)1, (int)4));
        this.tooltip.clear();
        this.drawContainerItems(context, rootX, rootY + 108, IntIntPair.of((int)1, (int)4), 36, 40, mouseX, mouseY);
        this.drawContainerItems(context, rootX, rootY + 2, IntIntPair.of((int)4, (int)9), 0, 36, mouseX, mouseY);
        this.drawContainerItems(context, rootX + 90, rootY + 108, IntIntPair.of((int)1, (int)4), 40, this.containerList.size(), mouseX, mouseY);
        if (!this.tooltip.isEmpty()) {
            context.method_51434(textRenderer, this.tooltip, mouseX, mouseY);
        }
    }

    private void drawContainerTextures(class_332 context, String containerName, int rootX, int rootY, IntIntPair dimensions) {
        if (containerName.equals("inventory")) {
            context.method_25290(class_10799.field_56883, TEXTURE, rootX, rootY + dimensions.leftInt() + 10, 0.0f, 136.0f, dimensions.rightInt() * 18 + 7, dimensions.leftInt() * 18 + 17, 256, 256);
            context.method_25290(class_10799.field_56883, TEXTURE, rootX + dimensions.rightInt() * 18 + 7, rootY, 169.0f, 0.0f, 7, dimensions.leftInt() * 18 + 21, 256, 256);
            context.method_25290(class_10799.field_56883, TEXTURE, rootX, rootY, 0.0f, 0.0f, dimensions.rightInt() * 18 + 7, 14, 256, 256);
            context.method_25290(class_10799.field_56883, TEXTURE, rootX + dimensions.rightInt() * 18 + 7, rootY + dimensions.leftInt() * 18 + 21, 169.0f, 215.0f, 7, 7, 256, 256);
        } else {
            context.method_25290(class_10799.field_56883, TEXTURE, rootX, rootY, 0.0f, 0.0f, dimensions.rightInt() * 18 + 7, dimensions.leftInt() * 18 + 17, 256, 256);
            context.method_25290(class_10799.field_56883, TEXTURE, rootX + dimensions.rightInt() * 18 + 7, rootY, 169.0f, 0.0f, 7, dimensions.leftInt() * 18 + 17, 256, 256);
            context.method_25290(class_10799.field_56883, TEXTURE, rootX, rootY + dimensions.leftInt() * 18 + 17, 0.0f, 215.0f, dimensions.rightInt() * 18 + 7, 7, 256, 256);
            context.method_25290(class_10799.field_56883, TEXTURE, rootX + dimensions.rightInt() * 18 + 7, rootY + dimensions.leftInt() * 18 + 17, 169.0f, 215.0f, 7, 7, 256, 256);
        }
        context.method_51433(textRenderer, class_1074.method_4662((String)("skyblocker.profileviewer.inventory." + containerName), (Object[])new Object[0]), rootX + 7, rootY + 7, Color.DARK_GRAY.getRGB(), false);
    }

    private void drawContainerItems(class_332 context, int rootX, int rootY, IntIntPair dimensions, int startIndex, int endIndex, int mouseX, int mouseY) {
        for (int i = 0; i < endIndex - startIndex; ++i) {
            class_1799 stack = this.containerList.get(startIndex + i);
            if (stack.method_7960()) continue;
            int column = i % dimensions.rightInt();
            int row = i / dimensions.rightInt();
            int x = rootX + 8 + column * 18;
            int y = rootY + 18 + row * 18 + (dimensions.leftInt() > 1 && row + 1 == dimensions.leftInt() ? 4 : 0);
            ItemBackgroundManager.drawBackgrounds(stack, context, x, y);
            if (ItemProtection.isItemProtected(stack)) {
                context.method_25290(class_10799.field_56883, ItemProtection.ITEM_PROTECTION_TEX, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            context.method_51427(stack, x, y);
            context.method_51431(textRenderer, stack, x, y);
            SlotTextManager.renderSlotText(context, textRenderer, null, stack, i, x, y);
            if (mouseX <= x - 2 || mouseX >= x + 16 + 1 || mouseY <= y - 2 || mouseY >= y + 16 + 1) continue;
            this.tooltip = stack.method_7950(class_1792.class_9635.field_51353, (class_1657)PlayerInventory.CLIENT.field_1724, (class_1836)(PlayerInventory.CLIENT.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070));
        }
    }
}

