/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerScreen;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.Pet;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.ItemLoader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1799;

public class PetsInventoryItemLoader
extends ItemLoader {
    @Override
    public List<class_1799> loadItems(JsonObject data) {
        ArrayList<Pet> petList = new ArrayList<Pet>();
        try {
            JsonObject petsData = data.getAsJsonObject("pets_data");
            if (petsData != null && petsData.has("pets")) {
                for (JsonElement petElement : petsData.get("pets").getAsJsonArray()) {
                    PetInfo petInfo = (PetInfo)PetInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)petElement.toString())).getOrThrow();
                    petList.add(new Pet(petInfo));
                }
            }
        }
        catch (Exception e) {
            ProfileViewerScreen.LOGGER.error("[Skyblocker Profile Viewer] Failed to load pets", (Throwable)e);
        }
        petList.sort(Comparator.comparingInt(Pet::getTier).thenComparingInt(Pet::getLevel).reversed());
        ArrayList<class_1799> itemList = new ArrayList<class_1799>();
        for (Pet pet : petList) {
            itemList.add(pet.getIcon());
        }
        return itemList;
    }
}

