/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.rift;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorverseWaypoints {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"skyblocker");
    private static final Supplier<Waypoint.Type> WAYPOINT_TYPE = () -> Waypoint.Type.HIGHLIGHT;
    private static final class_2960 WAYPOINTS_JSON = SkyblockerMod.id("rift/mirrorverse_waypoints.json");
    private static Waypoint[] LAVA_PATH_WAYPOINTS;
    private static Waypoint[] UPSIDE_DOWN_WAYPOINTS;
    private static Waypoint[] TURBULATOR_WAYPOINTS;
    private static final float[] COLOR_COMPONENTS;
    private static CompletableFuture<Void> waypointsLoaded;

    static void load(class_310 client) {
        waypointsLoaded = CompletableFuture.runAsync(() -> {
            try (BufferedReader reader = client.method_1478().openAsReader(WAYPOINTS_JSON);){
                JsonArray sections = JsonParser.parseReader((Reader)reader).getAsJsonObject().get("sections").getAsJsonArray();
                LAVA_PATH_WAYPOINTS = MirrorverseWaypoints.loadWaypoints(sections.get(0).getAsJsonObject().get("waypoints").getAsJsonArray());
                UPSIDE_DOWN_WAYPOINTS = MirrorverseWaypoints.loadWaypoints(sections.get(1).getAsJsonObject().get("waypoints").getAsJsonArray());
                TURBULATOR_WAYPOINTS = MirrorverseWaypoints.loadWaypoints(sections.get(2).getAsJsonObject().get("waypoints").getAsJsonArray());
            }
            catch (IOException e) {
                LOGGER.error("[Skyblocker] Mirrorverse Waypoints failed to load ;(", (Throwable)e);
            }
        });
    }

    private static Waypoint[] loadWaypoints(JsonArray waypointsJson) {
        Waypoint[] waypoints = new Waypoint[waypointsJson.size()];
        for (int i = 0; i < waypointsJson.size(); ++i) {
            JsonObject point = waypointsJson.get(i).getAsJsonObject();
            waypoints[i] = new Waypoint(new class_2338(point.get("x").getAsInt(), point.get("y").getAsInt(), point.get("z").getAsInt()), WAYPOINT_TYPE, COLOR_COMPONENTS, false);
        }
        return waypoints;
    }

    protected static void extractRendering(PrimitiveCollector collector) {
        if (Utils.isInTheRift() && SkyblockerConfigManager.get().otherLocations.rift.mirrorverseWaypoints && waypointsLoaded.isDone()) {
            for (Waypoint waypoint : LAVA_PATH_WAYPOINTS) {
                waypoint.extractRendering(collector);
            }
            for (Waypoint waypoint : UPSIDE_DOWN_WAYPOINTS) {
                waypoint.extractRendering(collector);
            }
            for (Waypoint waypoint : TURBULATOR_WAYPOINTS) {
                waypoint.extractRendering(collector);
            }
        }
    }

    static {
        COLOR_COMPONENTS = ColorUtils.getFloatComponents(class_1767.field_7964);
    }
}

