/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.searchoverlay;

import com.google.common.collect.Streams;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.museum.Donation;
import de.hysky.skyblocker.skyblock.museum.MuseumItemCache;
import de.hysky.skyblocker.skyblock.searchoverlay.OverlayScreen;
import de.hysky.skyblocker.utils.BazaarProduct;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import io.github.moulberry.repo.data.NEUItem;
import io.github.moulberry.repo.util.NEUId;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2877;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7157;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchOverManager {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Skyblocker Search Overlay");
    private static final String PET_NAME_START = "[Lvl {LVL}] ";
    @Nullable
    private static class_2625 sign = null;
    private static boolean signFront = true;
    private static boolean isCommand;
    protected static SearchLocation location;
    protected static String search;
    protected static Boolean maxPetLevel;
    protected static int dungeonStars;
    private static HashSet<String> bazaarItems;
    private static HashSet<String> auctionItems;
    private static HashSet<String> auctionPets;
    private static HashSet<String> starableItems;
    private static HashMap<String, String> namesToNeuId;
    public static String[] suggestionsArray;

    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register(SearchOverManager::registerSearchCommands);
        NEURepoManager.runAsyncAfterLoad(SearchOverManager::loadItems);
    }

    private static void registerSearchCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        if (SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.enableCommands) {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ahs").executes(context -> SearchOverManager.startCommand(true, "")));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bzs").executes(context -> SearchOverManager.startCommand(false, "")));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ahs").then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(context -> SearchOverManager.startCommand(true, StringArgumentType.getString((CommandContext)context, (String)"item")))));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"bzs").then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(context -> SearchOverManager.startCommand(false, StringArgumentType.getString((CommandContext)context, (String)"item")))));
        }
        if (!Debug.debugEnabled()) {
            return;
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then((ArgumentBuilder)ClientCommandManager.literal((String)"debug"))).then((ArgumentBuilder)ClientCommandManager.literal((String)"reloadSearchOverManager"))).executes(ctx -> {
            SearchOverManager.loadItems();
            return 1;
        }));
    }

    private static int startCommand(boolean isAuction, String itemName) {
        isCommand = true;
        location = isAuction ? SearchLocation.AUCTION : SearchLocation.BAZAAR;
        search = "";
        suggestionsArray = new String[0];
        if (!itemName.isEmpty()) {
            SearchOverManager.updateSearch(itemName);
        }
        CLIENT.method_63588(() -> CLIENT.method_1507((class_437)new OverlayScreen()));
        return 1;
    }

    private static void loadItems() {
        HashSet<String> bazaarItems = new HashSet<String>();
        HashSet<String> auctionItems = new HashSet<String>();
        HashSet<String> auctionPets = new HashSet<String>();
        HashSet<String> starableItems = new HashSet<String>();
        HashMap<String, String> namesToNeuId = new HashMap<String, String>();
        try {
            if (TooltipInfoType.BAZAAR.getData() == null) {
                TooltipInfoType.BAZAAR.run();
            }
            Object2ObjectMap<String, BazaarProduct> products = TooltipInfoType.BAZAAR.getData();
            for (Map.Entry entry : products.entrySet()) {
                NEUItem neuItem;
                BazaarProduct product = (BazaarProduct)entry.getValue();
                String id = product.id();
                int sellVolume = product.sellVolume();
                if (sellVolume == 0) continue;
                if (id.startsWith("ENCHANTMENT_") && ItemRepository.getBazaarStocks().containsKey(id)) {
                    String neuId = ItemRepository.getBazaarStocks().get(id);
                    NEUItem neuItem2 = NEURepoManager.getItemByNeuId(neuId);
                    if (neuItem2 == null) continue;
                    String name = class_124.method_539((String)((String)neuItem2.getLore().getFirst()));
                    bazaarItems.add(name);
                    namesToNeuId.put(name, neuId);
                    continue;
                }
                if (id.startsWith("SHARD_") && ItemRepository.getBazaarStocks().containsKey(id)) {
                    id = ItemRepository.getBazaarStocks().get(id);
                }
                if ((neuItem = NEURepoManager.getItemByNeuId(id)) == null) continue;
                String name = class_124.method_539((String)neuItem.getDisplayName());
                bazaarItems.add(name);
                namesToNeuId.put(name, id);
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to load bazaar item list! ", (Throwable)e);
        }
        try {
            Set<@NEUId K> essenceCosts = NEURepoManager.getConstants().getEssenceCost().getCosts().keySet();
            if (TooltipInfoType.THREE_DAY_AVERAGE.getData() == null) {
                TooltipInfoType.THREE_DAY_AVERAGE.run();
            }
            for (Map.Entry entry : TooltipInfoType.THREE_DAY_AVERAGE.getData().object2DoubleEntrySet()) {
                String id = (String)entry.getKey();
                NEUItem neuItem = NEURepoManager.getItemByNeuId(id = id.split("[+-]")[0]);
                if (neuItem == null) continue;
                String name = class_124.method_539((String)neuItem.getDisplayName());
                if (name != null && name.startsWith(PET_NAME_START)) {
                    name = name.replace(PET_NAME_START, "");
                    auctionPets.add(name.toLowerCase(Locale.ENGLISH));
                }
                if (name != null && essenceCosts.contains(neuItem.getSkyblockItemId())) {
                    starableItems.add(name.toLowerCase(Locale.ENGLISH));
                }
                auctionItems.add(name);
                namesToNeuId.put(name, id);
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to load auction house item list! ", (Throwable)e);
        }
        SearchOverManager.bazaarItems = bazaarItems;
        SearchOverManager.auctionItems = auctionItems;
        SearchOverManager.auctionPets = auctionPets;
        SearchOverManager.starableItems = starableItems;
        SearchOverManager.namesToNeuId = namesToNeuId;
    }

    public static void updateSign(@NotNull class_2625 sign, boolean front, SearchLocation location) {
        signFront = front;
        SearchOverManager.sign = sign;
        isCommand = false;
        SearchOverManager.location = location;
        if (SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.keepPreviousSearches) {
            class_2561[] messages = SearchOverManager.sign.method_49843(signFront).method_49877(CLIENT.method_33883());
            search = messages[0].getString();
            if (!messages[1].getString().isEmpty()) {
                if (!search.endsWith(" ")) {
                    search = search + " ";
                }
                search = search + messages[1].getString();
            }
        } else {
            search = "";
        }
        suggestionsArray = new String[0];
    }

    protected static void updateSearch(String newValue) {
        search = newValue;
        int totalSuggestions = SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.maxSuggestions;
        if (newValue.isBlank() || totalSuggestions == 0) {
            return;
        }
        switch (location.ordinal()) {
            case 1: {
                suggestionsArray = SearchOverManager.updateSuggestions(auctionItems, totalSuggestions);
                break;
            }
            case 2: {
                suggestionsArray = SearchOverManager.updateSuggestions(bazaarItems, totalSuggestions);
                break;
            }
            case 3: {
                suggestionsArray = SearchOverManager.updateSuggestions(SearchOverManager.getMuseumSuggestions(), totalSuggestions);
            }
        }
    }

    private static Set<String> getMuseumSuggestions() {
        Map<Boolean, List<Donation>> types = MuseumItemCache.MUSEUM_DONATIONS.stream().collect(Collectors.partitioningBy(Donation::isSet));
        Stream<String> items = types.get(false).stream().map(Donation::getId).filter(MuseumItemCache::hasItemInMuseum).map(ItemRepository::getItemStack).filter(Objects::nonNull).map(class_1799::method_7964).map(class_2561::getString);
        Stream<String> sets = types.get(true).stream().map(Donation::getId).filter(MuseumItemCache::hasItemInMuseum).map(MuseumItemCache.ARMOR_NAMES::get);
        return Streams.concat((Stream[])new Stream[]{items, sets}).collect(Collectors.toSet());
    }

    protected static String[] updateSuggestions(Set<String> items, int totalSuggestions) {
        return (String[])items.stream().sorted(Comparator.comparing(SearchOverManager::shouldFrontLoad, Comparator.reverseOrder())).filter(item -> item.toLowerCase(Locale.ENGLISH).contains(search.toLowerCase(Locale.ENGLISH))).limit(totalSuggestions).toArray(String[]::new);
    }

    private static boolean shouldFrontLoad(String name) {
        if (location != SearchLocation.AUCTION) {
            return false;
        }
        if (!auctionPets.contains(name.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        return (double)search.length() / (double)name.length() > 0.5;
    }

    protected static String getSuggestion(int index) {
        if (suggestionsArray.length > index && suggestionsArray[index] != null) {
            return suggestionsArray[index];
        }
        return "";
    }

    protected static String getSuggestionId(int index) {
        String name = SearchOverManager.getSuggestion(index);
        return SearchOverManager.getItemId(name);
    }

    private static String getItemId(String name) {
        if (location != SearchLocation.MUSEUM || !MuseumItemCache.ARMOR_NAMES.containsValue(name)) {
            return namesToNeuId.get(name);
        }
        String armorId = "";
        for (Map.Entry<String, String> pair : MuseumItemCache.ARMOR_NAMES.entrySet()) {
            if (!pair.getValue().equals(name)) continue;
            armorId = pair.getKey();
            break;
        }
        return MuseumItemCache.ARMOR_TO_ID.getOrDefault(armorId, namesToNeuId.get(name));
    }

    protected static String getHistory(int index) {
        List<String> history;
        UIAndVisualsConfig.SearchOverlay config = SkyblockerConfigManager.get().uiAndVisuals.searchOverlay;
        switch (location.ordinal()) {
            case 1: {
                history = config.auctionHistory;
                break;
            }
            case 2: {
                history = config.bazaarHistory;
                break;
            }
            case 3: {
                history = config.museumHistory;
                break;
            }
            default: {
                return null;
            }
        }
        if (history.size() > index) {
            return history.get(index);
        }
        return null;
    }

    protected static String getHistoryId(int index) {
        return SearchOverManager.getItemId(SearchOverManager.getHistory(index));
    }

    protected static void removeHistoryItem(int index) {
        List<String> history;
        UIAndVisualsConfig.SearchOverlay config = SkyblockerConfigManager.get().uiAndVisuals.searchOverlay;
        switch (location.ordinal()) {
            case 1: {
                history = config.auctionHistory;
                break;
            }
            case 2: {
                history = config.bazaarHistory;
                break;
            }
            case 3: {
                history = config.museumHistory;
                break;
            }
            default: {
                return;
            }
        }
        if (history.size() > index) {
            history.remove(index);
        }
    }

    private static List<String> addToHistory(List<String> history, String search, int historyLength) {
        if (history.isEmpty() || !history.contains(search)) {
            history.addFirst(search);
            if (history.size() > historyLength) {
                history = history.subList(0, historyLength);
            }
        } else {
            history.remove(search);
            history.addFirst(search);
        }
        return history;
    }

    private static void saveHistory() {
        UIAndVisualsConfig.SearchOverlay config = SkyblockerConfigManager.get().uiAndVisuals.searchOverlay;
        switch (location.ordinal()) {
            case 1: {
                config.auctionHistory = SearchOverManager.addToHistory(config.auctionHistory, search, config.historyLength);
                break;
            }
            case 2: {
                config.bazaarHistory = SearchOverManager.addToHistory(config.bazaarHistory, search, config.historyLength);
                break;
            }
            case 3: {
                config.museumHistory = SearchOverManager.addToHistory(config.museumHistory, search, config.historyLength);
            }
        }
        SkyblockerConfigManager.update(Consumers.nop());
    }

    protected static void pushSearch() {
        if (!search.isEmpty()) {
            SearchOverManager.saveHistory();
        }
        if (location == SearchLocation.AUCTION) {
            SearchOverManager.addExtras();
        }
        if (location == SearchLocation.BAZAAR && !isCommand && search.toLowerCase(Locale.ENGLISH).contains("null")) {
            search = "\"%s\"".formatted(search);
        }
        if (isCommand) {
            SearchOverManager.pushCommand();
        } else {
            SearchOverManager.pushSign();
        }
    }

    private static void addExtras() {
        if (maxPetLevel.booleanValue()) {
            if (auctionPets.contains(search.toLowerCase(Locale.ENGLISH))) {
                search = search.equalsIgnoreCase("golden dragon") || search.equalsIgnoreCase("jade dragon") ? "[Lvl 200] " + search : "[Lvl 100] " + search;
            }
        } else if (auctionPets.contains(search.toLowerCase(Locale.ENGLISH))) {
            search = "] " + search;
        }
        if (dungeonStars > 0 && starableItems.contains(search.toLowerCase(Locale.ENGLISH))) {
            StringBuilder starString = new StringBuilder(" ");
            starString.append("\u272a".repeat(Math.max(0, Math.min(dungeonStars, 5))));
            switch (dungeonStars) {
                case 6: {
                    starString.append("\u278a");
                    break;
                }
                case 7: {
                    starString.append("\u278b");
                    break;
                }
                case 8: {
                    starString.append("\u278c");
                    break;
                }
                case 9: {
                    starString.append("\u278d");
                    break;
                }
                case 10: {
                    starString.append("\u278e");
                }
            }
            search = search + starString.toString();
        }
    }

    private static void pushCommand() {
        String command;
        if (search.isEmpty()) {
            return;
        }
        switch (location.ordinal()) {
            case 1: {
                command = "/ahSearch " + search;
                break;
            }
            case 2: {
                command = "/bz " + search;
                break;
            }
            default: {
                return;
            }
        }
        MessageScheduler.INSTANCE.sendMessageAfterCooldown(command, true);
    }

    private static void pushSign() {
        Pair<String, String> split = SearchOverManager.splitString(search);
        if (SearchOverManager.CLIENT.field_1724 != null && sign != null) {
            class_2561[] messages = sign.method_49843(signFront).method_49877(CLIENT.method_33883());
            SearchOverManager.CLIENT.field_1724.field_3944.method_52787((class_2596)new class_2877(sign.method_11016(), signFront, (String)split.left(), (String)split.right(), messages[2].getString(), messages[3].getString()));
        }
    }

    public static Pair<String, String> splitString(String s) {
        if (s.length() <= 15) {
            return Pair.of((Object)s, (Object)"");
        }
        int index = s.lastIndexOf(32, 15);
        if (index == -1) {
            return Pair.of((Object)s.substring(0, 15), (Object)"");
        }
        return Pair.of((Object)s.substring(0, index), (Object)s.substring(index + 1, Math.min(index + 16, s.length())).trim());
    }

    static {
        location = SearchLocation.NONE;
        search = "";
        maxPetLevel = false;
        dungeonStars = 0;
        bazaarItems = new HashSet();
        auctionItems = new HashSet();
        auctionPets = new HashSet();
        starableItems = new HashSet();
        namesToNeuId = new HashMap();
        suggestionsArray = new String[0];
    }

    public static enum SearchLocation {
        NONE,
        AUCTION,
        BAZAAR,
        MUSEUM;

    }
}

