/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.shortcut;

import com.demonwav.mcdev.annotations.Translatable;
import de.hysky.skyblocker.skyblock.shortcut.KeybindWidget;
import de.hysky.skyblocker.skyblock.shortcut.ShortcutKeyBinding;
import de.hysky.skyblocker.skyblock.shortcut.Shortcuts;
import de.hysky.skyblocker.skyblock.shortcut.ShortcutsConfigScreen;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class ShortcutsConfigListWidget
extends class_4265<AbstractShortcutEntry> {
    private static final int TEXT_Y_OFFSET = 7;
    private static final int TEXT_FIELD_PADDING = 2;
    private final ShortcutsConfigScreen screen;

    public ShortcutsConfigListWidget(class_310 minecraftClient, ShortcutsConfigScreen screen, int width, int height, int y) {
        super(minecraftClient, width, height, y, 24);
        this.screen = screen;
        ShortcutCategoryEntry<String> commandCategory = new ShortcutCategoryEntry<String>((Map<String, String>)Shortcuts.shortcuts.getData().commands(), x$0 -> new CommandShortcutEntry((ShortcutCategoryEntry<String>)((Object)x$0)), "skyblocker.shortcuts.command.target", "skyblocker.shortcuts.command.replacement");
        if (Shortcuts.isShortcutsLoaded()) {
            commandCategory.shortcutsMap.keySet().stream().sorted().forEach(commandTarget -> this.method_25321((class_350.class_351)new CommandShortcutEntry(commandCategory, (String)commandTarget)));
        } else {
            this.method_25321((class_350.class_351)new ShortcutLoadingEntry());
        }
        ShortcutCategoryEntry<String> commandArgCategory = new ShortcutCategoryEntry<String>((Map<String, String>)Shortcuts.shortcuts.getData().commandArgs(), (Function<ShortcutCategoryEntry<String>, ShortcutEntry<String>>)x$0 -> new CommandShortcutEntry((ShortcutCategoryEntry<String>)((Object)x$0)), "skyblocker.shortcuts.commandArg.target", "skyblocker.shortcuts.commandArg.replacement", "skyblocker.shortcuts.commandArg.tooltip");
        if (Shortcuts.isShortcutsLoaded()) {
            commandArgCategory.shortcutsMap.keySet().stream().sorted().forEach(commandArgTarget -> this.method_25321((class_350.class_351)new CommandShortcutEntry(commandArgCategory, (String)commandArgTarget)));
        } else {
            this.method_25321((class_350.class_351)new ShortcutLoadingEntry());
        }
        ShortcutCategoryEntry<ShortcutKeyBinding> keybindCategory = new ShortcutCategoryEntry<ShortcutKeyBinding>((Map<ShortcutKeyBinding, String>)Shortcuts.shortcuts.getData().keyBindings(), (Function<ShortcutCategoryEntry<ShortcutKeyBinding>, ShortcutEntry<ShortcutKeyBinding>>)x$0 -> new KeybindShortcutEntry((ShortcutCategoryEntry<ShortcutKeyBinding>)((Object)x$0)), "skyblocker.shortcuts.keyBinding.target", "skyblocker.shortcuts.keyBinding.replacement", "skyblocker.shortcuts.keyBinding.tooltip");
        if (Shortcuts.isShortcutsLoaded()) {
            keybindCategory.shortcutsMap.keySet().stream().sorted().forEach(keyBinding -> this.method_25321((class_350.class_351)new KeybindShortcutEntry(keybindCategory, keyBinding.copy())));
        } else {
            this.method_25321((class_350.class_351)new ShortcutLoadingEntry());
        }
    }

    public int method_25322() {
        return super.method_25322() + 100 + 4;
    }

    protected int method_65507() {
        return super.method_65507();
    }

    protected Optional<ShortcutCategoryEntry<?>> getCategory() {
        AbstractShortcutEntry abstractShortcutEntry = (AbstractShortcutEntry)this.method_25334();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShortcutCategoryEntry.class, ShortcutEntry.class}, (Object)((Object)abstractShortcutEntry), n)) {
            case 0 -> {
                ShortcutCategoryEntry category = (ShortcutCategoryEntry)abstractShortcutEntry;
                yield Optional.of(category);
            }
            case 1 -> {
                ShortcutEntry shortcutEntry = (ShortcutEntry)abstractShortcutEntry;
                yield Optional.of(shortcutEntry.category);
            }
            default -> Optional.empty();
        };
    }

    public void setSelected(@Nullable AbstractShortcutEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.screen.updateButtons();
    }

    protected void addShortcutAfterSelected() {
        this.getCategory().ifPresent(category -> {
            ArrayList newEntries = new ArrayList(this.method_25396());
            ShortcutEntry newEntry = category.entrySupplier.get();
            newEntries.add(this.method_25396().indexOf(this.method_25334()) + 1, newEntry);
            this.method_25314(newEntries);
            this.setSelected(newEntry);
        });
    }

    protected void updatePositions() {
        for (AbstractShortcutEntry child : this.method_25396()) {
            child.updatePositions();
        }
    }

    protected void updateKeybinds() {
        this.method_25396().stream().filter(KeybindShortcutEntry.class::isInstance).map(KeybindShortcutEntry.class::cast).forEach(KeybindShortcutEntry::update);
    }

    protected boolean stopEditing() {
        return this.method_25396().stream().filter(KeybindShortcutEntry.class::isInstance).map(KeybindShortcutEntry.class::cast).anyMatch(KeybindShortcutEntry::stopEditing);
    }

    protected boolean method_73379() {
        return true;
    }

    protected void removeEntry(AbstractShortcutEntry entry) {
        super.method_25330((class_350.class_351)entry);
    }

    protected boolean hasChanges() {
        ShortcutEntry[] notEmptyShortcuts = (ShortcutEntry[])this.getNotEmptyShortcuts().toArray(ShortcutEntry[]::new);
        return notEmptyShortcuts.length != Shortcuts.shortcuts.getData().size() || Arrays.stream(notEmptyShortcuts).anyMatch(ShortcutEntry::isChanged);
    }

    protected void saveShortcuts() {
        Shortcuts.shortcuts.getData().clear();
        this.getNotEmptyShortcuts().forEach(ShortcutEntry::save);
        Shortcuts.shortcuts.save();
    }

    private Stream<? extends ShortcutEntry<?>> getNotEmptyShortcuts() {
        return this.method_25396().stream().filter(ShortcutEntry.class::isInstance).map(e -> (ShortcutEntry)((Object)e)).filter(ShortcutEntry::isNotEmpty);
    }

    protected class ShortcutCategoryEntry<T>
    extends AbstractShortcutEntry {
        private final Map<T, String> shortcutsMap;
        private final Supplier<ShortcutEntry<T>> entrySupplier;
        private final class_2561 targetName;
        private final class_2561 replacementName;
        @Nullable
        private final class_2561 tooltip;

        private ShortcutCategoryEntry(Map<T, String> shortcutsMap, @Translatable Function<ShortcutCategoryEntry<T>, ShortcutEntry<T>> entryFactory, @Translatable String targetName, String replacementName) {
            this(shortcutsMap, entryFactory, targetName, replacementName, (class_2561)null);
        }

        private ShortcutCategoryEntry(Map<T, String> shortcutsMap, @Translatable Function<ShortcutCategoryEntry<T>, ShortcutEntry<T>> entryFactory, @Translatable String targetName, @Translatable String replacementName, String tooltip) {
            this(shortcutsMap, entryFactory, targetName, replacementName, (class_2561)class_2561.method_43471((String)tooltip));
        }

        private ShortcutCategoryEntry(Map<T, String> shortcutsMap, @Translatable Function<ShortcutCategoryEntry<T>, ShortcutEntry<T>> entryFactory, @Translatable String targetName, @Nullable String replacementName, class_2561 tooltip) {
            this.shortcutsMap = shortcutsMap;
            this.entrySupplier = () -> (ShortcutEntry)((Object)((Object)entryFactory.apply(this)));
            this.targetName = class_2561.method_43471((String)targetName);
            this.replacementName = class_2561.method_43471((String)replacementName);
            this.tooltip = tooltip;
            ShortcutsConfigListWidget.this.method_25321((class_350.class_351)this);
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public List<? extends class_6379> method_37025() {
            return List.of(new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37035(class_6381.field_33788, new class_2561[]{ShortcutCategoryEntry.this.targetName, ShortcutCategoryEntry.this.replacementName});
                }
            });
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            context.method_27534(((ShortcutsConfigListWidget)ShortcutsConfigListWidget.this).field_22740.field_1772, this.targetName, this.method_73388() - 85, this.method_46427() + 7, -1);
            context.method_27534(((ShortcutsConfigListWidget)ShortcutsConfigListWidget.this).field_22740.field_1772, this.replacementName, this.method_73388() + 85, this.method_46427() + 7, -1);
            if (this.tooltip != null && this.method_25405(mouseX, mouseY)) {
                context.method_71276(this.tooltip, mouseX, mouseY);
            }
        }
    }

    private class ShortcutLoadingEntry
    extends AbstractShortcutEntry {
        private final class_2561 text = class_2561.method_43471((String)"skyblocker.shortcuts.notLoaded");

        private ShortcutLoadingEntry() {
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public List<? extends class_6379> method_37025() {
            return List.of(new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37034(class_6381.field_33788, ShortcutLoadingEntry.this.text);
                }
            });
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            context.method_27534(((ShortcutsConfigListWidget)ShortcutsConfigListWidget.this).field_22740.field_1772, this.text, this.method_25368() / 2, this.method_46427() + 7, -1);
        }
    }

    public static abstract class AbstractShortcutEntry
    extends class_4265.class_4266<AbstractShortcutEntry> {
        protected void updatePositions() {
        }

        public boolean method_25402(class_11909 click, boolean doubled) {
            super.method_25402(click, doubled);
            return true;
        }
    }

    protected abstract class ShortcutEntry<T>
    extends AbstractShortcutEntry {
        protected final ShortcutCategoryEntry<T> category;
        protected final class_342 replacement;

        private ShortcutEntry(ShortcutCategoryEntry<T> category, T targetKey) {
            this.category = category;
            this.replacement = new class_342(class_310.method_1551().field_1772, ShortcutsConfigListWidget.this.field_22758 / 2 + 10, 7, 150, 20, category.replacementName);
            this.replacement.method_1880(48);
            this.replacement.method_1852(category.shortcutsMap.getOrDefault(targetKey, ""));
        }

        protected abstract boolean isNotEmpty();

        protected abstract boolean isChanged();

        protected abstract void save();

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            this.replacement.method_46419(this.method_46427() + 2);
            this.replacement.method_25394(context, mouseX, mouseY, deltaTicks);
            context.method_25300(((ShortcutsConfigListWidget)ShortcutsConfigListWidget.this).field_22740.field_1772, "\u2192", this.method_46426() + this.method_25368() / 2, this.method_46427() + 7, -1);
        }

        @Override
        protected void updatePositions() {
            super.updatePositions();
            this.replacement.method_46421(ShortcutsConfigListWidget.this.field_22758 / 2 + 10);
        }
    }

    protected class KeybindShortcutEntry
    extends ShortcutEntry<ShortcutKeyBinding> {
        private final List<class_339> children;
        private final ShortcutKeyBinding keyBinding;
        private final KeybindWidget keybindButton;
        private boolean duplicate;

        private KeybindShortcutEntry(ShortcutCategoryEntry<ShortcutKeyBinding> category) {
            this(category, new ShortcutKeyBinding(List.of(class_3675.field_16237)));
        }

        private KeybindShortcutEntry(ShortcutCategoryEntry<ShortcutKeyBinding> category, ShortcutKeyBinding keyBinding) {
            super(category, keyBinding);
            this.duplicate = false;
            this.keyBinding = keyBinding;
            this.keybindButton = new KeybindWidget(keyBinding, ShortcutsConfigListWidget.this.field_22758 / 2 - 160, 7, 150, 20, keyBinding.getBoundKeysText(), textSupplier -> keyBinding.isUnbound() ? class_2561.method_43469((String)"narrator.controls.unbound", (Object[])new Object[]{this.replacement.method_1882()}) : class_2561.method_43469((String)"narrator.controls.bound", (Object[])new Object[]{this.replacement.method_1882(), textSupplier.get()}), ShortcutsConfigListWidget.this::updateKeybinds);
            this.replacement.method_1863(command -> ShortcutsConfigListWidget.this.updateKeybinds());
            this.children = List.of(this.keybindButton, this.replacement);
            this.update();
        }

        public String toString() {
            return this.keyBinding.getBoundKeysText().getString() + " \u2192 " + this.replacement.method_1882();
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        @Override
        protected boolean isNotEmpty() {
            return !this.keyBinding.isUnbound() && !this.replacement.method_1882().isEmpty();
        }

        @Override
        protected boolean isChanged() {
            return !this.category.shortcutsMap.containsKey(this.keyBinding) || !this.category.shortcutsMap.get(this.keyBinding).equals(this.replacement.method_1882());
        }

        @Override
        protected void save() {
            this.category.shortcutsMap.put(this.keyBinding, this.replacement.method_1882());
        }

        @Override
        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            super.method_25343(context, mouseX, mouseY, hovered, deltaTicks);
            this.keybindButton.method_46419(this.method_46427() + 2);
            this.keybindButton.method_25394(context, mouseX, mouseY, deltaTicks);
            if (this.duplicate) {
                context.method_25294(this.keybindButton.method_46426() - 6, this.method_46427(), this.keybindButton.method_46426() - 3, this.method_46427() + this.method_25364(), -256);
            }
        }

        @Override
        protected void updatePositions() {
            super.updatePositions();
            this.keybindButton.method_46421(ShortcutsConfigListWidget.this.field_22758 / 2 - 160);
        }

        protected void update() {
            this.keybindButton.method_25355(this.keyBinding.getBoundKeysText());
            this.duplicate = false;
            class_5250 text = class_2561.method_43473();
            if (!this.keyBinding.isUnbound()) {
                for (class_304 otherKeyBinding : ((ShortcutsConfigListWidget)ShortcutsConfigListWidget.this).field_22740.field_1690.field_1839) {
                    if (!this.keyBinding.getBoundKeysTranslationKey().contains(otherKeyBinding.method_1428())) continue;
                    if (this.duplicate) {
                        text.method_27693(", ");
                    }
                    this.duplicate = true;
                    text.method_10852((class_2561)class_2561.method_43471((String)otherKeyBinding.method_1431()));
                }
                for (AbstractShortcutEntry shortcut : ShortcutsConfigListWidget.this.method_25396()) {
                    if (!(shortcut instanceof KeybindShortcutEntry)) continue;
                    KeybindShortcutEntry keyBindingShortcut = (KeybindShortcutEntry)shortcut;
                    if (this.keyBinding == keyBindingShortcut.keyBinding || !this.keyBinding.equals(keyBindingShortcut.keyBinding)) continue;
                    if (this.duplicate) {
                        text.method_27693(", ");
                    }
                    this.duplicate = true;
                    text.method_27693(keyBindingShortcut.replacement.method_1882());
                }
            }
            if (this.duplicate) {
                this.keybindButton.method_25355((class_2561)class_2561.method_43470((String)"[ ").method_10852((class_2561)this.keybindButton.method_25369().method_27661().method_27692(class_124.field_1068)).method_27693(" ]").method_27692(class_124.field_1061));
                this.keybindButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{text})));
            } else {
                this.keybindButton.method_47400(null);
            }
            if (this.keybindButton.isEditing()) {
                this.keybindButton.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)this.keybindButton.method_25369().method_27661().method_27695(new class_124[]{class_124.field_1068, class_124.field_1073})).method_27693(" <").method_27692(class_124.field_1054));
            }
        }

        protected boolean stopEditing() {
            return this.keybindButton.stopEditing();
        }
    }

    protected class CommandShortcutEntry
    extends ShortcutEntry<String> {
        private final List<class_342> children;
        private final class_342 target;

        private CommandShortcutEntry(ShortcutCategoryEntry<String> category) {
            this(category, "");
        }

        private CommandShortcutEntry(ShortcutCategoryEntry<String> category, String targetString) {
            super(category, targetString);
            this.target = new class_342(class_310.method_1551().field_1772, ShortcutsConfigListWidget.this.field_22758 / 2 - 160, 7, 150, 20, category.targetName);
            this.target.method_1880(48);
            this.target.method_1852(targetString);
            this.children = List.of(this.target, this.replacement);
        }

        public String toString() {
            return this.target.method_1882() + " \u2192 " + this.replacement.method_1882();
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        @Override
        protected boolean isNotEmpty() {
            return !this.target.method_1882().isEmpty() && !this.replacement.method_1882().isEmpty();
        }

        @Override
        protected boolean isChanged() {
            return !this.category.shortcutsMap.containsKey(this.target.method_1882()) || !this.category.shortcutsMap.get(this.target.method_1882()).equals(this.replacement.method_1882());
        }

        @Override
        protected void save() {
            this.category.shortcutsMap.put(this.target.method_1882(), this.replacement.method_1882());
        }

        @Override
        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            super.method_25343(context, mouseX, mouseY, hovered, deltaTicks);
            this.target.method_46419(this.method_46427() + 2);
            this.target.method_25394(context, mouseX, mouseY, deltaTicks);
        }

        @Override
        protected void updatePositions() {
            super.updatePositions();
            this.target.method_46421(ShortcutsConfigListWidget.this.field_22758 / 2 - 160);
        }
    }
}

