/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.SlayersConfig;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.skyblock.slayers.CallMaddox;
import de.hysky.skyblocker.skyblock.slayers.SlayerTier;
import de.hysky.skyblocker.skyblock.slayers.SlayerTimer;
import de.hysky.skyblocker.skyblock.slayers.SlayerType;
import de.hysky.skyblocker.skyblock.slayers.boss.vampire.ManiaIndicator;
import de.hysky.skyblocker.skyblock.slayers.boss.vampire.StakeIndicator;
import de.hysky.skyblocker.skyblock.slayers.boss.vampire.TwinClawsIndicator;
import de.hysky.skyblocker.utils.Area;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.mayor.MayorUtils;
import de.hysky.skyblocker.utils.render.title.Title;
import de.hysky.skyblocker.utils.render.title.TitleContainer;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1531;
import net.minecraft.class_1549;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlayerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlayerManager.class);
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern SLAYER_PATTERN = Pattern.compile("Revenant Horror|Atoned Horror|Tarantula Broodfather|Sven Packmaster|Voidgloom Seraph|Inferno Demonlord|Bloodfiend");
    private static final Pattern SLAYER_TIER_PATTERN = Pattern.compile("^(Revenant Horror|Tarantula Broodfather|Sven Packmaster|Voidgloom Seraph|Inferno Demonlord|Riftstalker Bloodfiend)\\s+(I|II|III|IV|V)$");
    private static final Pattern PATTERN_XP_NEEDED = Pattern.compile("\\s*(Wolf|Zombie|Spider|Enderman|Blaze|Vampire) Slayer LVL ([0-9]) - (?:Next LVL in ([\\d,]+) XP!|LVL MAXED OUT!)\\s*");
    private static final Pattern PATTERN_LVL_UP = Pattern.compile("\\s*LVL UP! \u279c (Wolf|Zombie|Spider|Enderman|Blaze|Vampire) Slayer LVL [1-9]\\s*");
    private static final Title MINIBOSS_SPAWN = new Title(class_2561.method_43471((String)"skyblocker.slayer.miniBossSpawnAlert").method_27692(class_124.field_1061));
    private static final Title BOSS_SPAWN = new Title(class_2561.method_43471((String)"skyblocker.slayer.bossSpawnAlert").method_27692(class_124.field_1061));
    private static SlayerQuest slayerQuest;
    private static BossFight bossFight;

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(SlayerManager::onChatMessage);
        SkyblockEvents.LOCATION_CHANGE.register(SlayerManager::onLocationChange);
        SkyblockEvents.AREA_CHANGE.register(SlayerManager::onAreaChange);
        Scheduler.INSTANCE.scheduleCyclic(TwinClawsIndicator::updateIce, SkyblockerConfigManager.get().slayers.vampireSlayer.holyIceUpdateFrequency);
        Scheduler.INSTANCE.scheduleCyclic(ManiaIndicator::updateMania, SkyblockerConfigManager.get().slayers.vampireSlayer.maniaUpdateFrequency);
        Scheduler.INSTANCE.scheduleCyclic(StakeIndicator::updateStake, SkyblockerConfigManager.get().slayers.vampireSlayer.steakStakeUpdateFrequency);
    }

    private static void onAreaChange(Area area) {
        if (area.equals((Object)Area.CHATEAU)) {
            SlayerManager.getSlayerBossInfo(false);
        }
    }

    private static void onLocationChange(Location location) {
        slayerQuest = null;
        bossFight = null;
        Scheduler.INSTANCE.schedule(() -> SlayerManager.getSlayerBossInfo(false), 40);
    }

    private static boolean onChatMessage(class_2561 text, boolean overlay) {
        if (overlay || !Utils.isOnSkyblock()) {
            return true;
        }
        String message = text.getString();
        switch (message.replaceFirst("^\\s+", "")) {
            case "Your Slayer Quest has been cancelled!": 
            case "SLAYER QUEST FAILED!": {
                slayerQuest = null;
                bossFight = null;
                CallMaddox.onSlayerFailed();
                return true;
            }
            case "SLAYER QUEST STARTED!": {
                if (slayerQuest == null) {
                    slayerQuest = new SlayerQuest();
                }
                bossFight = null;
                return true;
            }
            case "NICE! SLAYER BOSS SLAIN!": {
                if (slayerQuest != null && bossFight != null) {
                    SlayerManager.bossFight.slain = true;
                    SlayerTimer.onBossDeath(SlayerManager.bossFight.bossSpawnTime);
                    CallMaddox.onBossKilled();
                }
                return true;
            }
            case "SLAYER QUEST COMPLETE!": {
                if (slayerQuest != null && bossFight != null && !SlayerManager.bossFight.slain) {
                    SlayerTimer.onBossDeath(SlayerManager.bossFight.bossSpawnTime);
                    CallMaddox.onBossKilled();
                }
                bossFight = null;
                return true;
            }
        }
        if (slayerQuest == null) {
            return true;
        }
        Matcher matcherNextLvl = PATTERN_XP_NEEDED.matcher(message);
        Matcher matcherLvlUp = PATTERN_LVL_UP.matcher(message);
        if (matcherNextLvl.matches()) {
            if (message.contains("LVL MAXED OUT")) {
                SlayerManager.slayerQuest.level = message.contains("Vampire") ? 5 : 9;
                SlayerManager.slayerQuest.xpRemaining = -1;
                SlayerManager.slayerQuest.bossesNeeded = -1;
            } else {
                String xpRemainingStr = matcherNextLvl.group(3);
                if (xpRemainingStr != null) {
                    SlayerManager.slayerQuest.level = Integer.parseInt(matcherNextLvl.group(2));
                    SlayerManager.slayerQuest.xpRemaining = Integer.parseInt(xpRemainingStr.replace(",", "").trim());
                    SlayerManager.calculateBossesNeeded();
                }
            }
        } else if (matcherLvlUp.matches()) {
            SlayerManager.slayerQuest.level = Integer.parseInt(message.replaceAll("(\\d+).+", "$1"));
        }
        return true;
    }

    public static void calculateBossesNeeded() {
        int tier = SlayerManager.slayerQuest.slayerTier.ordinal();
        if (tier == 0) {
            SlayerManager.slayerQuest.bossesNeeded = -1;
            return;
        }
        int xpPerTier = SlayerManager.slayerQuest.slayerType.xpPerTier[tier - 1];
        if (MayorUtils.getMayor().perks().stream().anyMatch(perk -> perk.name().equals("Slayer XP Buff")) || MayorUtils.getMinister().perk().name().equals("Slayer XP Buff")) {
            xpPerTier = (int)((double)xpPerTier * 1.25);
        }
        SlayerManager.slayerQuest.bossesNeeded = (int)Math.ceil((double)SlayerManager.slayerQuest.xpRemaining / (double)xpPerTier);
    }

    public static void getSlayerBossInfo(boolean checkStatus) {
        if (checkStatus && slayerQuest == null) {
            return;
        }
        try {
            for (String line : Utils.STRING_SCOREBOARD) {
                Matcher matcher = SLAYER_TIER_PATTERN.matcher(line);
                if (matcher.find()) {
                    if (slayerQuest == null || !matcher.group(1).equals(SlayerManager.slayerQuest.slayerType.bossName) || !matcher.group(2).equals(SlayerManager.slayerQuest.slayerTier.name())) {
                        slayerQuest = new SlayerQuest();
                    }
                    SlayerManager.slayerQuest.slayerType = SlayerType.fromBossName(matcher.group(1));
                    SlayerManager.slayerQuest.slayerTier = SlayerTier.valueOf(matcher.group(2));
                    continue;
                }
                if (!line.equals("Slay the boss!") || SlayerManager.isBossSpawned()) continue;
                bossFight = new BossFight(null);
            }
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error("[Skyblocker] Failed to get slayer boss info", (Throwable)e);
        }
    }

    public static void checkSlayerBoss(class_1531 armorStand) {
        if (slayerQuest == null || !armorStand.method_16914() || SlayerManager.isBossSpawned() && SlayerManager.bossFight.boss != null) {
            return;
        }
        if (armorStand.method_5477().getString().contains(CLIENT.method_1548().method_1676())) {
            for (class_1297 otherArmorStands : SlayerManager.getEntityArmorStands((class_1297)armorStand, 1.5f)) {
                Matcher matcher = SLAYER_PATTERN.matcher(otherArmorStands.method_5477().getString());
                if (!matcher.find()) continue;
                if (bossFight != null && SlayerManager.bossFight.boss == null) {
                    bossFight.findBoss((class_1531)otherArmorStands);
                    return;
                }
                bossFight = new BossFight((class_1531)otherArmorStands);
                return;
            }
        }
        if (!armorStand.method_24516((class_1297)SlayerManager.CLIENT.field_1724, 15.0)) {
            return;
        }
        Arrays.stream(SlayerType.values()).forEach(type -> type.minibossNames.forEach(name -> {
            if (armorStand.method_5477().getString().contains((CharSequence)name) && SlayerManager.isInSlayerQuestType(type)) {
                slayerQuest.onMiniboss(armorStand, (SlayerType)((Object)type));
            }
        }));
    }

    public static List<class_1297> getEntityArmorStands(class_1297 entity, float expandY) {
        return entity.method_73183().method_8333(entity, entity.method_5829().method_1009((double)0.1f, (double)expandY, (double)0.1f), x -> x instanceof class_1531 && x.method_16914());
    }

    public static <T extends class_1297> T findClosestMobEntity(class_1299<T> entityType, class_1531 armorStand) {
        if (entityType == null) {
            return null;
        }
        List mobEntities = armorStand.method_73183().method_18023(entityType, armorStand.method_5829().method_1009(0.0, 1.5, 0.0), SlayerManager::isValidSlayerMob);
        mobEntities.sort(Comparator.comparingDouble(arg_0 -> ((class_1531)armorStand).method_5858(arg_0)));
        return (T)(switch (mobEntities.size()) {
            case 0 -> null;
            case 1 -> (class_1297)mobEntities.getFirst();
            default -> mobEntities.stream().min(Comparator.comparingInt(entity -> Math.abs(entity.field_6012 - armorStand.field_6012))).get();
        });
    }

    private static boolean isValidSlayerMob(class_1297 entity) {
        class_1308 mob;
        return entity.method_5805() && (!(entity instanceof class_1308) || !(mob = (class_1308)entity).method_6109()) && !(entity instanceof class_1549);
    }

    public static boolean shouldGlow(class_1297 entity, SlayersConfig.HighlightSlayerEntities highlightType) {
        if (!SlayerManager.isInSlayer()) {
            return false;
        }
        if (SkyblockerConfigManager.get().slayers.highlightMinis == highlightType && SlayerManager.isInSlayer() && SlayerManager.getSlayerQuest().minibosses.contains(entity)) {
            return true;
        }
        return SkyblockerConfigManager.get().slayers.highlightBosses == highlightType && SlayerManager.isBossSpawned() && SlayerManager.getBossFight().boss == entity;
    }

    public static class_238 getSlayerMobBoundingBox(class_1531 armorStand) {
        SlayerType slayerType = SlayerManager.getSlayerType();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"REVENANT", "TARANTULA", "VOIDGLOOM", "SVEN"}, (SlayerType)slayerType, n)) {
            case 0 -> new class_238(armorStand.method_23317() - 0.4, armorStand.method_23318() - 0.1, armorStand.method_23321() - 0.4, armorStand.method_23317() + 0.4, armorStand.method_23318() - 2.2, armorStand.method_23321() + 0.4);
            case 1 -> new class_238(armorStand.method_23317() - 0.9, armorStand.method_23318() - 0.2, armorStand.method_23321() - 0.9, armorStand.method_23317() + 0.9, armorStand.method_23318() - 1.2, armorStand.method_23321() + 0.9);
            case 2 -> new class_238(armorStand.method_23317() - 0.4, armorStand.method_23318() - 0.2, armorStand.method_23321() - 0.4, armorStand.method_23317() + 0.4, armorStand.method_23318() - 3.0, armorStand.method_23321() + 0.4);
            case 3 -> new class_238(armorStand.method_23317() - 0.5, armorStand.method_23318() - 0.1, armorStand.method_23321() - 0.5, armorStand.method_23317() + 0.5, armorStand.method_23318() - 1.0, armorStand.method_23321() + 0.5);
            case -1 -> null;
            default -> armorStand.method_5829();
        };
    }

    public static boolean isInSlayer() {
        return slayerQuest != null;
    }

    public static boolean isBossSpawned() {
        return SlayerManager.isInSlayer() && bossFight != null;
    }

    public static boolean isInSlayerType(SlayerType slayerType) {
        return SlayerManager.isBossSpawned() && SlayerManager.slayerQuest.slayerType.equals((Object)slayerType);
    }

    public static boolean isInSlayerQuestType(SlayerType slayerType) {
        return !SlayerManager.isBossSpawned() && SlayerManager.slayerQuest.slayerType.equals((Object)slayerType);
    }

    public static BossFight getBossFight() {
        return bossFight;
    }

    public static SlayerQuest getSlayerQuest() {
        return slayerQuest;
    }

    public static SlayerType getSlayerType() {
        return slayerQuest != null ? SlayerManager.slayerQuest.slayerType : null;
    }

    public static SlayerTier getSlayerTier() {
        return slayerQuest != null ? SlayerManager.slayerQuest.slayerTier : null;
    }

    public static class_1531 getSlayerBossArmorStand() {
        return bossFight != null ? SlayerManager.bossFight.bossArmorStand : null;
    }

    public static class_1297 getSlayerBoss() {
        return bossFight != null ? SlayerManager.bossFight.boss : null;
    }

    public static class SlayerQuest {
        public SlayerType slayerType = SlayerType.UNKNOWN;
        public SlayerTier slayerTier = SlayerTier.UNKNOWN;
        public List<class_1531> minibossesArmorStand = new ArrayList<class_1531>();
        public List<class_1297> minibosses = new ArrayList<class_1297>();
        public int level;
        public int xpRemaining;
        public int bossesNeeded;

        private void onMiniboss(class_1531 armorStand, SlayerType type) {
            if (this.minibossesArmorStand.contains(armorStand)) {
                return;
            }
            this.minibossesArmorStand.add(armorStand);
            this.minibosses.add(SlayerManager.findClosestMobEntity(type.mobType, armorStand));
            if (SkyblockerConfigManager.get().slayers.miniBossSpawnAlert) {
                TitleContainer.addTitle(MINIBOSS_SPAWN, 20);
                SlayerManager.CLIENT.field_1724.method_5783((class_3414)class_3417.field_14622.comp_349(), 0.5f, 0.1f);
            }
        }
    }

    public static class BossFight {
        public class_1531 bossArmorStand;
        public class_1297 boss;
        public Instant bossSpawnTime;
        public boolean slain = false;

        private BossFight(class_1531 armorStand) {
            this.findBoss(armorStand);
            this.bossSpawnTime = Instant.now();
            if (SkyblockerConfigManager.get().slayers.bossSpawnAlert) {
                TitleContainer.addTitle(BOSS_SPAWN, 20);
                SlayerManager.CLIENT.field_1724.method_5783((class_3414)class_3417.field_14622.comp_349(), 0.5f, 0.1f);
            }
        }

        public void findBoss(class_1531 armorStand) {
            this.bossArmorStand = armorStand;
            this.boss = armorStand != null ? SlayerManager.findClosestMobEntity(SlayerManager.slayerQuest.slayerType.mobType, armorStand) : null;
        }
    }
}

