/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.config;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsListTab;
import de.hysky.skyblocker.skyblock.tabhud.config.entries.WidgetEntry;
import de.hysky.skyblocker.skyblock.tabhud.config.preview.PreviewTab;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.ScreenBuilder;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.WidgetManager;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline.PositionRule;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.skyblock.tabhud.widget.HudWidget;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.gui.DropdownWidget;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class WidgetsConfigurationScreen
extends class_437
implements class_1712 {
    public static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private class_1707 handler;
    private String titleLowercase;
    public final boolean noHandler;
    private WidgetManager.ScreenLayer widgetsLayer = null;
    private class_437 parent = null;
    private boolean tabPreview = false;
    private PreviewTab previewTab;
    private final Map<String, Location> nameToLocation = Map.ofEntries(Map.entry("private islands", Location.PRIVATE_ISLAND), Map.entry("the hub", Location.HUB), Map.entry("the dungeon hub", Location.DUNGEON_HUB), Map.entry("the farming islands", Location.THE_FARMING_ISLAND), Map.entry("garden", Location.GARDEN), Map.entry("the park", Location.THE_PARK), Map.entry("the gold mine", Location.GOLD_MINE), Map.entry("deep caverns", Location.DEEP_CAVERNS), Map.entry("dwarven mines", Location.DWARVEN_MINES), Map.entry("crystal hollows", Location.CRYSTAL_HOLLOWS), Map.entry("the mineshaft", Location.GLACITE_MINESHAFT), Map.entry("spider's den", Location.SPIDERS_DEN), Map.entry("the end", Location.THE_END), Map.entry("crimson isle", Location.CRIMSON_ISLE), Map.entry("kuudra", Location.KUUDRAS_HOLLOW), Map.entry("the rift", Location.THE_RIFT), Map.entry("jerry's workshop", Location.WINTER_ISLAND));
    private Location currentLocation = Utils.getLocation();
    private final class_8088 tabManager = new class_8088(x$0 -> {
        class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
    }, x$0 -> this.method_37066((class_364)x$0));
    private class_8089 tabNavigation;
    private WidgetsListTab widgetsListTab;
    private boolean switchingToPopup = false;
    @Nullable
    private class_1799 slotThirteenBacklog = null;

    public Location getCurrentLocation() {
        return this.currentLocation;
    }

    public boolean isPreviewVisible() {
        return this.tabPreview;
    }

    @Init
    public static void initCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"hud").executes(ctx -> {
            if (Utils.isOnSkyblock() && SkyblockerConfigManager.get().uiAndVisuals.tabHud.tabHudEnabled) {
                MessageScheduler.INSTANCE.sendMessageAfterCooldown("/widgets", true);
            } else {
                Location currentLocation = Utils.isOnSkyblock() ? Utils.getLocation() : Location.HUB;
                MessageScheduler.queueOpenScreen(new WidgetsConfigurationScreen(currentLocation, WidgetManager.ScreenLayer.MAIN_TAB, null));
            }
            return 1;
        }))));
    }

    private WidgetsConfigurationScreen(@Nullable class_1707 handler, String titleLowercase, Location targetLocation, @Nullable WidgetManager.ScreenLayer widgetLayerToGoTo) {
        super((class_2561)class_2561.method_43470((String)"Widgets Configuration"));
        this.handler = handler;
        this.titleLowercase = titleLowercase;
        boolean bl = this.noHandler = handler == null;
        if (!this.noHandler) {
            this.handler.method_7596((class_1712)this);
            this.parseLocation();
        } else {
            this.currentLocation = targetLocation;
            this.widgetsLayer = widgetLayerToGoTo;
        }
        WidgetManager.getScreenBuilder(this.currentLocation).backupPositioning();
    }

    public WidgetsConfigurationScreen(@NotNull class_1707 handler, String titleLowercase) {
        this(handler, titleLowercase, Location.UNKNOWN, null);
    }

    public WidgetsConfigurationScreen(Location targetLocation, String widgetLayerToGoTo, class_437 parent) {
        this(null, "", targetLocation, WidgetManager.getScreenBuilder(targetLocation).getPositionRuleOrDefault(widgetLayerToGoTo).screenLayer());
        this.parent = parent;
    }

    public WidgetsConfigurationScreen(Location targetLocation, WidgetManager.ScreenLayer layerToGo, class_437 parent) {
        this(null, "", targetLocation, layerToGo);
        this.parent = parent;
    }

    protected void method_25426() {
        this.previewTab = new PreviewTab(this.field_22787, this, this.noHandler ? PreviewTab.Mode.EDITABLE_LOCATION : PreviewTab.Mode.NORMAL);
        PreviewTab previewDungeons = new PreviewTab(this.field_22787, this, PreviewTab.Mode.DUNGEON);
        if (this.noHandler) {
            this.previewTab.goToLayer(this.widgetsLayer);
        }
        this.widgetsListTab = new WidgetsListTab(this.field_22787, this.handler);
        this.tabNavigation = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631(new class_8087[]{this.widgetsListTab, this.previewTab, previewDungeons}).method_48627();
        this.widgetsListTab.setShouldShowCustomWidgetEntries(this.titleLowercase.startsWith("widgets ") || this.noHandler);
        this.updateCustomWidgets();
        this.tabNavigation.method_48987(0, false);
        this.switchingToPopup = false;
        this.method_37063((class_364)this.tabNavigation);
        this.method_48640();
    }

    protected void method_48640() {
        if (this.tabNavigation != null) {
            this.tabNavigation.method_48618(this.field_22789);
            this.tabNavigation.method_49613();
            int i = this.tabNavigation.method_48202().method_49619();
            class_8030 screenRect = new class_8030(0, i, this.field_22789, this.field_22790 - i - 5);
            this.tabManager.method_48616(screenRect);
        }
    }

    public void updateHandler(@NotNull class_1707 newHandler, String titleLowercase) {
        if (this.handler == null) {
            return;
        }
        this.handler.method_7603((class_1712)this);
        this.handler = newHandler;
        this.handler.method_7596((class_1712)this);
        this.titleLowercase = titleLowercase;
        this.parseLocation();
        this.widgetsListTab.updateHandler(this.handler);
    }

    public void updateCustomWidgets() {
        ArrayList<WidgetEntry> entries = new ArrayList<WidgetEntry>();
        for (HudWidget value : WidgetManager.widgetInstances.values()) {
            if (!value.availableLocations().contains((Object)this.currentLocation)) continue;
            entries.add(new WidgetEntry(value, this.currentLocation));
        }
        this.widgetsListTab.setCustomWidgetEntries(entries);
    }

    public void setCurrentLocation(Location location) {
        Location old = this.currentLocation;
        this.currentLocation = location;
        if (old != this.currentLocation) {
            WidgetManager.getScreenBuilder(this.currentLocation).backupPositioning();
            this.updateCustomWidgets();
        }
    }

    private void parseLocation() {
        String trim;
        boolean b = this.titleLowercase.startsWith("widgets ");
        if (this.widgetsListTab != null) {
            this.widgetsListTab.setShouldShowCustomWidgetEntries(b);
        }
        if (this.nameToLocation.containsKey(trim = this.titleLowercase.replace("widgets in", "").replace("widgets on", "").trim())) {
            this.setCurrentLocation(this.nameToLocation.get(trim));
        } else if (b) {
            LOGGER.warn("[Skyblocker] Couldn't find location for {} (trimmed: {})", (Object)this.titleLowercase, (Object)trim);
        }
    }

    @Nullable
    public class_1707 getHandler() {
        return this.handler;
    }

    public void method_7635(class_1703 handler, int slotId, class_1799 stack) {
        if (this.handler == null) {
            return;
        }
        if (slotId == 4) {
            this.tabPreview = stack.method_31574(class_1802.field_8575);
        }
        if (this.widgetsListTab == null) {
            if (slotId == 13) {
                this.slotThirteenBacklog = stack.method_7972();
            }
            return;
        }
        if (slotId == 13) {
            if (stack.method_31574(class_1802.field_8239)) {
                this.widgetsListTab.hopper(ItemUtils.getLore(stack));
            } else {
                this.widgetsListTab.hopper(null);
            }
        }
        if (slotId > (this.titleLowercase.startsWith("tablist widgets") ? 9 : 18) && slotId < this.handler.method_17388() * 9 - 9 || slotId == 45 || slotId == 53 || slotId == 50) {
            this.widgetsListTab.onSlotChange(slotId, stack);
        }
    }

    private void getBackOnTheScreenYouScallywagsAngryEmoji() {
        class_8087 class_80872;
        if (this.method_25397() || !((class_80872 = this.tabManager.method_48614()) instanceof PreviewTab)) {
            return;
        }
        PreviewTab tab = (PreviewTab)class_80872;
        ScreenBuilder builder = WidgetManager.getScreenBuilder(tab.getCurrentLocation());
        List<HudWidget> widgets = builder.getHudWidgets(tab.getCurrentScreenLayer());
        boolean needReposition = false;
        float scale = (float)SkyblockerConfigManager.get().uiAndVisuals.tabHud.tabHudScale / 100.0f;
        int padding = 2;
        class_8030 screenRect = new class_8030(padding, padding, (int)((float)this.field_22789 / scale) - padding * 2, (int)((float)this.field_22790 / scale) - padding * 2);
        for (HudWidget widget : widgets) {
            PositionRule rule = builder.getPositionRule(widget.getInternalID());
            if (rule == null || widget.method_48202().method_71524(screenRect)) continue;
            needReposition = true;
            builder.setPositionRule(widget.getInternalID(), new PositionRule("screen", PositionRule.Point.DEFAULT, PositionRule.Point.DEFAULT, 5, 5, rule.screenLayer()));
        }
        if (needReposition) {
            tab.updateWidgets();
        }
    }

    public void method_25393() {
        super.method_25393();
        this.getBackOnTheScreenYouScallywagsAngryEmoji();
        if (this.noHandler) {
            return;
        }
        if (this.slotThirteenBacklog != null && this.widgetsListTab != null) {
            this.widgetsListTab.hopper(ItemUtils.getLore(this.slotThirteenBacklog));
            this.slotThirteenBacklog = null;
        }
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1724 != null);
        if (!this.field_22787.field_1724.method_5805() || this.field_22787.field_1724.method_31481()) {
            this.field_22787.field_1724.method_7346();
        }
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        if (this.handler != null) {
            assert (this.field_22787.field_1724 != null);
            this.field_22787.field_1724.method_7346();
            super.method_25419();
        } else {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_7633(class_1703 handler, int property, int value) {
    }

    public void method_25432() {
        if (this.handler == null) {
            return;
        }
        if (!this.switchingToPopup && this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.handler.method_7595((class_1657)this.field_22787.field_1724);
        }
        this.handler.method_7603((class_1712)this);
        Scheduler.INSTANCE.schedule(PlayerListManager::updateList, 1);
        SkyblockerConfigManager.save();
    }

    public boolean method_25421() {
        return false;
    }

    public DropdownWidget<Location> createLocationDropdown(Consumer<Location> onLocationChanged) {
        List<Location> locations = Arrays.asList((Location[])ArrayUtils.removeElements((Object[])Location.values(), (Object[])new Location[]{Location.UNKNOWN, Location.DUNGEON}));
        return new DropdownWidget<Location>(this.field_22787, 0, 0, 50, 50, locations, location -> {
            this.setCurrentLocation((Location)((Object)location));
            onLocationChanged.accept((Location)((Object)location));
        }, locations.contains((Object)this.currentLocation) ? this.currentLocation : Location.HUB, isOpen -> this.previewTab.locationDropdownOpened((boolean)isOpen));
    }
}

