/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.WidgetManager;

public record PositionRule(String parent, Point parentPoint, Point thisPoint, int relativeX, int relativeY, WidgetManager.ScreenLayer screenLayer) {
    public static final PositionRule DEFAULT = new PositionRule("screen", Point.DEFAULT, Point.DEFAULT, 5, 5, WidgetManager.ScreenLayer.DEFAULT);
    public static final Codec<PositionRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("parent").forGetter(PositionRule::parent), (App)Point.CODEC.fieldOf("parent_anchor").forGetter(PositionRule::parentPoint), (App)Point.CODEC.fieldOf("this_anchor").forGetter(PositionRule::thisPoint), (App)Codec.INT.fieldOf("relative_x").forGetter(PositionRule::relativeX), (App)Codec.INT.fieldOf("relative_y").forGetter(PositionRule::relativeY), (App)WidgetManager.ScreenLayer.CODEC.fieldOf("layer").forGetter(PositionRule::screenLayer)).apply((Applicative)instance, PositionRule::new));

    public record Point(VerticalPoint verticalPoint, HorizontalPoint horizontalPoint) {
        public static final Point DEFAULT = new Point(VerticalPoint.TOP, HorizontalPoint.LEFT);
        public static final Codec<Point> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VerticalPoint.CODEC.fieldOf("v").forGetter(Point::verticalPoint), (App)HorizontalPoint.CODEC.fieldOf("h").forGetter(Point::horizontalPoint)).apply((Applicative)instance, Point::new));
    }

    public static enum VerticalPoint {
        TOP,
        CENTER,
        BOTTOM;

        public static final Codec<VerticalPoint> CODEC;

        public float getPercentage() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 0.0f;
                case 1 -> 0.5f;
                case 2 -> 1.0f;
            };
        }

        static {
            CODEC = Codec.STRING.xmap(VerticalPoint::valueOf, Enum::name);
        }
    }

    public static enum HorizontalPoint {
        LEFT,
        CENTER,
        RIGHT;

        public static final Codec<HorizontalPoint> CODEC;

        public float getPercentage() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 0.0f;
                case 1 -> 0.5f;
                case 2 -> 1.0f;
            };
        }

        static {
            CODEC = Codec.STRING.xmap(HorizontalPoint::valueOf, Enum::name);
        }
    }
}

