/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.teleport;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.StatusBarTracker;
import de.hysky.skyblocker.skyblock.dungeon.DungeonBoss;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.entity.MobGlow;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2362;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2577;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5498;
import net.minecraft.class_9322;

public class PredictiveSmoothAOTE {
    public static final class_2960 SMOOTH_AOTE_BEFORE_PHASE = SkyblockerMod.id("smooth_aote");
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern MANA_LORE = Pattern.compile("Mana Cost: (\\d+)");
    private static final long MAX_TELEPORT_TIME = 2500L;
    private static long startTime;
    private static class_243 startPos;
    private static class_243 cameraStartPos;
    private static class_243 teleportVector;
    private static long lastPing;
    private static long currentTeleportPing;
    private static int teleportsAhead;
    private static long lastTeleportTime;
    public static boolean teleportDisabled;

    @Init
    public static void init() {
        UseItemCallback.EVENT.register(SMOOTH_AOTE_BEFORE_PHASE, PredictiveSmoothAOTE::onItemInteract);
        UseItemCallback.EVENT.addPhaseOrdering(SMOOTH_AOTE_BEFORE_PHASE, Event.DEFAULT_PHASE);
        UseBlockCallback.EVENT.register(PredictiveSmoothAOTE::onBlockInteract);
    }

    public static void playerTeleported() {
        teleportsAhead = Math.max(0, teleportsAhead - 1);
        lastTeleportTime = System.currentTimeMillis();
        teleportDisabled = false;
        if (teleportsAhead == 0) {
            long timeLeft = currentTeleportPing - (System.currentTimeMillis() - startTime);
            if (timeLeft > 0L && timeLeft <= (long)SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE.maximumAddedLag) {
                return;
            }
            startPos = null;
            teleportVector = null;
        }
    }

    private static int extractTunedCustomData(class_2487 customData, int baseRange) {
        return customData != null && customData.method_10545("tuned_transmission") ? baseRange + customData.method_68083("tuned_transmission", 0) : baseRange;
    }

    private static class_1269 onItemInteract(class_1657 playerEntity, class_1937 world, class_1268 hand) {
        if (PredictiveSmoothAOTE.CLIENT.field_1724 == null) {
            return null;
        }
        PredictiveSmoothAOTE.calculateTeleportUse(hand);
        return class_1269.field_5811;
    }

    private static class_1269 onBlockInteract(class_1657 playerEntity, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        class_1799 itemStack = playerEntity.method_5998(hand);
        if (PredictiveSmoothAOTE.isShovel(itemStack) && PredictiveSmoothAOTE.canShovelActOnBlock(world.method_8320(blockHitResult.method_17777()).method_26204())) {
            PredictiveSmoothAOTE.calculateTeleportUse(hand);
        }
        return class_1269.field_5811;
    }

    private static boolean isShovel(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8876) || itemStack.method_31574(class_1802.field_8776) || itemStack.method_31574(class_1802.field_8699) || itemStack.method_31574(class_1802.field_8322) || itemStack.method_31574(class_1802.field_8250);
    }

    private static boolean canShovelActOnBlock(class_2248 block) {
        return block == class_2246.field_10219 || block == class_2246.field_10566 || block == class_2246.field_10253 || block == class_2246.field_10520;
    }

    private static void calculateTeleportUse(class_1268 hand) {
        class_2487 customData;
        if (PredictiveSmoothAOTE.CLIENT.field_1724 == null || PredictiveSmoothAOTE.CLIENT.field_1687 == null) {
            return;
        }
        if (!SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE.predictive) {
            return;
        }
        if (teleportDisabled) {
            return;
        }
        if (PredictiveSmoothAOTE.CLIENT.field_1690.method_31044() != class_5498.field_26664) {
            return;
        }
        if (!PredictiveSmoothAOTE.isAllowedLocation()) {
            return;
        }
        class_1799 heldItem = PredictiveSmoothAOTE.CLIENT.field_1724.method_6047();
        String itemId = heldItem.getSkyblockId();
        int distance = PredictiveSmoothAOTE.getItemDistance(itemId, customData = ItemUtils.getCustomData((class_9322)heldItem));
        if (distance == -1) {
            return;
        }
        Matcher manaNeeded = ItemUtils.getLoreLineIfMatch(heldItem, MANA_LORE);
        if (manaNeeded != null && manaNeeded.matches()) {
            int manaCost = Integer.parseInt(manaNeeded.group(1));
            int predictedMana = StatusBarTracker.getMana().value();
            if (predictedMana < manaCost) {
                return;
            }
        }
        if (teleportsAhead == 0 || startPos == null || teleportVector == null) {
            startPos = PredictiveSmoothAOTE.CLIENT.field_1724.method_73189().method_1031(0.0, (double)PredictiveSmoothAOTE.getEyeHeight(), 0.0);
            cameraStartPos = PredictiveSmoothAOTE.CLIENT.field_1724.method_33571();
            lastTeleportTime = System.currentTimeMillis();
            currentTeleportPing = lastPing;
        } else {
            startPos = startPos.method_1019(teleportVector);
            cameraStartPos = PredictiveSmoothAOTE.getInterpolatedPos();
            currentTeleportPing = lastPing;
        }
        startTime = System.currentTimeMillis();
        float pitch = PredictiveSmoothAOTE.CLIENT.field_1724.method_36455();
        float yaw = PredictiveSmoothAOTE.CLIENT.field_1724.method_36454();
        class_243 look = PredictiveSmoothAOTE.CLIENT.field_1724.method_5631(pitch, yaw);
        if (startPos == null) {
            return;
        }
        if (PredictiveSmoothAOTE.isTargetingNPC((class_1657)PredictiveSmoothAOTE.CLIENT.field_1724, 4.0, startPos, look).booleanValue()) {
            startPos = null;
            teleportVector = null;
            return;
        }
        teleportVector = PredictiveSmoothAOTE.raycast(distance, look, startPos);
        if (teleportVector == null) {
            startPos = null;
            return;
        }
        class_243 predictedEnd = startPos.method_1019(teleportVector);
        class_243 offsetVec = new class_243(predictedEnd.field_1352 - PredictiveSmoothAOTE.roundToCenter(predictedEnd.field_1352), predictedEnd.field_1351 - (Math.ceil(predictedEnd.field_1351) + (double)PredictiveSmoothAOTE.getEyeHeight() - 1.0), predictedEnd.field_1350 - PredictiveSmoothAOTE.roundToCenter(predictedEnd.field_1350));
        teleportVector = teleportVector.method_1020(offsetVec);
        ++teleportsAhead;
    }

    protected static float getEyeHeight() {
        if (PredictiveSmoothAOTE.CLIENT.field_1724 == null || !PredictiveSmoothAOTE.CLIENT.field_1724.method_5715()) {
            return 1.62f;
        }
        return Utils.getLocation().isModern() ? 1.27f : 1.54f;
    }

    protected static int getItemDistance(String itemId, class_2487 customData) {
        int distance;
        switch (itemId) {
            case "ASPECT_OF_THE_LEECH_1": {
                if (SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE.enableWeirdTransmission) {
                    distance = 3;
                    break;
                }
                return -1;
            }
            case "ASPECT_OF_THE_LEECH_2": {
                if (SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE.enableWeirdTransmission) {
                    distance = 4;
                    break;
                }
                return -1;
            }
            case "ASPECT_OF_THE_END": 
            case "ASPECT_OF_THE_VOID": {
                if (PredictiveSmoothAOTE.CLIENT.field_1690.field_1832.method_1434() && customData.method_68083("ethermerge", 0) == 1) {
                    if (SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE.enableEtherTransmission) {
                        distance = PredictiveSmoothAOTE.extractTunedCustomData(customData, 57);
                        break;
                    }
                } else if (SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE.enableInstantTransmission) {
                    distance = PredictiveSmoothAOTE.extractTunedCustomData(customData, 8);
                    break;
                }
                return -1;
            }
            case "ETHERWARP_CONDUIT": {
                if (SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE.enableEtherTransmission) {
                    distance = PredictiveSmoothAOTE.extractTunedCustomData(customData, 57);
                    break;
                }
                return -1;
            }
            case "SINSEEKER_SCYTHE": {
                if (SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE.enableSinrecallTransmission) {
                    distance = PredictiveSmoothAOTE.extractTunedCustomData(customData, 4);
                    break;
                }
                return -1;
            }
            case "NECRON_BLADE": 
            case "ASTRAEA": 
            case "HYPERION": 
            case "SCYLLA": 
            case "VALKYRIE": {
                if (SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE.enableWitherImpact) {
                    distance = 10;
                    break;
                }
                return -1;
            }
            default: {
                return -1;
            }
        }
        return distance;
    }

    private static Boolean isTargetingNPC(class_1657 player, double maxDistance, class_243 startPos, class_243 look) {
        if (startPos == null) {
            return false;
        }
        class_243 endPos = startPos.method_1019(look.method_1021(maxDistance));
        class_1937 world = player.method_73183();
        class_3959 context = new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player);
        double blockHitDistance = world.method_17742(context).method_17784().method_1022(startPos);
        class_238 searchBox = player.method_5829().method_18804(look.method_1021(maxDistance)).method_1014(1.0);
        class_3966 entityHit = class_1675.method_18075((class_1297)player, (class_243)startPos, (class_243)endPos, (class_238)searchBox, entity -> !entity.method_7325() && entity != player, (double)class_3532.method_33723((double)blockHitDistance));
        if (entityHit == null) {
            return false;
        }
        class_1297 entity2 = entityHit.method_17782();
        List<class_1531> armorStands = MobGlow.getArmorStands(entity2);
        return armorStands.stream().anyMatch(armorStand -> armorStand.method_5477().getString().equals("CLICK"));
    }

    private static double roundToCenter(double input) {
        return (double)Math.round(input - 0.5) + 0.5;
    }

    private static boolean isAllowedLocation() {
        if (Utils.getMap().equals("Mineshaft")) {
            return false;
        }
        if (Utils.getIslandArea().equals("\u23e3 Jungle Temple")) {
            return false;
        }
        if (Utils.getLocation() == Location.PRIVATE_ISLAND && !Utils.getIslandArea().equals("\u23e3 Your Island")) {
            return false;
        }
        if (Utils.getIslandArea().equals("\u23e3 Dojo")) {
            return false;
        }
        if (Utils.isInDungeons()) {
            if (DungeonManager.isInBoss() && DungeonManager.getBoss() == DungeonBoss.MAXOR) {
                return false;
            }
            if (!DungeonManager.isCurrentRoomMatched()) {
                return true;
            }
            if (DungeonManager.getCurrentRoom().getName().equals("boxes-room")) {
                return false;
            }
            if (DungeonManager.getCurrentRoom().getName().equals("teleport-pad-room")) {
                return false;
            }
            if (DungeonManager.getCurrentRoom().getName().startsWith("trap")) {
                return false;
            }
        }
        return true;
    }

    protected static class_243 raycast(int distance, class_243 direction, class_243 startPos) {
        if (PredictiveSmoothAOTE.CLIENT.field_1687 == null || direction == null || startPos == null) {
            return null;
        }
        class_2338 xDiagonalOffset = direction.method_10216() > 0.0 ? new class_2338(1, 0, 0) : new class_2338(-1, 0, 0);
        class_2338 zDiagonalOffset = direction.method_10215() > 0.0 ? new class_2338(0, 0, 1) : new class_2338(0, 0, -1);
        int closeFloorY = Integer.MAX_VALUE;
        for (double offset = 0.0; offset <= (double)distance; offset += 1.0) {
            class_243 pos = startPos.method_1019(direction.method_1021(offset));
            class_2338 checkPos = class_2338.method_49638((class_2374)pos);
            if (!PredictiveSmoothAOTE.canTeleportThrough(checkPos).booleanValue()) {
                if (offset == 0.0) {
                    return null;
                }
                return direction.method_1021(offset - 1.0);
            }
            if (!PredictiveSmoothAOTE.canTeleportThrough(checkPos.method_10084()).booleanValue()) {
                if (offset == 0.0) {
                    class_243 justAhead = startPos.method_1019(direction.method_1021(0.2));
                    if (justAhead.method_10214() - Math.floor(justAhead.method_10214()) <= 0.495) continue;
                    return null;
                }
                return direction.method_1021(offset - 1.0);
            }
            if (offset != 0.0 && direction.method_10216() < 0.0 && PredictiveSmoothAOTE.isBlockFloor(checkPos.method_10078()).booleanValue() && PredictiveSmoothAOTE.isBlockFloor(class_2338.method_49638((class_2374)pos.method_1020(direction)).method_10081((class_2382)zDiagonalOffset)).booleanValue()) {
                return direction.method_1021(offset - 1.0);
            }
            if (offset != 0.0 && direction.method_10215() < 0.0 && direction.method_10216() < 0.0 && PredictiveSmoothAOTE.isBlockFloor(checkPos.method_10072()).booleanValue() && PredictiveSmoothAOTE.isBlockFloor(class_2338.method_49638((class_2374)pos.method_1020(direction)).method_10081((class_2382)xDiagonalOffset)).booleanValue()) {
                return direction.method_1021(offset - 1.0);
            }
            if ((PredictiveSmoothAOTE.isBlockFloor(checkPos.method_10074()).booleanValue() || PredictiveSmoothAOTE.isBlockFloor(checkPos.method_10074().method_10081((class_2382)xDiagonalOffset)).booleanValue() && PredictiveSmoothAOTE.isBlockFloor(checkPos.method_10074().method_10081((class_2382)zDiagonalOffset)).booleanValue()) && pos.method_10214() - Math.floor(pos.method_10214()) < 0.31) {
                closeFloorY = checkPos.method_10264() - 1;
            }
            if (closeFloorY != checkPos.method_10264()) continue;
            return direction.method_1021(offset - 1.0);
        }
        return direction.method_1021((double)distance);
    }

    private static Boolean canTeleportThrough(class_2338 blockPos) {
        if (PredictiveSmoothAOTE.CLIENT.field_1687 == null) {
            return false;
        }
        class_2680 blockState = PredictiveSmoothAOTE.CLIENT.field_1687.method_8320(blockPos);
        if (blockState.method_26215()) {
            return true;
        }
        class_2248 block = blockState.method_26204();
        class_265 shape = blockState.method_26220((class_1922)PredictiveSmoothAOTE.CLIENT.field_1687, blockPos);
        return shape.method_1110() || block instanceof class_2577 || block instanceof class_2362 || block.equals(class_2246.field_10477) && (Integer)blockState.method_11654((class_2769)class_2741.field_12536) <= 3;
    }

    private static Boolean isBlockFloor(class_2338 blockPos) {
        if (PredictiveSmoothAOTE.CLIENT.field_1687 == null) {
            return false;
        }
        class_2680 blockState = PredictiveSmoothAOTE.CLIENT.field_1687.method_8320(blockPos);
        class_265 shape = blockState.method_26220((class_1922)PredictiveSmoothAOTE.CLIENT.field_1687, blockPos);
        if (shape.method_1110()) {
            return false;
        }
        return shape.method_1107().field_1325 >= 1.0 || blockState.method_26204() == class_2246.field_37576;
    }

    public static class_243 getInterpolatedPos() {
        if (PredictiveSmoothAOTE.CLIENT.field_1724 == null || teleportVector == null || startPos == null || teleportDisabled) {
            return null;
        }
        long gap = System.currentTimeMillis() - startTime;
        if (System.currentTimeMillis() - lastTeleportTime > Math.min(Math.max(lastPing, currentTeleportPing) + (long)SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE.maximumAddedLag * (long)teleportsAhead, 2500L)) {
            teleportDisabled = true;
            startPos = null;
            teleportVector = null;
            teleportsAhead = 0;
            return null;
        }
        long estimatedTeleportTime = Math.min(currentTeleportPing, 2500L);
        double percentage = Math.clamp((double)gap / (double)estimatedTeleportTime, 0.0, 1.0);
        if (teleportsAhead == 0 && gap >= estimatedTeleportTime + (long)SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE.maximumAddedLag) {
            startPos = null;
            teleportVector = null;
            return null;
        }
        return cameraStartPos.method_1019(teleportVector.method_1021(percentage));
    }

    public static void updatePing(long ping) {
        lastPing = ping;
    }
}

