/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.waypoint;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.HelperConfig;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.PosUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.waypoint.ProfileAwareWaypoint;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FairySouls {
    private static final Logger LOGGER = LoggerFactory.getLogger(FairySouls.class);
    private static final Supplier<Waypoint.Type> TYPE_SUPPLIER = () -> SkyblockerConfigManager.get().uiAndVisuals.waypoints.waypointType;
    private static CompletableFuture<Void> fairySoulsLoaded;
    private static int maxSouls;
    private static final Map<String, Map<class_2338, ProfileAwareWaypoint>> fairySouls;

    public static CompletableFuture<Void> runAsyncAfterFairySoulsLoad(Runnable runnable) {
        if (fairySoulsLoaded == null) {
            LOGGER.error("[Skyblocker] Fairy Souls have not being initialized yet! Please ensure the Fairy Souls configs is initialized before modules calling this method in SkyblockerMod#onInitializeClient. This error can be safely ignore in a test environment.");
            return CompletableFuture.completedFuture(null);
        }
        return fairySoulsLoaded.thenRunAsync(runnable);
    }

    public static int getFairySoulsSize(@Nullable String location) {
        return location == null ? maxSouls : fairySouls.get(location).size();
    }

    @Init
    public static void init() {
        FairySouls.loadFairySouls();
        ClientLifecycleEvents.CLIENT_STOPPING.register(FairySouls::saveFoundFairySouls);
        ClientCommandRegistrationCallback.EVENT.register(FairySouls::registerCommands);
        WorldRenderExtractionCallback.EVENT.register(FairySouls::extractRendering);
        ClientReceiveMessageEvents.ALLOW_GAME.register(FairySouls::onChatMessage);
    }

    private static void loadFairySouls() {
        fairySoulsLoaded = NEURepoManager.runAsyncAfterLoad(() -> {
            maxSouls = NEURepoManager.getConstants().getFairySouls().getMaxSouls();
            NEURepoManager.getConstants().getFairySouls().getSoulLocations().forEach((location, fairiesForLocation) -> fairySouls.put((String)location, fairiesForLocation.stream().map(coordinate -> new class_2338(coordinate.getX(), coordinate.getY(), coordinate.getZ())).collect(Collectors.toUnmodifiableMap(pos -> pos, pos -> new FairySoul((class_2338)pos, TYPE_SUPPLIER, ColorUtils.getFloatComponents(class_1767.field_7942), ColorUtils.getFloatComponents(class_1767.field_7964))))));
            LOGGER.debug("[Skyblocker] Loaded {} fairy souls across {} locations", (Object)fairySouls.values().stream().mapToInt(Map::size).sum(), (Object)fairySouls.size());
            try (BufferedReader reader2 = Files.newBufferedReader(SkyblockerMod.CONFIG_DIR.resolve("found_fairy_souls.json"));){
                for (Map.Entry foundFairiesForProfileJson : JsonParser.parseReader((Reader)reader2).getAsJsonObject().asMap().entrySet()) {
                    for (Map.Entry foundFairiesForLocationJson : ((JsonElement)foundFairiesForProfileJson.getValue()).getAsJsonObject().asMap().entrySet()) {
                        Map<class_2338, ProfileAwareWaypoint> fairiesForLocation2 = fairySouls.get(foundFairiesForLocationJson.getKey());
                        for (JsonElement foundFairy : ((JsonElement)foundFairiesForLocationJson.getValue()).getAsJsonArray().asList()) {
                            ProfileAwareWaypoint waypoint = fairiesForLocation2.get(PosUtils.parsePosString(foundFairy.getAsString()));
                            if (waypoint == null) {
                                LOGGER.warn("[Skyblocker] Ignored found fairy soul at {}", (Object)foundFairy.getAsString());
                                continue;
                            }
                            waypoint.setFound((String)foundFairiesForProfileJson.getKey());
                        }
                    }
                }
                LOGGER.debug("[Skyblocker] Loaded found fairy souls");
            }
            catch (NoSuchFileException reader2) {
            }
            catch (IOException e) {
                LOGGER.error("[Skyblocker] Failed to load found fairy souls", (Throwable)e);
            }
            LOGGER.info("[Skyblocker] Loaded {} fairy souls across {} locations", (Object)fairySouls.values().stream().mapToInt(Map::size).sum(), (Object)fairySouls.size());
        });
    }

    private static void saveFoundFairySouls(class_310 client) {
        HashMap<String, Map> foundFairies = new HashMap<String, Map>();
        for (Map.Entry<String, Map<class_2338, ProfileAwareWaypoint>> fairiesForLocation : fairySouls.entrySet()) {
            for (ProfileAwareWaypoint profileAwareWaypoint : fairiesForLocation.getValue().values()) {
                for (String profile : profileAwareWaypoint.foundProfiles) {
                    foundFairies.computeIfAbsent(profile, profile_ -> new HashMap());
                    ((Map)foundFairies.get(profile)).computeIfAbsent(fairiesForLocation.getKey(), location_ -> new HashSet());
                    ((Set)((Map)foundFairies.get(profile)).get(fairiesForLocation.getKey())).add(profileAwareWaypoint.pos);
                }
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(SkyblockerMod.CONFIG_DIR.resolve("found_fairy_souls.json"), new OpenOption[0]);){
            JsonObject foundFairiesJson = new JsonObject();
            for (Map.Entry entry : foundFairies.entrySet()) {
                JsonObject foundFairiesForProfileJson = new JsonObject();
                for (Map.Entry foundFairiesForLocation : ((Map)entry.getValue()).entrySet()) {
                    JsonArray foundFairiesForLocationJson = new JsonArray();
                    for (class_2338 foundFairy : (Set)foundFairiesForLocation.getValue()) {
                        foundFairiesForLocationJson.add(PosUtils.getPosString(foundFairy));
                    }
                    foundFairiesForProfileJson.add((String)foundFairiesForLocation.getKey(), (JsonElement)foundFairiesForLocationJson);
                }
                foundFairiesJson.add((String)entry.getKey(), (JsonElement)foundFairiesForProfileJson);
            }
            SkyblockerMod.GSON.toJson((JsonElement)foundFairiesJson, (Appendable)writer);
            LOGGER.info("[Skyblocker] Saved found fairy souls");
        }
        catch (IOException e) {
            LOGGER.error("[Skyblocker] Failed to write found fairy souls to file", (Throwable)e);
        }
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fairySouls").then(ClientCommandManager.literal((String)"markAllInCurrentIslandFound").executes(context -> {
            FairySouls.markAllFairiesOnCurrentIslandFound();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.fairySouls.markAllFound")));
            return 1;
        }))).then(ClientCommandManager.literal((String)"markAllInCurrentIslandMissing").executes(context -> {
            FairySouls.markAllFairiesOnCurrentIslandMissing();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.fairySouls.markAllMissing")));
            return 1;
        }))));
    }

    private static void extractRendering(PrimitiveCollector collector) {
        HelperConfig.FairySouls fairySoulsConfig = SkyblockerConfigManager.get().helpers.fairySouls;
        if (fairySoulsConfig.enableFairySoulsHelper && fairySoulsLoaded.isDone() && fairySouls.containsKey(Utils.getLocationRaw())) {
            for (Waypoint waypoint : fairySouls.get(Utils.getLocationRaw()).values()) {
                boolean fairySoulNotFound = waypoint.shouldRender();
                if (!fairySoulsConfig.highlightFoundSouls && !fairySoulNotFound || fairySoulsConfig.highlightOnlyNearbySouls && waypoint.pos.method_19770((class_2374)RenderHelper.getCamera().method_19326()) > 2500.0) continue;
                waypoint.extractRendering(collector);
            }
        }
    }

    private static boolean onChatMessage(class_2561 text, boolean overlay) {
        String message = text.getString();
        if (message.equals("You have already found that Fairy Soul!") || message.equals("\u00a7d\u00a7lSOUL! \u00a7fYou found a \u00a7dFairy Soul\u00a7f!")) {
            FairySouls.markClosestFairyFound();
        }
        return true;
    }

    private static void markClosestFairyFound() {
        if (!fairySoulsLoaded.isDone()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            LOGGER.warn("[Skyblocker] Failed to mark closest fairy soul as found because player is null");
            return;
        }
        Map<class_2338, ProfileAwareWaypoint> fairiesOnCurrentIsland = fairySouls.get(Utils.getLocationRaw());
        if (fairiesOnCurrentIsland == null) {
            LOGGER.warn("[Skyblocker] Failed to mark closest fairy soul as found because there are no fairy souls loaded on the current island. NEU repo probably failed to load.");
            return;
        }
        fairiesOnCurrentIsland.values().stream().filter(Waypoint::shouldRender).min(Comparator.comparingDouble(arg_0 -> FairySouls.lambda$markClosestFairyFound$10((class_1657)player, arg_0))).filter(arg_0 -> FairySouls.lambda$markClosestFairyFound$11((class_1657)player, arg_0)).ifPresent(Waypoint::setFound);
    }

    public static void markAllFairiesOnCurrentIslandFound() {
        Map<class_2338, ProfileAwareWaypoint> fairiesForLocation = fairySouls.get(Utils.getLocationRaw());
        if (fairiesForLocation != null) {
            fairiesForLocation.values().forEach(ProfileAwareWaypoint::setFound);
        }
    }

    public static void markAllFairiesOnCurrentIslandMissing() {
        Map<class_2338, ProfileAwareWaypoint> fairiesForLocation = fairySouls.get(Utils.getLocationRaw());
        if (fairiesForLocation != null) {
            fairiesForLocation.values().forEach(ProfileAwareWaypoint::setMissing);
        }
    }

    private static /* synthetic */ boolean lambda$markClosestFairyFound$11(class_1657 player, ProfileAwareWaypoint fairySoul) {
        return fairySoul.pos.method_19770((class_2374)player.method_73189()) <= 16.0;
    }

    private static /* synthetic */ double lambda$markClosestFairyFound$10(class_1657 player, ProfileAwareWaypoint fairySoul) {
        return fairySoul.pos.method_19770((class_2374)player.method_73189());
    }

    static {
        maxSouls = 0;
        fairySouls = new HashMap<String, Map<class_2338, ProfileAwareWaypoint>>();
    }

    private static class FairySoul
    extends ProfileAwareWaypoint {
        private FairySoul(class_2338 pos, Supplier<Waypoint.Type> typeSupplier, float[] missingColor, float[] foundColor) {
            super(pos, typeSupplier, missingColor, foundColor);
        }

        @Override
        public boolean shouldRender() {
            return super.shouldRender() || SkyblockerConfigManager.get().helpers.fairySouls.highlightFoundSouls;
        }
    }
}

