/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.waypoint;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.OtherLocationsConfig;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.PosUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.waypoint.ProfileAwareWaypoint;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Relics {
    private static final Logger LOGGER = LoggerFactory.getLogger(Relics.class);
    private static final Supplier<Waypoint.Type> TYPE_SUPPLIER = () -> SkyblockerConfigManager.get().uiAndVisuals.waypoints.waypointType;
    private static CompletableFuture<Void> relicsLoaded;
    private static int totalRelics;
    private static final Map<class_2338, ProfileAwareWaypoint> relics;

    @Init
    public static void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(Relics::loadRelics);
        ClientLifecycleEvents.CLIENT_STOPPING.register(Relics::saveFoundRelics);
        ClientCommandRegistrationCallback.EVENT.register(Relics::registerCommands);
        WorldRenderExtractionCallback.EVENT.register(Relics::extractRendering);
        ClientReceiveMessageEvents.ALLOW_GAME.register(Relics::onChatMessage);
    }

    private static void loadRelics(class_310 client) {
        relicsLoaded = CompletableFuture.runAsync(() -> {
            BufferedReader reader;
            try {
                reader = client.method_1478().openAsReader(SkyblockerMod.id("spidersden/relics.json"));
                try {
                    for (Map.Entry json : JsonParser.parseReader((Reader)reader).getAsJsonObject().asMap().entrySet()) {
                        if (((String)json.getKey()).equals("total")) {
                            totalRelics = ((JsonElement)json.getValue()).getAsInt();
                            continue;
                        }
                        if (!((String)json.getKey()).equals("locations")) continue;
                        for (JsonElement locationJson : ((JsonElement)json.getValue()).getAsJsonArray().asList()) {
                            JsonObject posData = locationJson.getAsJsonObject();
                            class_2338 pos = new class_2338(posData.get("x").getAsInt(), posData.get("y").getAsInt(), posData.get("z").getAsInt());
                            relics.put(pos, new Relic(pos, TYPE_SUPPLIER, ColorUtils.getFloatComponents(class_1767.field_7947), ColorUtils.getFloatComponents(class_1767.field_7957)));
                        }
                    }
                    LOGGER.info("[Skyblocker] Loaded relics locations");
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("[Skyblocker] Failed to load relics locations", (Throwable)e);
            }
            try {
                reader = Files.newBufferedReader(SkyblockerMod.CONFIG_DIR.resolve("found_relics.json"));
                try {
                    for (Map.Entry profileJson : JsonParser.parseReader((Reader)reader).getAsJsonObject().asMap().entrySet()) {
                        for (JsonElement foundRelicsJson : ((JsonElement)profileJson.getValue()).getAsJsonArray().asList()) {
                            relics.get(PosUtils.parsePosString(foundRelicsJson.getAsString())).setFound((String)profileJson.getKey());
                        }
                    }
                    LOGGER.debug("[Skyblocker] Loaded found relics");
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (NoSuchFileException reader2) {
            }
            catch (IOException e) {
                LOGGER.error("[Skyblocker] Failed to load found relics", (Throwable)e);
            }
        });
    }

    private static void saveFoundRelics(class_310 client) {
        HashMap<String, Set> foundRelics = new HashMap<String, Set>();
        for (ProfileAwareWaypoint relic : relics.values()) {
            for (String string : relic.foundProfiles) {
                foundRelics.computeIfAbsent(string, profile_ -> new HashSet());
                ((Set)foundRelics.get(string)).add(relic.pos);
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(SkyblockerMod.CONFIG_DIR.resolve("found_relics.json"), new OpenOption[0]);){
            JsonObject json = new JsonObject();
            for (Map.Entry entry : foundRelics.entrySet()) {
                JsonArray foundRelicsJson = new JsonArray();
                for (class_2338 foundRelic : (Set)entry.getValue()) {
                    foundRelicsJson.add(PosUtils.getPosString(foundRelic));
                }
                json.add((String)entry.getKey(), (JsonElement)foundRelicsJson);
            }
            SkyblockerMod.GSON.toJson((JsonElement)json, (Appendable)writer);
            LOGGER.debug("[Skyblocker] Saved found relics");
        }
        catch (IOException e) {
            LOGGER.error("[Skyblocker] Failed to write found relics to file", (Throwable)e);
        }
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"relics").then(ClientCommandManager.literal((String)"markAllFound").executes(context -> {
            relics.values().forEach(ProfileAwareWaypoint::setFound);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.relics.markAllFound")));
            return 1;
        }))).then(ClientCommandManager.literal((String)"markAllMissing").executes(context -> {
            relics.values().forEach(ProfileAwareWaypoint::setMissing);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.relics.markAllMissing")));
            return 1;
        }))));
    }

    private static void extractRendering(PrimitiveCollector collector) {
        OtherLocationsConfig.Relics config = SkyblockerConfigManager.get().otherLocations.spidersDen.relics;
        if (config.enableRelicsHelper && relicsLoaded.isDone() && Utils.getLocationRaw().equals("combat_1")) {
            for (ProfileAwareWaypoint relic : relics.values()) {
                boolean isRelicMissing = relic.shouldRender();
                if (!isRelicMissing && !config.highlightFoundRelics) continue;
                relic.extractRendering(collector);
            }
        }
    }

    private static boolean onChatMessage(class_2561 text, boolean overlay) {
        String message = text.getString();
        if (message.equals("You've already found this relic!") || message.startsWith("+10,000 Coins! (") && message.endsWith("/28 Relics)")) {
            Relics.markClosestRelicFound();
        }
        return true;
    }

    private static void markClosestRelicFound() {
        if (!relicsLoaded.isDone()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            LOGGER.warn("[Skyblocker] Failed to mark closest relic as found because player is null");
            return;
        }
        relics.values().stream().filter(Waypoint::shouldRender).min(Comparator.comparingDouble(arg_0 -> Relics.lambda$markClosestRelicFound$5((class_1657)player, arg_0))).filter(arg_0 -> Relics.lambda$markClosestRelicFound$6((class_1657)player, arg_0)).ifPresent(Waypoint::setFound);
    }

    private static /* synthetic */ boolean lambda$markClosestRelicFound$6(class_1657 player, ProfileAwareWaypoint relic) {
        return relic.pos.method_19770((class_2374)player.method_73189()) <= 16.0;
    }

    private static /* synthetic */ double lambda$markClosestRelicFound$5(class_1657 player, ProfileAwareWaypoint relic) {
        return relic.pos.method_19770((class_2374)player.method_73189());
    }

    static {
        totalRelics = 0;
        relics = new HashMap<class_2338, ProfileAwareWaypoint>();
    }

    private static class Relic
    extends ProfileAwareWaypoint {
        private Relic(class_2338 pos, Supplier<Waypoint.Type> typeSupplier, float[] missingColor, float[] foundColor) {
            super(pos, typeSupplier, missingColor, foundColor);
        }

        @Override
        public boolean shouldRender() {
            return super.shouldRender() || SkyblockerConfigManager.get().otherLocations.spidersDen.relics.highlightFoundRelics;
        }
    }
}

