/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.waypoint;

import com.google.common.collect.ImmutableList;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.mixins.accessors.CheckboxWidgetAccessor;
import de.hysky.skyblocker.skyblock.waypoint.AbstractWaypointsScreen;
import de.hysky.skyblocker.skyblock.waypoint.Waypoints;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.render.gui.ARGBTextInput;
import de.hysky.skyblocker.utils.render.gui.ColorPickerWidget;
import de.hysky.skyblocker.utils.render.gui.CyclingIconButtonWidget;
import de.hysky.skyblocker.utils.render.gui.NoopInput;
import de.hysky.skyblocker.utils.waypoint.NamedWaypoint;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import de.hysky.skyblocker.utils.waypoint.WaypointGroup;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3965;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_4265;
import net.minecraft.class_4286;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8028;
import net.minecraft.class_8662;
import net.minecraft.class_8667;
import net.minecraft.class_9848;

public class WaypointsListWidget
extends class_4265<AbstractWaypointEntry> {
    private static final class_2960 DELETE_ICON = SkyblockerMod.id("trash_can");
    private static final int ICON_WIDTH = 12;
    private static final int ICON_HEIGHT = 15;
    private static final class_2960 INSERT_TEXTURE = SkyblockerMod.id("insert_button");
    private static final class_2960 INSERT_HIGHLIGHTED_TEXTURE = SkyblockerMod.id("insert_button_highlighted");
    private final AbstractWaypointsScreen<?> screen;
    private Location island;
    private List<WaypointGroup> waypoints;
    private InsertPosition insertPosition = null;
    private final Set<WaypointGroup> collapsedGroups = new ReferenceOpenHashSet();

    public WaypointsListWidget(class_310 client, AbstractWaypointsScreen<?> screen, int width, int height, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
        this.screen = screen;
        this.setIsland(screen.island);
    }

    public int method_25322() {
        return 340;
    }

    protected int method_65507() {
        return super.method_65507();
    }

    Optional<WaypointGroupEntry> getGroup() {
        class_350.class_351 class_3512 = this.method_25334();
        if (class_3512 instanceof WaypointGroupEntry) {
            WaypointGroupEntry groupEntry = (WaypointGroupEntry)class_3512;
            return Optional.of(groupEntry);
        }
        class_3512 = this.method_25334();
        if (class_3512 instanceof WaypointEntry) {
            WaypointEntry waypointEntry = (WaypointEntry)class_3512;
            return Optional.of(waypointEntry.groupEntry);
        }
        return Optional.empty();
    }

    void setIsland(Location island) {
        this.island = island;
        this.waypoints = (List)this.screen.waypoints.get((Object)island);
        this.collapsedGroups.clear();
        this.collapsedGroups.addAll(this.waypoints);
        this.updateEntries();
    }

    void addWaypointGroupAfterSelected() {
        WaypointGroupEntry groupEntry = new WaypointGroupEntry();
        Optional<WaypointGroupEntry> selectedGroupEntryOptional = this.getGroup();
        int index = this.waypoints.size();
        if (selectedGroupEntryOptional.isPresent()) {
            WaypointGroupEntry selectedGroupEntry = selectedGroupEntryOptional.get();
            index = this.waypoints.indexOf(selectedGroupEntry.group) + 1;
        }
        this.waypoints.add(index, groupEntry.group);
        this.updateEntries();
    }

    protected void method_25311(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        int position;
        WaypointGroupEntry groupEntry;
        int insertButtonY;
        AbstractWaypointEntry hoveredEntry;
        super.method_25311(context, mouseX, mouseY, deltaTicks);
        this.insertPosition = null;
        AbstractWaypointEntry abstractWaypointEntry = hoveredEntry = (AbstractWaypointEntry)this.method_25308((double)this.method_25342() + (double)this.method_25322() / 2.0, mouseY);
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WaypointEntry.class, WaypointGroupEntry.class}, (Object)((Object)abstractWaypointEntry), n)) {
            case -1: {
                if (this.method_25396().isEmpty()) {
                    return;
                }
                int rowBottom = this.method_25319(this.method_25396().size() - 1);
                if (mouseY >= this.method_55443() || mouseY < rowBottom) {
                    return;
                }
                insertButtonY = rowBottom;
                AbstractWaypointEntry abstractWaypointEntry2 = (AbstractWaypointEntry)((Object)this.method_25396().getLast());
                int n2 = 0;
                block13: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WaypointEntry.class, WaypointGroupEntry.class}, (Object)((Object)abstractWaypointEntry2), n2)) {
                        case 0: {
                            WaypointEntry entry = (WaypointEntry)abstractWaypointEntry2;
                            groupEntry = entry.groupEntry;
                            position = this.method_25396().size() - this.method_25396().indexOf((Object)groupEntry) - 1;
                            break block0;
                        }
                        case 1: {
                            WaypointGroupEntry waypointGroupEntry = (WaypointGroupEntry)abstractWaypointEntry2;
                            if (this.collapsedGroups.contains(waypointGroupEntry.group)) {
                                n2 = 2;
                                continue block13;
                            }
                            groupEntry = waypointGroupEntry;
                            position = 0;
                            break block0;
                        }
                    }
                    break;
                }
                return;
            }
            case 0: {
                WaypointEntry waypointEntry = (WaypointEntry)abstractWaypointEntry;
                int i = this.method_25396().indexOf((Object)waypointEntry);
                int rowTop = this.method_25337(i);
                int rowBottom = this.method_25319(i);
                boolean top = Math.abs(mouseY - rowTop) < Math.abs(mouseY - rowBottom);
                groupEntry = waypointEntry.groupEntry;
                if (top) {
                    position = i - this.method_25396().indexOf((Object)groupEntry) - 1;
                    insertButtonY = rowTop;
                    break;
                }
                position = i - this.method_25396().indexOf((Object)groupEntry);
                insertButtonY = rowBottom;
                break;
            }
            case 1: {
                boolean top;
                WaypointGroupEntry waypointGroupEntry = (WaypointGroupEntry)abstractWaypointEntry;
                int i = this.method_25396().indexOf((Object)waypointGroupEntry);
                int rowTop = this.method_25337(i);
                int rowBottom = this.method_25319(i);
                boolean bl = top = Math.abs(mouseY - rowTop) < Math.abs(mouseY - rowBottom);
                if (top) {
                    AbstractWaypointEntry above;
                    insertButtonY = rowTop;
                    AbstractWaypointEntry abstractWaypointEntry3 = above = (AbstractWaypointEntry)this.method_48199(class_8028.field_41826, ignored -> true, (class_350.class_351)hoveredEntry);
                    int n3 = 0;
                    block14: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WaypointEntry.class, WaypointGroupEntry.class}, (Object)((Object)abstractWaypointEntry3), n3)) {
                            case 0: {
                                WaypointEntry entry = (WaypointEntry)abstractWaypointEntry3;
                                groupEntry = entry.groupEntry;
                                position = this.method_25396().indexOf((Object)above) - this.method_25396().indexOf((Object)groupEntry);
                                break block0;
                            }
                            case 1: {
                                WaypointGroupEntry group = (WaypointGroupEntry)abstractWaypointEntry3;
                                if (this.collapsedGroups.contains(group.group)) {
                                    n3 = 2;
                                    continue block14;
                                }
                                groupEntry = group;
                                position = 0;
                                break block0;
                            }
                        }
                        break;
                    }
                    return;
                }
                if (!this.collapsedGroups.contains(waypointGroupEntry.group)) {
                    insertButtonY = rowBottom;
                    position = 0;
                    groupEntry = waypointGroupEntry;
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        int mX = mouseX - this.method_25342();
        if (insertButtonY <= this.method_46427() || insertButtonY >= this.method_55443() || mX > 32) {
            return;
        }
        boolean hovering = this.method_25405(mouseX, mouseY) && Math.abs(mouseY - insertButtonY) <= 6 && mX < 16 && mX >= -8;
        context.method_52706(class_10799.field_56883, hovering ? INSERT_HIGHLIGHTED_TEXTURE : INSERT_TEXTURE, this.method_25342(), insertButtonY - 5, 48, 11);
        if (Debug.debugEnabled()) {
            context.method_51433(this.field_22740.field_1772, String.valueOf(position), this.method_46426(), this.method_46427(), -1, true);
        }
        if (hovering) {
            this.insertPosition = new InsertPosition(groupEntry, position);
            context.method_74037(class_11876.field_62455);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.insertPosition != null) {
            WaypointEntry entry = new WaypointEntry(this.insertPosition.groupEntry);
            this.insertPosition.groupEntry.group.waypoints().add(this.insertPosition.position, entry.waypoint);
            this.updateEntries();
        }
        return super.method_25402(click, doubled);
    }

    void updateEntries() {
        this.method_25339();
        for (WaypointGroup group : this.waypoints) {
            boolean collapsed = this.collapsedGroups.contains(group);
            WaypointGroupEntry groupEntry = new WaypointGroupEntry(group, collapsed);
            this.method_25321((class_350.class_351)groupEntry);
            if (collapsed) continue;
            for (NamedWaypoint waypoint : group.waypoints()) {
                this.method_25321((class_350.class_351)new WaypointEntry(groupEntry, waypoint));
            }
        }
    }

    void updateButtons() {
        for (class_4265.class_4266 entry : this.method_25396()) {
            if (entry instanceof WaypointGroupEntry) {
                WaypointGroupEntry groupEntry = (WaypointGroupEntry)entry;
                if (groupEntry.enabled.method_20372() != groupEntry.shouldBeChecked()) {
                    ((CheckboxWidgetAccessor)groupEntry.enabled).setChecked(!groupEntry.enabled.method_20372());
                    continue;
                }
            }
            if (!(entry instanceof WaypointEntry)) continue;
            WaypointEntry waypointEntry = (WaypointEntry)entry;
            if (waypointEntry.enabled.method_20372() == this.screen.isEnabled(waypointEntry.waypoint)) continue;
            waypointEntry.enabled.method_25306(NoopInput.INSTANCE);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private class_2338 getDefaultPos() {
        class_2338 class_23382;
        class_239 class_2392 = this.field_22740.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2392;
            if (this.field_22740.field_1765.method_17783() == class_239.class_240.field_1332) {
                class_23382 = blockHitResult.method_17777();
                return class_23382;
            }
        }
        if (this.field_22740.field_1724 != null) {
            class_23382 = this.field_22740.field_1724.method_24515();
            return class_23382;
        }
        class_23382 = class_2338.field_10980;
        return class_23382;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.method_19355(mouseX, mouseY).filter(element -> element.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)).isPresent() || super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private record InsertPosition(WaypointGroupEntry groupEntry, int position) {
    }

    protected class WaypointGroupEntry
    extends AbstractWaypointEntry {
        private WaypointGroup group;
        private final List<class_339> children;
        private final class_4286 enabled;
        private final class_7843 layout;

        public WaypointGroupEntry() {
            this(new WaypointGroup("New Group", this$0.island), false);
        }

        public WaypointGroupEntry(WaypointGroup initialGroup, boolean collapsed) {
            this.layout = new class_7843(WaypointsListWidget.this.method_25322(), WaypointsListWidget.this.field_62109);
            this.group = initialGroup;
            class_8667 leftLayout = class_8667.method_52742().method_52735(4);
            leftLayout.method_52740().method_46474();
            this.layout.method_52732((class_8021)leftLayout, class_7847::method_46461);
            class_8667 rightLayout = class_8667.method_52742().method_52735(4);
            rightLayout.method_52740().method_46474();
            this.layout.method_52732((class_8021)rightLayout, class_7847::method_46470);
            class_2561 arrow = class_2561.method_30163((String)(collapsed ? "\u25b2" : "\u25bc"));
            class_4185 collapseWaypoint = class_4185.method_46430((class_2561)arrow, button -> {
                if (collapsed) {
                    WaypointsListWidget.this.collapsedGroups.remove(this.group);
                } else {
                    WaypointsListWidget.this.collapsedGroups.add(this.group);
                }
                WaypointsListWidget.this.updateEntries();
            }).method_46437(11, 11).method_46431();
            leftLayout.method_52736((class_8021)collapseWaypoint);
            this.enabled = class_4286.method_54787((class_2561)class_2561.method_43473(), (class_327)((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772).method_54794(this.shouldBeChecked()).method_54791((checkbox, checked) -> this.group.waypoints().forEach(waypoint -> WaypointsListWidget.this.screen.enabledChanged((NamedWaypoint)waypoint, checked))).method_54788();
            leftLayout.method_52736((class_8021)this.enabled);
            class_342 nameField = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 70, 20, (class_2561)class_2561.method_43470((String)"Name"));
            nameField.method_1852(this.group.name());
            nameField.method_1863(this::updateName);
            leftLayout.method_52736((class_8021)nameField);
            CyclingIconButtonWidget orderedWidget = (CyclingIconButtonWidget)leftLayout.method_52736(new CyclingIconButtonWidget<Boolean>(20, 20, this.group.ordered(), new Boolean[]{Boolean.FALSE, Boolean.TRUE}, b -> new CyclingIconButtonWidget.Icon(SkyblockerMod.id("waypoints_screen/ordered_" + (b != false ? "enabled" : "disabled")), 16, 16), b -> class_7919.method_47407((class_2561)class_5244.method_32700((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.groupType"), (class_2561)class_2561.method_43471((String)(b != false ? "skyblocker.waypoints.groupType.ordered" : "skyblocker.waypoints.groupType.normal")).method_27692(class_124.field_1054))), this::updateOrdered));
            CyclingIconButtonWidget throughWallsWidget = (CyclingIconButtonWidget)leftLayout.method_52736(new CyclingIconButtonWidget<Boolean>(20, 20, this.group.renderThroughWalls(), new Boolean[]{Boolean.FALSE, Boolean.TRUE}, b -> new CyclingIconButtonWidget.Icon(SkyblockerMod.id("waypoints_screen/through_walls_" + (b != false ? "enabled" : "disabled")), 15, 16), b -> class_7919.method_47407((class_2561)class_5244.method_32700((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.throughWalls"), (class_2561)(b != false ? class_5244.field_24336 : class_5244.field_24337).method_27661().method_27692(class_124.field_1054))), this::updateRenderThroughWalls));
            CyclingIconButtonWidget waypointTypeWidget = (CyclingIconButtonWidget)leftLayout.method_52736(new CyclingIconButtonWidget<Waypoint.Type>(20, 20, this.group.waypointType(), Waypoint.Type.values(), t -> new CyclingIconButtonWidget.Icon(SkyblockerMod.id("waypoints_screen/waypoint_type_" + t.method_15434()), 12, 15), t -> class_7919.method_47407((class_2561)class_5244.method_32700((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.waypointType"), (class_2561)class_2561.method_43470((String)t.toString()).method_27692(class_124.field_1054))), this::updateWaypointType));
            class_4185 buttonNewWaypoint = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.new"), ignored -> {
                WaypointEntry waypointEntry = new WaypointEntry(this);
                this.group.waypoints().add(waypointEntry.waypoint);
                WaypointsListWidget.this.updateEntries();
                if (collapsed) {
                    WaypointsListWidget.this.collapsedGroups.remove(this.group);
                    WaypointsListWidget.this.updateEntries();
                }
            }).method_46432(72).method_46431();
            rightLayout.method_52736((class_8021)buttonNewWaypoint);
            class_5250 deleteText = class_2561.method_43471((String)"selectServer.deleteButton");
            class_8662 buttonDelete = class_8662.method_52723((class_2561)deleteText, ignored -> {
                WaypointsListWidget.this.waypoints.remove(this.group);
                WaypointsListWidget.this.updateEntries();
            }, (boolean)true).method_52726(20, 20).method_52727(DELETE_ICON, 12, 15).method_52724();
            buttonDelete.method_47400(class_7919.method_47407((class_2561)deleteText));
            rightLayout.method_52736((class_8021)buttonDelete);
            this.layout.method_48222();
            this.children = List.of(this.enabled, nameField, orderedWidget, throughWallsWidget, waypointTypeWidget, buttonNewWaypoint, buttonDelete, collapseWaypoint);
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean shouldBeChecked() {
            if (this.group.waypoints().isEmpty()) return false;
            if (!this.group.waypoints().stream().allMatch(WaypointsListWidget.this.screen::isEnabled)) return false;
            return true;
        }

        private void updateName(String name) {
            int index = WaypointsListWidget.this.waypoints.indexOf(this.group);
            this.group = this.group.withName(name);
            if (index >= 0) {
                WaypointsListWidget.this.waypoints.set(index, this.group);
            }
        }

        private void updateOrdered(boolean ordered) {
            int index = WaypointsListWidget.this.waypoints.indexOf(this.group);
            this.group = this.group.withOrdered(ordered);
            if (index >= 0) {
                WaypointsListWidget.this.waypoints.set(index, this.group);
            }
        }

        private void updateRenderThroughWalls(boolean renderThroughWalls) {
            int index = WaypointsListWidget.this.waypoints.indexOf(this.group);
            this.group = this.group.withRenderThroughWalls(renderThroughWalls);
            if (index >= 0) {
                WaypointsListWidget.this.waypoints.set(index, this.group);
            }
        }

        private void updateWaypointType(Waypoint.Type waypointType) {
            int index = WaypointsListWidget.this.waypoints.indexOf(this.group);
            this.group = this.group.withWaypointType(waypointType);
            if (index >= 0) {
                WaypointsListWidget.this.waypoints.set(index, this.group);
            }
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            this.layout.method_48229(this.method_46426(), this.method_46427());
            for (class_339 child : this.children) {
                child.method_25394(context, mouseX, mouseY, deltaTicks);
            }
        }
    }

    protected class WaypointEntry
    extends AbstractWaypointEntry {
        private final WaypointGroupEntry groupEntry;
        private NamedWaypoint waypoint;
        private final List<class_339> children;
        private final class_4185 buttonUp;
        private final class_4185 buttonDown;
        private final class_4286 enabled;
        private final ColorPickerButton colorPickerButton;
        private final class_7843 layout;

        public WaypointEntry(WaypointGroupEntry groupEntry) {
            this(groupEntry, groupEntry.group.createWaypoint(this$0.getDefaultPos()));
        }

        public WaypointEntry(WaypointGroupEntry groupEntry, NamedWaypoint initialWaypoint) {
            int color;
            this.layout = new class_7843(WaypointsListWidget.this.method_25322(), WaypointsListWidget.this.field_62109);
            this.groupEntry = groupEntry;
            this.waypoint = initialWaypoint;
            class_8667 leftLayout = class_8667.method_52742();
            leftLayout.method_52740().method_46474();
            this.layout.method_52732((class_8021)leftLayout, class_7847::method_46461);
            leftLayout.method_52736((class_8021)class_7852.method_46512((int)6));
            this.buttonUp = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2191"), button -> this.shiftWaypointIndex(-1)).method_46437(11, 11).method_46431();
            leftLayout.method_52736((class_8021)this.buttonUp);
            this.buttonDown = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2193"), button -> this.shiftWaypointIndex(1)).method_46437(11, 11).method_46431();
            leftLayout.method_52736((class_8021)this.buttonDown);
            this.enabled = class_4286.method_54787((class_2561)class_2561.method_43470((String)""), (class_327)((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772).method_54794(WaypointsListWidget.this.screen.isEnabled(this.waypoint)).method_54791((checkbox, checked) -> WaypointsListWidget.this.screen.enabledChanged(this.waypoint, checked)).method_54788();
            leftLayout.method_52738((class_8021)this.enabled, p -> p.method_46469(4));
            class_342 nameField = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 65, 20, (class_2561)class_2561.method_43470((String)"Name"));
            nameField.method_1852(this.waypoint.getName().getString());
            nameField.method_1863(this::updateName);
            leftLayout.method_52738((class_8021)nameField, p -> p.method_46469(2));
            leftLayout.method_52738((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"X:"), ((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772), p -> p.method_46469(2));
            class_342 xField = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 26, 20, (class_2561)class_2561.method_43470((String)"X"));
            xField.method_1852(Integer.toString(this.waypoint.pos.method_10263()));
            xField.method_1890(this::checkInt);
            xField.method_1863(this::updateX);
            leftLayout.method_52736((class_8021)xField);
            leftLayout.method_52738((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Y:"), ((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772), p -> p.method_46469(2));
            class_342 yField = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 26, 20, (class_2561)class_2561.method_43470((String)"Y"));
            yField.method_1852(Integer.toString(this.waypoint.pos.method_10264()));
            yField.method_1890(this::checkInt);
            yField.method_1863(this::updateY);
            leftLayout.method_52736((class_8021)yField);
            leftLayout.method_52738((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Z:"), ((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772), p -> p.method_46469(2));
            class_342 zField = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 26, 20, (class_2561)class_2561.method_43470((String)"Z"));
            zField.method_1852(Integer.toString(this.waypoint.pos.method_10260()));
            zField.method_1890(this::checkInt);
            zField.method_1863(this::updateZ);
            leftLayout.method_52736((class_8021)zField);
            ARGBTextInput colorField = new ARGBTextInput(0, 0, ((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, true, true);
            this.colorPickerButton = (ColorPickerButton)leftLayout.method_52738((class_8021)new ColorPickerButton(colorField, this::updateColor), p -> p.method_46469(2));
            this.colorPickerButton.color = color = class_9848.method_61318((float)this.waypoint.alpha, (float)this.waypoint.colorComponents[0], (float)this.waypoint.colorComponents[1], (float)this.waypoint.colorComponents[2]);
            colorField.setARGBColor(color);
            colorField.method_53533(20);
            colorField.setOnChange(this::updateColor);
            leftLayout.method_52736((class_8021)colorField);
            class_5250 deleteText = class_2561.method_43471((String)"selectServer.deleteButton");
            class_8662 buttonDelete = class_8662.method_52723((class_2561)deleteText, button -> {
                groupEntry.group.waypoints().remove(this.waypoint);
                WaypointsListWidget.this.updateEntries();
            }, (boolean)true).method_52726(20, 20).method_52727(DELETE_ICON, 12, 15).method_52724();
            buttonDelete.method_47400(class_7919.method_47407((class_2561)deleteText));
            this.layout.method_52732((class_8021)buttonDelete, class_7847::method_46470);
            this.layout.method_48222();
            ImmutableList.Builder builder = ImmutableList.builder();
            this.layout.method_48206(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.children = builder.build();
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        private void shiftWaypointIndex(int shift) {
            int currentIndex = this.groupEntry.group.waypoints().indexOf(this.waypoint);
            int newIndex = Math.clamp((long)(currentIndex + shift), 0, this.groupEntry.group.waypoints().size() - 1);
            this.groupEntry.group.waypoints().remove(currentIndex);
            this.groupEntry.group.waypoints().add(newIndex, this.waypoint);
            WaypointsListWidget.this.updateEntries();
        }

        private void updateName(String name) {
            if (this.waypoint.name.getString().equals(name)) {
                return;
            }
            int index = this.groupEntry.group.waypoints().indexOf(this.waypoint);
            this.waypoint = this.waypoint.withName(name);
            if (index >= 0) {
                this.groupEntry.group.waypoints().set(index, this.waypoint);
            }
        }

        private boolean checkInt(String string) {
            try {
                this.parseEmptiableInt(string);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private void updateX(String xString) {
            this.updateInt(xString, this.waypoint.pos.method_10263(), (Int2ObjectFunction<NamedWaypoint>)((Int2ObjectFunction)this.waypoint::withX));
        }

        private void updateY(String yString) {
            this.updateInt(yString, this.waypoint.pos.method_10264(), (Int2ObjectFunction<NamedWaypoint>)((Int2ObjectFunction)this.waypoint::withY));
        }

        private void updateZ(String zString) {
            this.updateInt(zString, this.waypoint.pos.method_10260(), (Int2ObjectFunction<NamedWaypoint>)((Int2ObjectFunction)this.waypoint::withZ));
        }

        private void updateInt(String newValueString, int currentValue, Int2ObjectFunction<NamedWaypoint> wither) {
            try {
                int index = this.groupEntry.group.waypoints().indexOf(this.waypoint);
                int newValue = this.parseEmptiableInt(newValueString);
                if (newValue == currentValue) {
                    return;
                }
                this.waypoint = (NamedWaypoint)wither.apply(newValue);
                if (index >= 0) {
                    this.groupEntry.group.waypoints().set(index, this.waypoint);
                }
            }
            catch (NumberFormatException e) {
                Waypoints.LOGGER.warn("[Skyblocker Waypoints] Failed to parse integer: {}", (Object)newValueString, (Object)e);
            }
        }

        private void updateColor(int colorInt) {
            int index = this.groupEntry.group.waypoints().indexOf(this.waypoint);
            float[] colorComponents = new float[]{(float)((colorInt & 0xFF0000) >> 16) / 255.0f, (float)((colorInt & 0xFF00) >> 8) / 255.0f, (float)(colorInt & 0xFF) / 255.0f};
            float alpha = (float)((colorInt & 0xFF000000) >>> 24) / 255.0f;
            if (Arrays.equals(this.waypoint.colorComponents, colorComponents) && this.waypoint.alpha == alpha) {
                return;
            }
            this.waypoint = this.waypoint.withColor(colorComponents, alpha);
            if (index >= 0) {
                this.groupEntry.group.waypoints().set(index, this.waypoint);
            }
            this.colorPickerButton.color = colorInt;
        }

        private int parseEmptiableInt(String value) throws NumberFormatException {
            return value.isEmpty() || value.equals("-") ? 0 : Integer.parseInt(value);
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            boolean showButtons;
            this.layout.method_48229(this.method_46426(), this.method_46427());
            this.buttonUp.field_22764 = showButtons = hovered && mouseY >= this.buttonUp.method_46427() - 1 && mouseY <= this.buttonUp.method_55443();
            this.buttonDown.field_22764 = showButtons;
            for (class_339 child : this.children) {
                child.method_25394(context, mouseX, mouseY, deltaTicks);
            }
        }
    }

    protected static abstract class AbstractWaypointEntry
    extends class_4265.class_4266<AbstractWaypointEntry> {
        protected AbstractWaypointEntry() {
        }
    }

    private class ColorPickerButton
    extends class_4264 {
        private final ARGBTextInput textInput;
        private final IntConsumer colorConsumer;
        private int color;

        ColorPickerButton(ARGBTextInput textInput, IntConsumer colorConsumer) {
            super(0, 0, 20, 20, (class_2561)class_2561.method_43473());
            this.textInput = textInput;
            this.colorConsumer = colorConsumer;
        }

        public void method_25306(class_11907 input) {
            ColorPickerWidget widget = new ColorPickerWidget(0, 0, 200, 110, true);
            widget.setOnColorChange((color, mouseRelease) -> {
                this.textInput.setARGBColor(color);
                this.color = color;
                if (mouseRelease) {
                    this.colorConsumer.accept(color);
                }
            });
            widget.setARGBColor(this.textInput.getARGBColor());
            WaypointsListWidget.this.screen.setPopup((class_8021)widget, this.method_46426(), this.method_55443());
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            int padding = 1;
            context.method_25294(this.method_46426() + padding, this.method_46427() + padding, this.method_55442() - padding, this.method_55443() - padding, this.method_49606() ? -1 : -16777216);
            context.method_25294(this.method_46426() + padding + 1, this.method_46427() + padding + 1, this.method_55442() - padding - 1, this.method_55443() - padding - 1, this.color);
            if (this.method_49606()) {
                context.method_74037(class_11876.field_62455);
            }
        }

        protected void method_47399(class_6382 builder) {
        }
    }
}

