/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.waypoint;

import com.google.common.collect.Multimap;
import de.hysky.skyblocker.skyblock.waypoint.AbstractWaypointsScreen;
import de.hysky.skyblocker.skyblock.waypoint.Waypoints;
import de.hysky.skyblocker.skyblock.waypoint.WaypointsScreen;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.waypoint.NamedWaypoint;
import de.hysky.skyblocker.utils.waypoint.WaypointGroup;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_5244;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

public class WaypointsShareScreen
extends AbstractWaypointsScreen<WaypointsScreen> {
    private final Set<NamedWaypoint> selectedWaypoints = new HashSet<NamedWaypoint>();
    private boolean overrideLocation = false;
    private boolean sortWaypoints = false;

    protected WaypointsShareScreen(WaypointsScreen parent, Multimap<Location, WaypointGroup> waypoints) {
        super((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.shareWaypoints"), parent, waypoints, parent.island);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int rowSpacing = 2;
        class_7845 gridWidget = new class_7845().method_48635(5).method_48636(rowSpacing);
        class_7845.class_7939 adder = gridWidget.method_47610(2);
        adder.method_47612((class_8021)class_4286.method_54787((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importOptions.overrideLocation"), (class_327)this.field_22793).method_61131(150).method_54791((checkbox, checked) -> {
            this.overrideLocation = checked;
        }).method_54793(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importOptions.overrideLocation.tooltip"))).method_54788());
        adder.method_47612((class_8021)class_4286.method_54787((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importOptions.sortWaypoints"), (class_327)this.field_22793).method_61131(150).method_54791((checkbox, checked) -> {
            this.sortWaypoints = checked;
        }).method_54793(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importOptions.sortWaypoints.tooltip"))).method_54788());
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importWaypointsSkyblocker"), buttonImport -> {
            try {
                List<WaypointGroup> waypointGroups = Waypoints.fromSkyblocker(this.field_22787.field_1774.method_1460(), this.island);
                if (waypointGroups == null) {
                    this.showErrorToast();
                    return;
                }
                for (WaypointGroup waypointGroup : waypointGroups) {
                    if (this.overrideLocation) {
                        waypointGroup = waypointGroup.withIsland(this.island);
                    }
                    if (this.sortWaypoints) {
                        waypointGroup = waypointGroup.sortWaypoints(NamedWaypoint.NAME_COMPARATOR);
                    }
                    this.selectedWaypoints.addAll(waypointGroup.waypoints());
                    this.waypoints.put((Object)waypointGroup.island(), (Object)waypointGroup);
                }
                this.waypointsListWidget.updateEntries();
                class_370.method_1990((class_374)this.field_22787.method_1566(), (class_370.class_9037)Waypoints.WAYPOINTS_TOAST_TYPE, (class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importSuccess"), (class_2561)class_2561.method_43469((String)"skyblocker.waypoints.importSuccessText", (Object[])new Object[]{waypointGroups.stream().map(WaypointGroup::waypoints).mapToInt(List::size).sum(), waypointGroups.size()}));
            }
            catch (Exception e) {
                Waypoints.LOGGER.error("[Skyblocker Waypoints] Encountered exception while parsing Skyblocker waypoint data", (Throwable)e);
                this.showErrorToast();
            }
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importWaypointsSkyblocker.tooltip"))).method_46431());
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.exportWaypointsSkyblocker"), buttonExport -> {
            try {
                List<WaypointGroup> waypointGroups = this.waypoints.values().stream().filter(waypointGroup -> waypointGroup.island().equals((Object)this.island)).map(waypointGroup -> waypointGroup.filterWaypoints(this.selectedWaypoints::contains)).filter(waypointGroup -> !waypointGroup.waypoints().isEmpty()).toList();
                this.field_22787.field_1774.method_1455(Waypoints.toSkyblocker(waypointGroups));
                class_370.method_1990((class_374)this.field_22787.method_1566(), (class_370.class_9037)Waypoints.WAYPOINTS_TOAST_TYPE, (class_2561)class_2561.method_43471((String)"skyblocker.waypoints.exportSuccess"), (class_2561)class_2561.method_43469((String)"skyblocker.waypoints.exportSuccessText", (Object[])new Object[]{waypointGroups.stream().map(WaypointGroup::waypoints).mapToInt(List::size).sum(), waypointGroups.size()}));
            }
            catch (Exception e) {
                Waypoints.LOGGER.error("[Skyblocker Waypoints] Encountered exception while serializing Skyblocker waypoint data", (Throwable)e);
                class_370.method_1990((class_374)this.field_22787.method_1566(), (class_370.class_9037)Waypoints.WAYPOINTS_TOAST_TYPE, (class_2561)class_2561.method_43471((String)"skyblocker.waypoints.exportError"), (class_2561)class_2561.method_43471((String)"skyblocker.waypoints.exportErrorText"));
            }
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.exportWaypointsSkyblocker.tooltip"))).method_46431());
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importWaypointsSkytils"), buttonImport -> {
            try {
                List<WaypointGroup> waypointGroups = Waypoints.fromSkytils(this.field_22787.field_1774.method_1460(), this.island);
                if (waypointGroups == null) {
                    this.showErrorToast();
                    return;
                }
                for (WaypointGroup waypointGroup : waypointGroups) {
                    if (this.overrideLocation) {
                        waypointGroup = waypointGroup.withIsland(this.island);
                    }
                    if (this.sortWaypoints) {
                        waypointGroup = waypointGroup.sortWaypoints(NamedWaypoint.NAME_COMPARATOR);
                    }
                    this.selectedWaypoints.addAll(waypointGroup.waypoints());
                    this.waypoints.put((Object)waypointGroup.island(), (Object)waypointGroup);
                }
                this.waypointsListWidget.updateEntries();
                class_370.method_1990((class_374)this.field_22787.method_1566(), (class_370.class_9037)Waypoints.WAYPOINTS_TOAST_TYPE, (class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importSuccess"), (class_2561)class_2561.method_43469((String)"skyblocker.waypoints.importSuccessText", (Object[])new Object[]{waypointGroups.stream().map(WaypointGroup::waypoints).mapToInt(List::size).sum(), waypointGroups.size()}));
            }
            catch (Exception e) {
                Waypoints.LOGGER.error("[Skyblocker Waypoints] Encountered exception while parsing Skytils waypoint data", (Throwable)e);
                this.showErrorToast();
            }
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importWaypointsSkytils.tooltip"))).method_46431());
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.exportWaypointsSkytils"), buttonExport -> {
            try {
                List<WaypointGroup> waypointGroups = this.waypoints.values().stream().filter(waypointGroup -> waypointGroup.island().equals((Object)this.island)).map(waypointGroup -> waypointGroup.filterWaypoints(this.selectedWaypoints::contains)).filter(waypointGroup -> !waypointGroup.waypoints().isEmpty()).toList();
                this.field_22787.field_1774.method_1455(Waypoints.toSkytilsBase64(waypointGroups));
                class_370.method_1990((class_374)this.field_22787.method_1566(), (class_370.class_9037)Waypoints.WAYPOINTS_TOAST_TYPE, (class_2561)class_2561.method_43471((String)"skyblocker.waypoints.exportSuccess"), (class_2561)class_2561.method_43469((String)"skyblocker.waypoints.exportSuccessText", (Object[])new Object[]{waypointGroups.stream().map(WaypointGroup::waypoints).mapToInt(List::size).sum(), waypointGroups.size()}));
            }
            catch (Exception e) {
                Waypoints.LOGGER.error("[Skyblocker Waypoints] Encountered exception while serializing Skytils waypoint data", (Throwable)e);
                class_370.method_1990((class_374)this.field_22787.method_1566(), (class_370.class_9037)Waypoints.WAYPOINTS_TOAST_TYPE, (class_2561)class_2561.method_43471((String)"skyblocker.waypoints.exportError"), (class_2561)class_2561.method_43471((String)"skyblocker.waypoints.exportErrorText"));
            }
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.exportWaypointsSkytils.tooltip"))).method_46431());
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importWaypointsSnoopy"), buttonImport -> {
            try {
                WaypointGroup waypointGroup = Waypoints.fromColeweightJson(this.field_22787.field_1774.method_1460(), this.island);
                if (this.overrideLocation) {
                    waypointGroup = waypointGroup.withIsland(this.island);
                }
                if (this.sortWaypoints) {
                    waypointGroup = waypointGroup.sortWaypoints(NamedWaypoint.NAME_COMPARATOR);
                }
                this.selectedWaypoints.addAll(waypointGroup.waypoints());
                this.waypoints.put((Object)waypointGroup.island(), (Object)waypointGroup);
                this.waypointsListWidget.updateEntries();
                class_370.method_1990((class_374)this.field_22787.method_1566(), (class_370.class_9037)Waypoints.WAYPOINTS_TOAST_TYPE, (class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importSuccess"), (class_2561)class_2561.method_43469((String)"skyblocker.waypoints.importSuccessText", (Object[])new Object[]{waypointGroup.waypoints().size(), 1}));
            }
            catch (Exception e) {
                Waypoints.LOGGER.error("[Skyblocker Waypoints] Encountered exception while parsing Snoopy waypoint data", (Throwable)e);
                this.showErrorToast();
            }
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importWaypointsSnoopy.tooltip"))).method_46431());
        adder.method_47612((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, buttonBack -> this.method_25419()).method_46431());
        this.layout.method_48996((class_8021)gridWidget);
        int rows = 4;
        this.layout.method_48991(20 * rows + rowSpacing * (rows - 1) + 8);
        super.lateInit();
    }

    private void showErrorToast() {
        class_370.method_1990((class_374)this.field_22787.method_1566(), (class_370.class_9037)Waypoints.WAYPOINTS_TOAST_TYPE, (class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importError"), (class_2561)class_2561.method_43471((String)"skyblocker.waypoints.importErrorText"));
    }

    @Override
    protected boolean isEnabled(NamedWaypoint waypoint) {
        return this.selectedWaypoints.contains(waypoint);
    }

    @Override
    protected void enabledChanged(NamedWaypoint waypoint, boolean enabled) {
        if (enabled) {
            this.selectedWaypoints.add(waypoint);
        } else {
            this.selectedWaypoints.remove(waypoint);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }
}

