/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public final class TextUtils {
    private TextUtils() {
    }

    public static int indexOfInList(List<class_2561> list, Pattern pattern) {
        return TextUtils.indexOfInList(list, pattern, 0);
    }

    public static int indexOfInList(List<class_2561> list, Pattern pattern, int startIndex) {
        if (startIndex >= list.size()) {
            return -1;
        }
        Matcher matcher = pattern.matcher("");
        int listSize = list.size();
        for (int i = startIndex; i < listSize; ++i) {
            class_2561 text = list.get(i);
            if (!matcher.reset(text.getString()).matches()) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static Matcher findInList(List<class_2561> list, Pattern pattern) {
        return TextUtils.findInList(list, pattern, 0);
    }

    @Nullable
    public static Matcher findInList(List<class_2561> list, Pattern pattern, int startIndex) {
        if (startIndex >= list.size()) {
            return null;
        }
        Matcher matcher = pattern.matcher("");
        int listSize = list.size();
        for (int i = startIndex; i < listSize; ++i) {
            class_2561 text = list.get(i);
            if (!matcher.reset(text.getString()).find()) continue;
            return matcher;
        }
        return null;
    }

    @Nullable
    public static Matcher matchInList(List<class_2561> list, Pattern pattern) {
        return TextUtils.matchInList(list, pattern, 0);
    }

    @Nullable
    public static Matcher matchInList(List<class_2561> list, Pattern pattern, int startIndex) {
        if (startIndex >= list.size()) {
            return null;
        }
        Matcher matcher = pattern.matcher("");
        int listSize = list.size();
        for (int i = startIndex; i < listSize; ++i) {
            class_2561 text = list.get(i);
            if (!matcher.reset(text.getString()).matches()) continue;
            return matcher;
        }
        return null;
    }

    public static List<Matcher> matchInList(List<class_2561> list, Pattern ... patterns) {
        return TextUtils.matchInList(list, 0, patterns);
    }

    public static List<Matcher> matchInList(List<class_2561> list, int startIndex, Pattern ... patterns) {
        if (list.isEmpty()) {
            return List.of();
        }
        List<Matcher> matchers = Arrays.stream(patterns).map(p -> p.matcher("")).toList();
        int listSize = list.size();
        for (int i = startIndex; i < listSize; ++i) {
            String line = list.get(i).getString();
            boolean allMatched = true;
            for (Matcher matcher : matchers) {
                if (matcher.hasMatch() || matcher.reset(line).matches()) continue;
                allMatched = false;
            }
            if (!allMatched) continue;
            return matchers;
        }
        return List.of();
    }
}

