/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.discord;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.utils.Utils;
import java.text.DecimalFormat;
import java.util.concurrent.CompletableFuture;
import meteordevelopment.discordipc.DiscordIPC;
import meteordevelopment.discordipc.RichPresence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscordRPCManager {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###.##");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Skyblocker Discord RPC");
    public static CompletableFuture<Void> updateTask;
    public static long startTimeStamp;
    public static int cycleCount;

    @Init
    public static void init() {
        SkyblockEvents.LEAVE.register(DiscordRPCManager::initAndUpdatePresence);
        SkyblockEvents.JOIN.register(() -> {
            startTimeStamp = System.currentTimeMillis();
            DiscordRPCManager.initAndUpdatePresence(true);
        });
    }

    public static void updateDataAndPresence() {
        if (SkyblockerConfigManager.get().misc.richPresence.customMessage.isEmpty()) {
            SkyblockerConfigManager.update(config -> {
                config.misc.richPresence.customMessage = "Playing Skyblock";
            });
        }
        if (SkyblockerConfigManager.get().misc.richPresence.cycleMode) {
            cycleCount = (cycleCount + 1) % 3;
        }
        DiscordRPCManager.initAndUpdatePresence();
    }

    private static void initAndUpdatePresence() {
        DiscordRPCManager.initAndUpdatePresence(false);
    }

    private static void initAndUpdatePresence(boolean initialization) {
        if (updateTask == null || updateTask.isDone()) {
            updateTask = CompletableFuture.runAsync(() -> {
                if (SkyblockerConfigManager.get().misc.richPresence.enableRichPresence && Utils.isOnSkyblock()) {
                    if (!DiscordIPC.isConnected()) {
                        if (DiscordIPC.start((long)934607927837356052L, null)) {
                            LOGGER.info("[Skyblocker] Discord RPC connected successfully");
                        } else {
                            if (initialization) {
                                LOGGER.error("[Skyblocker] Discord RPC failed to connect");
                            }
                            return;
                        }
                    }
                    DiscordIPC.setActivity((RichPresence)DiscordRPCManager.buildPresence());
                } else if (DiscordIPC.isConnected()) {
                    DiscordIPC.stop();
                    LOGGER.info("[Skyblocker] Discord RPC disconnected");
                } else if (initialization) {
                    LOGGER.info("[Skyblocker] Discord RPC is currently disabled, will not connect");
                }
            });
        }
    }

    public static RichPresence buildPresence() {
        RichPresence presence = new RichPresence();
        presence.setLargeImage("skyblocker-default", null);
        presence.setStart(startTimeStamp);
        presence.setDetails(SkyblockerConfigManager.get().misc.richPresence.customMessage);
        presence.setState(DiscordRPCManager.getInfo());
        return presence;
    }

    public static String getInfo() {
        Object info = null;
        if (!SkyblockerConfigManager.get().misc.richPresence.cycleMode) {
            switch (SkyblockerConfigManager.get().misc.richPresence.info) {
                case BITS: {
                    info = "Bits: " + DECIMAL_FORMAT.format(Utils.getBits());
                    break;
                }
                case PURSE: {
                    info = "Purse: " + DECIMAL_FORMAT.format(Utils.getPurse());
                    break;
                }
                case LOCATION: {
                    info = Utils.getIslandArea();
                }
            }
        } else if (SkyblockerConfigManager.get().misc.richPresence.cycleMode) {
            switch (cycleCount) {
                case 0: {
                    info = "Bits: " + DECIMAL_FORMAT.format(Utils.getBits());
                    break;
                }
                case 1: {
                    info = "Purse: " + DECIMAL_FORMAT.format(Utils.getPurse());
                    break;
                }
                case 2: {
                    info = Utils.getIslandArea();
                }
            }
        }
        return info;
    }
}

