/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render.gui;

import com.mojang.logging.LogUtils;
import java.util.Locale;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.IntConsumer;
import net.minecraft.class_11876;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ARGBTextInput
extends class_339 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_124[] FORMATTINGS = new class_124[]{class_124.field_1068, class_124.field_1061, class_124.field_1060, class_124.field_1078};
    private static final String HEXADECIMAL_CHARS = "0123456789aAbBcCdDeEfF";
    private final int length;
    private final boolean drawBackground;
    private final class_327 textRenderer;
    private final boolean hasAlpha;
    private final int alphaMask;
    private String input;
    int index = 0;
    @Nullable
    private IntConsumer onChange = null;

    public ARGBTextInput(int x, int y, class_327 textRenderer, boolean drawBackground, boolean hasAlpha) {
        super(x, y, textRenderer.method_1727(hasAlpha ? "AAAAAAAA" : "AAAAAA") + (drawBackground ? 6 : 0), 10 + (drawBackground ? 4 : 0), class_2561.method_30163((String)"ARGBTextInput"));
        this.drawBackground = drawBackground;
        this.textRenderer = textRenderer;
        this.length = hasAlpha ? 8 : 6;
        this.hasAlpha = hasAlpha;
        this.alphaMask = hasAlpha ? 0 : -16777216;
        this.input = hasAlpha ? "FFFFFFFF" : "FFFFFF";
    }

    public ARGBTextInput(int x, int y, class_327 textRenderer, boolean drawBackground) {
        this(x, y, textRenderer, drawBackground, false);
    }

    protected OptionalInt getOptionalARGBColor(String input) {
        try {
            int i = Integer.parseUnsignedInt(input, 16);
            return OptionalInt.of(this.alphaMask | i);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Could not parse rgb color", (Throwable)e);
            return OptionalInt.empty();
        }
    }

    public int getARGBColor() {
        return this.getOptionalARGBColor(this.input).orElse(-1);
    }

    public void setARGBColor(int argb) {
        this.input = String.format(this.hasAlpha ? "%08X" : "%06X", argb & ~this.alphaMask);
    }

    public void setOnChange(@Nullable IntConsumer onChange) {
        this.onChange = onChange;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int selectionStart = this.textRenderer.method_1727(this.input.substring(0, this.index));
        int selectionEnd = this.textRenderer.method_1727(this.input.substring(0, this.index + 1));
        int textX = this.method_46426() + (this.drawBackground ? 3 : 0);
        int n = this.method_46427();
        int n2 = this.method_25364();
        Objects.requireNonNull(this.textRenderer);
        int textY = n + (n2 - 9) / 2;
        if (this.drawBackground) {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), this.method_25370() ? -1 : -8355712);
            context.method_25294(this.method_46426() + 1, this.method_46427() + 1, this.method_55442() - 1, this.method_55443() - 1, -16777216);
        }
        if (this.method_25370()) {
            Objects.requireNonNull(this.textRenderer);
            context.method_25294(textX + selectionStart, textY, textX + selectionEnd, textY + 9, -16729089);
            Objects.requireNonNull(this.textRenderer);
            Objects.requireNonNull(this.textRenderer);
            context.method_25294(textX + selectionStart, textY + 9 - 1, textX + selectionEnd, textY + 9, -1);
        }
        context.method_51430(this.textRenderer, visitor -> {
            int start = this.hasAlpha ? 0 : 1;
            for (int i = 0; i < this.input.length(); ++i) {
                if (visitor.accept(i, this.method_25367() ? class_2583.field_24360.method_27706(FORMATTINGS[i / 2 + start]) : class_2583.field_24360, (int)this.input.charAt(i))) continue;
                return false;
            }
            return true;
        }, textX, textY, -1, true);
        if (this.method_49606()) {
            context.method_74037(class_11876.field_62453);
        }
    }

    protected void method_47399(class_6382 builder) {
    }

    public boolean method_25404(class_11908 keyInput) {
        boolean bl;
        if (!this.method_25370()) {
            return false;
        }
        switch (keyInput.comp_4795()) {
            case 261: {
                StringBuilder builder = new StringBuilder(this.input);
                builder.setCharAt(this.index, '0');
                this.input = builder.toString();
                boolean bl2 = true;
                break;
            }
            case 259: {
                StringBuilder builder = new StringBuilder(this.input);
                builder.setCharAt(this.index, '0');
                this.input = builder.toString();
                this.index = Math.max(0, this.index - 1);
                boolean bl2 = true;
                break;
            }
            case 263: {
                this.index = Math.max(0, this.index - 1);
                boolean bl2 = true;
                break;
            }
            case 262: {
                this.index = Math.min(this.length - 1, this.index + 1);
                boolean bl2 = true;
                break;
            }
            default: {
                boolean bl2 = bl = false;
            }
        }
        if (bl) {
            this.callOnChange();
            return true;
        }
        if (keyInput.method_74242()) {
            class_310.method_1551().field_1774.method_1455(this.input);
            return true;
        }
        if (keyInput.method_74243()) {
            String clipboard = class_310.method_1551().field_1774.method_1460();
            if (clipboard.startsWith("#")) {
                clipboard = clipboard.substring(1);
            }
            String s = clipboard.substring(0, Math.min(this.hasAlpha ? 8 : 6, clipboard.length()));
            this.getOptionalARGBColor(s.toUpperCase(Locale.ENGLISH)).ifPresent(color -> {
                this.setARGBColor(color);
                this.callOnChange();
            });
            return true;
        }
        return super.method_25404(keyInput);
    }

    public boolean method_25400(class_11905 input) {
        if (!this.method_25370()) {
            return false;
        }
        if (HEXADECIMAL_CHARS.contains(input.method_74226())) {
            this.input = new StringBuilder(this.input).replace(this.index, this.index + 1, input.method_74226().toUpperCase(Locale.ENGLISH)).toString();
            this.index = Math.min(this.length - 1, this.index + 1);
            this.callOnChange();
            return true;
        }
        return super.method_25400(input);
    }

    protected void callOnChange() {
        if (this.onChange != null) {
            this.onChange.accept(this.getARGBColor());
        }
    }

    public void method_25348(class_11909 click, boolean doubled) {
        super.method_25348(click, doubled);
        this.index = this.findClickedChar((int)click.comp_4798());
    }

    protected void method_25349(class_11909 click, double deltaX, double deltaY) {
        super.method_25349(click, deltaX, deltaY);
        this.index = this.findClickedChar((int)click.comp_4798());
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        OptionalInt anInt;
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        int i = this.findClickedChar((int)mouseX) / 2;
        int beginIndex = i * 2;
        try {
            int parsedInt = Integer.parseUnsignedInt(this.input.substring(beginIndex, beginIndex + 2), 16);
            anInt = OptionalInt.of(parsedInt);
        }
        catch (NumberFormatException e) {
            anInt = OptionalInt.empty();
            LOGGER.error("[Skyblocker] Failed to parse integer", (Throwable)e);
        }
        if (anInt.isPresent()) {
            int prev = anInt.getAsInt();
            int newInt = prev + (int)((double)((int)Math.signum(verticalAmount)) * Math.ceil(Math.abs(verticalAmount)));
            if ((newInt = Math.clamp((long)newInt, 0, 255)) != prev) {
                String format = String.format("%02X", newInt);
                this.input = new StringBuilder(this.input).replace(beginIndex, beginIndex + 2, format).toString();
                this.callOnChange();
            }
        }
        return true;
    }

    private int findClickedChar(int mouseX) {
        return Math.clamp((long)this.textRenderer.method_27523(this.input, mouseX - this.method_46426() - (this.drawBackground ? 3 : 0)).length(), 0, this.length - 1);
    }
}

